<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnInvoicePayment
 *
 * @ORM\Table(name="fn_invoice_payment", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_invoice_payment_trf_yn", columns={"fn_invoice_payment_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="fn_invoice_id", columns={"fn_invoice_id"})})
 * @ORM\Entity
 */
class FnInvoicePayment
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_payment_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnInvoicePaymentIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_payment_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $fnInvoicePaymentDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_invoice_payment_id", type="integer", nullable=false)
     */
    private $fnInvoicePaymentId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_payment_amt", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $fnInvPaymentAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_payment_bank", type="string", length=70, nullable=true)
     */
    private $fnInvPaymentBank;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_payment_curr", type="string", length=3, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvPaymentCurr;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fn_inv_payment_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $fnInvPaymentDate;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_payment_method", type="string", length=50, nullable=true)
     */
    private $fnInvPaymentMethod;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_payment_payer", type="string", length=95, nullable=true)
     */
    private $fnInvPaymentPayer;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_payment_ref", type="string", length=50, nullable=true)
     */
    private $fnInvPaymentRef;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_contra_id", type="string", length=36, nullable=true)
     */
    private $rvPaymentContraId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_id", type="string", length=18, nullable=true)
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_item_id", type="string", length=36, nullable=true)
     */
    private $rvPaymentItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_payment_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoicePaymentTrfYn;



    /**
     * Get fnInvoicePaymentIx
     *
     * @return string
     */
    public function getFnInvoicePaymentIx()
    {
        return $this->fnInvoicePaymentIx;
    }

    /**
     * Set fnInvoicePaymentDb
     *
     * @param string $fnInvoicePaymentDb
     *
     * @return FnInvoicePayment
     */
    public function setFnInvoicePaymentDb($fnInvoicePaymentDb)
    {
        $this->fnInvoicePaymentDb = $fnInvoicePaymentDb;

        return $this;
    }

    /**
     * Get fnInvoicePaymentDb
     *
     * @return string
     */
    public function getFnInvoicePaymentDb()
    {
        return $this->fnInvoicePaymentDb;
    }

    /**
     * Set fnInvoicePaymentId
     *
     * @param integer $fnInvoicePaymentId
     *
     * @return FnInvoicePayment
     */
    public function setFnInvoicePaymentId($fnInvoicePaymentId)
    {
        $this->fnInvoicePaymentId = $fnInvoicePaymentId;

        return $this;
    }

    /**
     * Get fnInvoicePaymentId
     *
     * @return integer
     */
    public function getFnInvoicePaymentId()
    {
        return $this->fnInvoicePaymentId;
    }

    /**
     * Set fnInvPaymentAmt
     *
     * @param string $fnInvPaymentAmt
     *
     * @return FnInvoicePayment
     */
    public function setFnInvPaymentAmt($fnInvPaymentAmt)
    {
        $this->fnInvPaymentAmt = $fnInvPaymentAmt;

        return $this;
    }

    /**
     * Get fnInvPaymentAmt
     *
     * @return string
     */
    public function getFnInvPaymentAmt()
    {
        return $this->fnInvPaymentAmt;
    }

    /**
     * Set fnInvPaymentBank
     *
     * @param string $fnInvPaymentBank
     *
     * @return FnInvoicePayment
     */
    public function setFnInvPaymentBank($fnInvPaymentBank)
    {
        $this->fnInvPaymentBank = $fnInvPaymentBank;

        return $this;
    }

    /**
     * Get fnInvPaymentBank
     *
     * @return string
     */
    public function getFnInvPaymentBank()
    {
        return $this->fnInvPaymentBank;
    }

    /**
     * Set fnInvPaymentCurr
     *
     * @param string $fnInvPaymentCurr
     *
     * @return FnInvoicePayment
     */
    public function setFnInvPaymentCurr($fnInvPaymentCurr)
    {
        $this->fnInvPaymentCurr = $fnInvPaymentCurr;

        return $this;
    }

    /**
     * Get fnInvPaymentCurr
     *
     * @return string
     */
    public function getFnInvPaymentCurr()
    {
        return $this->fnInvPaymentCurr;
    }

    /**
     * Set fnInvPaymentDate
     *
     * @param \DateTime $fnInvPaymentDate
     *
     * @return FnInvoicePayment
     */
    public function setFnInvPaymentDate($fnInvPaymentDate)
    {
        $this->fnInvPaymentDate = $fnInvPaymentDate;

        return $this;
    }

    /**
     * Get fnInvPaymentDate
     *
     * @return \DateTime
     */
    public function getFnInvPaymentDate()
    {
        return $this->fnInvPaymentDate;
    }

    /**
     * Set fnInvPaymentMethod
     *
     * @param string $fnInvPaymentMethod
     *
     * @return FnInvoicePayment
     */
    public function setFnInvPaymentMethod($fnInvPaymentMethod)
    {
        $this->fnInvPaymentMethod = $fnInvPaymentMethod;

        return $this;
    }

    /**
     * Get fnInvPaymentMethod
     *
     * @return string
     */
    public function getFnInvPaymentMethod()
    {
        return $this->fnInvPaymentMethod;
    }

    /**
     * Set fnInvPaymentPayer
     *
     * @param string $fnInvPaymentPayer
     *
     * @return FnInvoicePayment
     */
    public function setFnInvPaymentPayer($fnInvPaymentPayer)
    {
        $this->fnInvPaymentPayer = $fnInvPaymentPayer;

        return $this;
    }

    /**
     * Get fnInvPaymentPayer
     *
     * @return string
     */
    public function getFnInvPaymentPayer()
    {
        return $this->fnInvPaymentPayer;
    }

    /**
     * Set fnInvPaymentRef
     *
     * @param string $fnInvPaymentRef
     *
     * @return FnInvoicePayment
     */
    public function setFnInvPaymentRef($fnInvPaymentRef)
    {
        $this->fnInvPaymentRef = $fnInvPaymentRef;

        return $this;
    }

    /**
     * Get fnInvPaymentRef
     *
     * @return string
     */
    public function getFnInvPaymentRef()
    {
        return $this->fnInvPaymentRef;
    }

    /**
     * Set rvPaymentContraId
     *
     * @param string $rvPaymentContraId
     *
     * @return FnInvoicePayment
     */
    public function setRvPaymentContraId($rvPaymentContraId)
    {
        $this->rvPaymentContraId = $rvPaymentContraId;

        return $this;
    }

    /**
     * Get rvPaymentContraId
     *
     * @return string
     */
    public function getRvPaymentContraId()
    {
        return $this->rvPaymentContraId;
    }

    /**
     * Set fnInvoiceId
     *
     * @param string $fnInvoiceId
     *
     * @return FnInvoicePayment
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return string
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set rvPaymentItemId
     *
     * @param string $rvPaymentItemId
     *
     * @return FnInvoicePayment
     */
    public function setRvPaymentItemId($rvPaymentItemId)
    {
        $this->rvPaymentItemId = $rvPaymentItemId;

        return $this;
    }

    /**
     * Get rvPaymentItemId
     *
     * @return string
     */
    public function getRvPaymentItemId()
    {
        return $this->rvPaymentItemId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnInvoicePayment
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnInvoicePaymentTrfYn
     *
     * @param boolean $fnInvoicePaymentTrfYn
     *
     * @return FnInvoicePayment
     */
    public function setFnInvoicePaymentTrfYn($fnInvoicePaymentTrfYn)
    {
        $this->fnInvoicePaymentTrfYn = $fnInvoicePaymentTrfYn;

        return $this;
    }

    /**
     * Get fnInvoicePaymentTrfYn
     *
     * @return boolean
     */
    public function getFnInvoicePaymentTrfYn()
    {
        return $this->fnInvoicePaymentTrfYn;
    }
}
