<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnInvoiceSpecial
 *
 * @ORM\Table(name="fn_invoice_special", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_invoice_id", columns={"fn_invoice_id"}), @ORM\Index(name="fn_invoice_special_trf_yn", columns={"fn_invoice_special_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnInvoiceSpecial
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_special_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnInvoiceSpecialIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_special_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnInvoiceSpecialDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_invoice_special_id", type="integer", nullable=false)
     */
    private $fnInvoiceSpecialId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_special_desc", type="text", length=65535, nullable=true)
     */
    private $fnInvSpecialDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_inv_special_note", type="string", length=30, nullable=true)
     */
    private $fnInvSpecialNote;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_id", type="string", length=36, nullable=true)
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_invoice_special_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnInvoiceSpecialTrfYn;



    /**
     * Get fnInvoiceSpecialIx
     *
     * @return string
     */
    public function getFnInvoiceSpecialIx()
    {
        return $this->fnInvoiceSpecialIx;
    }

    /**
     * Set fnInvoiceSpecialDb
     *
     * @param string $fnInvoiceSpecialDb
     *
     * @return FnInvoiceSpecial
     */
    public function setFnInvoiceSpecialDb($fnInvoiceSpecialDb)
    {
        $this->fnInvoiceSpecialDb = $fnInvoiceSpecialDb;

        return $this;
    }

    /**
     * Get fnInvoiceSpecialDb
     *
     * @return string
     */
    public function getFnInvoiceSpecialDb()
    {
        return $this->fnInvoiceSpecialDb;
    }

    /**
     * Set fnInvoiceSpecialId
     *
     * @param integer $fnInvoiceSpecialId
     *
     * @return FnInvoiceSpecial
     */
    public function setFnInvoiceSpecialId($fnInvoiceSpecialId)
    {
        $this->fnInvoiceSpecialId = $fnInvoiceSpecialId;

        return $this;
    }

    /**
     * Get fnInvoiceSpecialId
     *
     * @return integer
     */
    public function getFnInvoiceSpecialId()
    {
        return $this->fnInvoiceSpecialId;
    }

    /**
     * Set fnInvSpecialDesc
     *
     * @param string $fnInvSpecialDesc
     *
     * @return FnInvoiceSpecial
     */
    public function setFnInvSpecialDesc($fnInvSpecialDesc)
    {
        $this->fnInvSpecialDesc = $fnInvSpecialDesc;

        return $this;
    }

    /**
     * Get fnInvSpecialDesc
     *
     * @return string
     */
    public function getFnInvSpecialDesc()
    {
        return $this->fnInvSpecialDesc;
    }

    /**
     * Set fnInvSpecialNote
     *
     * @param string $fnInvSpecialNote
     *
     * @return FnInvoiceSpecial
     */
    public function setFnInvSpecialNote($fnInvSpecialNote)
    {
        $this->fnInvSpecialNote = $fnInvSpecialNote;

        return $this;
    }

    /**
     * Get fnInvSpecialNote
     *
     * @return string
     */
    public function getFnInvSpecialNote()
    {
        return $this->fnInvSpecialNote;
    }

    /**
     * Set fnInvoiceId
     *
     * @param string $fnInvoiceId
     *
     * @return FnInvoiceSpecial
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return string
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnInvoiceSpecial
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnInvoiceSpecialTrfYn
     *
     * @param boolean $fnInvoiceSpecialTrfYn
     *
     * @return FnInvoiceSpecial
     */
    public function setFnInvoiceSpecialTrfYn($fnInvoiceSpecialTrfYn)
    {
        $this->fnInvoiceSpecialTrfYn = $fnInvoiceSpecialTrfYn;

        return $this;
    }

    /**
     * Get fnInvoiceSpecialTrfYn
     *
     * @return boolean
     */
    public function getFnInvoiceSpecialTrfYn()
    {
        return $this->fnInvoiceSpecialTrfYn;
    }
}
