<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnLedger
 *
 * @ORM\Table(name="fn_ledger", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_ledger_trf_yn", columns={"fn_ledger_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnLedger
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnLedgerIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $fnLedgerDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_ledger_id", type="integer", nullable=false)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_code", type="string", length=50, nullable=true)
     */
    private $fnLedgerCode;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_desc", type="string", length=50, nullable=true)
     */
    private $fnLedgerDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_ledger_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnLedgerInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_ledger_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnLedgerTrfYn;



    /**
     * Get fnLedgerIx
     *
     * @return string
     */
    public function getFnLedgerIx()
    {
        return $this->fnLedgerIx;
    }

    /**
     * Set fnLedgerDb
     *
     * @param string $fnLedgerDb
     *
     * @return FnLedger
     */
    public function setFnLedgerDb($fnLedgerDb)
    {
        $this->fnLedgerDb = $fnLedgerDb;

        return $this;
    }

    /**
     * Get fnLedgerDb
     *
     * @return string
     */
    public function getFnLedgerDb()
    {
        return $this->fnLedgerDb;
    }

    /**
     * Set fnLedgerId
     *
     * @param integer $fnLedgerId
     *
     * @return FnLedger
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return integer
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set fnLedgerCode
     *
     * @param string $fnLedgerCode
     *
     * @return FnLedger
     */
    public function setFnLedgerCode($fnLedgerCode)
    {
        $this->fnLedgerCode = $fnLedgerCode;

        return $this;
    }

    /**
     * Get fnLedgerCode
     *
     * @return string
     */
    public function getFnLedgerCode()
    {
        return $this->fnLedgerCode;
    }

    /**
     * Set fnLedgerDesc
     *
     * @param string $fnLedgerDesc
     *
     * @return FnLedger
     */
    public function setFnLedgerDesc($fnLedgerDesc)
    {
        $this->fnLedgerDesc = $fnLedgerDesc;

        return $this;
    }

    /**
     * Get fnLedgerDesc
     *
     * @return string
     */
    public function getFnLedgerDesc()
    {
        return $this->fnLedgerDesc;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnLedger
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnLedgerInactiveYn
     *
     * @param boolean $fnLedgerInactiveYn
     *
     * @return FnLedger
     */
    public function setFnLedgerInactiveYn($fnLedgerInactiveYn)
    {
        $this->fnLedgerInactiveYn = $fnLedgerInactiveYn;

        return $this;
    }

    /**
     * Get fnLedgerInactiveYn
     *
     * @return boolean
     */
    public function getFnLedgerInactiveYn()
    {
        return $this->fnLedgerInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnLedger
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnLedgerTrfYn
     *
     * @param boolean $fnLedgerTrfYn
     *
     * @return FnLedger
     */
    public function setFnLedgerTrfYn($fnLedgerTrfYn)
    {
        $this->fnLedgerTrfYn = $fnLedgerTrfYn;

        return $this;
    }

    /**
     * Get fnLedgerTrfYn
     *
     * @return boolean
     */
    public function getFnLedgerTrfYn()
    {
        return $this->fnLedgerTrfYn;
    }
}
