<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnOption
 *
 * @ORM\Table(name="fn_option", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_option_trf_yn", columns={"fn_option_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="fn_option_ix", columns={"fn_option_ix"})})
 * @ORM\Entity
 */
class FnOption
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnOptionIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnOptionDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_option_id", type="integer", nullable=false)
     */
    private $fnOptionId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_name", type="string", length=50, nullable=true)
     */
    private $fnOptionName;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_desc", type="text", length=65535, nullable=true)
     */
    private $fnOptionDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_option_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnOptionTrfYn;



    /**
     * Get fnOptionIx
     *
     * @return string
     */
    public function getFnOptionIx()
    {
        return $this->fnOptionIx;
    }

    /**
     * Set fnOptionDb
     *
     * @param string $fnOptionDb
     *
     * @return FnOption
     */
    public function setFnOptionDb($fnOptionDb)
    {
        $this->fnOptionDb = $fnOptionDb;

        return $this;
    }

    /**
     * Get fnOptionDb
     *
     * @return string
     */
    public function getFnOptionDb()
    {
        return $this->fnOptionDb;
    }

    /**
     * Set fnOptionId
     *
     * @param integer $fnOptionId
     *
     * @return FnOption
     */
    public function setFnOptionId($fnOptionId)
    {
        $this->fnOptionId = $fnOptionId;

        return $this;
    }

    /**
     * Get fnOptionId
     *
     * @return integer
     */
    public function getFnOptionId()
    {
        return $this->fnOptionId;
    }

    /**
     * Set fnOptionName
     *
     * @param string $fnOptionName
     *
     * @return FnOption
     */
    public function setFnOptionName($fnOptionName)
    {
        $this->fnOptionName = $fnOptionName;

        return $this;
    }

    /**
     * Get fnOptionName
     *
     * @return string
     */
    public function getFnOptionName()
    {
        return $this->fnOptionName;
    }

    /**
     * Set fnOptionDesc
     *
     * @param string $fnOptionDesc
     *
     * @return FnOption
     */
    public function setFnOptionDesc($fnOptionDesc)
    {
        $this->fnOptionDesc = $fnOptionDesc;

        return $this;
    }

    /**
     * Get fnOptionDesc
     *
     * @return string
     */
    public function getFnOptionDesc()
    {
        return $this->fnOptionDesc;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnOption
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnOptionTrfYn
     *
     * @param boolean $fnOptionTrfYn
     *
     * @return FnOption
     */
    public function setFnOptionTrfYn($fnOptionTrfYn)
    {
        $this->fnOptionTrfYn = $fnOptionTrfYn;

        return $this;
    }

    /**
     * Get fnOptionTrfYn
     *
     * @return boolean
     */
    public function getFnOptionTrfYn()
    {
        return $this->fnOptionTrfYn;
    }
}
