<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnOptionData
 *
 * @ORM\Table(name="fn_option_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_option_data_trf_yn", columns={"fn_option_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnOptionData
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $fnOptionDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnOptionDataDb = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_option_data_id", type="integer", nullable=false)
     */
    private $fnOptionDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_id", type="string", length=36, nullable=true)
     */
    private $fnOptionId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_data_contents", type="text", length=65535, nullable=true)
     */
    private $fnOptionDataContents;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_option_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnOptionDataTrfYn = 0;



    /**
     * Get fnOptionDataIx
     *
     * @return string
     */
    public function getFnOptionDataIx()
    {
        return $this->fnOptionDataIx;
    }

    /**
     * Set fnOptionDataDb
     *
     * @param string $fnOptionDataDb
     *
     * @return FnOptionData
     */
    public function setFnOptionDataDb($fnOptionDataDb)
    {
        $this->fnOptionDataDb = $fnOptionDataDb;

        return $this;
    }

    /**
     * Get fnOptionDataDb
     *
     * @return string
     */
    public function getFnOptionDataDb()
    {
        return $this->fnOptionDataDb;
    }

    /**
     * Set fnOptionDataId
     *
     * @param integer $fnOptionDataId
     *
     * @return FnOptionData
     */
    public function setFnOptionDataId($fnOptionDataId)
    {
        $this->fnOptionDataId = $fnOptionDataId;

        return $this;
    }

    /**
     * Get fnOptionDataId
     *
     * @return integer
     */
    public function getFnOptionDataId()
    {
        return $this->fnOptionDataId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnOptionData
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnOptionId
     *
     * @param string $fnOptionId
     *
     * @return FnOptionData
     */
    public function setFnOptionId($fnOptionId)
    {
        $this->fnOptionId = $fnOptionId;

        return $this;
    }

    /**
     * Get fnOptionId
     *
     * @return string
     */
    public function getFnOptionId()
    {
        return $this->fnOptionId;
    }

    /**
     * Set fnOptionDataContents
     *
     * @param string $fnOptionDataContents
     *
     * @return FnOptionData
     */
    public function setFnOptionDataContents($fnOptionDataContents)
    {
        $this->fnOptionDataContents = $fnOptionDataContents;

        return $this;
    }

    /**
     * Get fnOptionDataContents
     *
     * @return string
     */
    public function getFnOptionDataContents()
    {
        return $this->fnOptionDataContents;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnOptionData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnOptionDataTrfYn
     *
     * @param boolean $fnOptionDataTrfYn
     *
     * @return FnOptionData
     */
    public function setFnOptionDataTrfYn($fnOptionDataTrfYn)
    {
        $this->fnOptionDataTrfYn = $fnOptionDataTrfYn;

        return $this;
    }

    /**
     * Get fnOptionDataTrfYn
     *
     * @return boolean
     */
    public function getFnOptionDataTrfYn()
    {
        return $this->fnOptionDataTrfYn;
    }
}
