<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnPayment
 *
 * @ORM\Table(name="fn_payment", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, uniqueConstraints={@ORM\UniqueConstraint(name="fn_payment_ix", columns={"fn_payment_ix"})}, indexes={@ORM\Index(name="fn_invoice_id", columns={"fn_invoice_id"})})
 * @ORM\Entity
 */
class FnPayment
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_payment_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnPaymentDb = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_payment_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     */
    private $fnPaymentId = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="fn_payment_ix", type="string", length=36, nullable=true)
     */
    private $fnPaymentIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_pmnt_amt", type="decimal", precision=9, scale=2, nullable=true)
     */
    private $fnPmntAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_pmnt_bank", type="string", length=70, nullable=true)
     */
    private $fnPmntBank;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_pmnt_curr", type="string", length=50, nullable=true)
     */
    private $fnPmntCurr;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fn_pmnt_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $fnPmntDate = '0000-00-00';

    /**
     * @var string
     *
     * @ORM\Column(name="fn_pmnt_method", type="string", length=50, nullable=true)
     */
    private $fnPmntMethod;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_pmnt_payer", type="string", length=95, nullable=true)
     */
    private $fnPmntPayer;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_pmnt_ref", type="string", length=50, nullable=true)
     */
    private $fnPmntRef;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_pmnt_contra_id", type="string", length=36, nullable=true)
     */
    private $fnPmntContraId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_invoice_id", type="string", length=18, nullable=true)
     */
    private $fnInvoiceId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_item_id", type="string", length=36, nullable=true)
     */
    private $rvPaymentItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_payment_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnPaymentTrfYn = '0';



    /**
     * Set fnPaymentDb
     *
     * @param string $fnPaymentDb
     *
     * @return FnPayment
     */
    public function setFnPaymentDb($fnPaymentDb)
    {
        $this->fnPaymentDb = $fnPaymentDb;

        return $this;
    }

    /**
     * Get fnPaymentDb
     *
     * @return string
     */
    public function getFnPaymentDb()
    {
        return $this->fnPaymentDb;
    }

    /**
     * Set fnPaymentId
     *
     * @param integer $fnPaymentId
     *
     * @return FnPayment
     */
    public function setFnPaymentId($fnPaymentId)
    {
        $this->fnPaymentId = $fnPaymentId;

        return $this;
    }

    /**
     * Get fnPaymentId
     *
     * @return integer
     */
    public function getFnPaymentId()
    {
        return $this->fnPaymentId;
    }

    /**
     * Set fnPaymentIx
     *
     * @param string $fnPaymentIx
     *
     * @return FnPayment
     */
    public function setFnPaymentIx($fnPaymentIx)
    {
        $this->fnPaymentIx = $fnPaymentIx;

        return $this;
    }

    /**
     * Get fnPaymentIx
     *
     * @return string
     */
    public function getFnPaymentIx()
    {
        return $this->fnPaymentIx;
    }

    /**
     * Set fnPmntAmt
     *
     * @param string $fnPmntAmt
     *
     * @return FnPayment
     */
    public function setFnPmntAmt($fnPmntAmt)
    {
        $this->fnPmntAmt = $fnPmntAmt;

        return $this;
    }

    /**
     * Get fnPmntAmt
     *
     * @return string
     */
    public function getFnPmntAmt()
    {
        return $this->fnPmntAmt;
    }

    /**
     * Set fnPmntBank
     *
     * @param string $fnPmntBank
     *
     * @return FnPayment
     */
    public function setFnPmntBank($fnPmntBank)
    {
        $this->fnPmntBank = $fnPmntBank;

        return $this;
    }

    /**
     * Get fnPmntBank
     *
     * @return string
     */
    public function getFnPmntBank()
    {
        return $this->fnPmntBank;
    }

    /**
     * Set fnPmntCurr
     *
     * @param string $fnPmntCurr
     *
     * @return FnPayment
     */
    public function setFnPmntCurr($fnPmntCurr)
    {
        $this->fnPmntCurr = $fnPmntCurr;

        return $this;
    }

    /**
     * Get fnPmntCurr
     *
     * @return string
     */
    public function getFnPmntCurr()
    {
        return $this->fnPmntCurr;
    }

    /**
     * Set fnPmntDate
     *
     * @param \DateTime $fnPmntDate
     *
     * @return FnPayment
     */
    public function setFnPmntDate($fnPmntDate)
    {
        $this->fnPmntDate = $fnPmntDate;

        return $this;
    }

    /**
     * Get fnPmntDate
     *
     * @return \DateTime
     */
    public function getFnPmntDate()
    {
        return $this->fnPmntDate;
    }

    /**
     * Set fnPmntMethod
     *
     * @param string $fnPmntMethod
     *
     * @return FnPayment
     */
    public function setFnPmntMethod($fnPmntMethod)
    {
        $this->fnPmntMethod = $fnPmntMethod;

        return $this;
    }

    /**
     * Get fnPmntMethod
     *
     * @return string
     */
    public function getFnPmntMethod()
    {
        return $this->fnPmntMethod;
    }

    /**
     * Set fnPmntPayer
     *
     * @param string $fnPmntPayer
     *
     * @return FnPayment
     */
    public function setFnPmntPayer($fnPmntPayer)
    {
        $this->fnPmntPayer = $fnPmntPayer;

        return $this;
    }

    /**
     * Get fnPmntPayer
     *
     * @return string
     */
    public function getFnPmntPayer()
    {
        return $this->fnPmntPayer;
    }

    /**
     * Set fnPmntRef
     *
     * @param string $fnPmntRef
     *
     * @return FnPayment
     */
    public function setFnPmntRef($fnPmntRef)
    {
        $this->fnPmntRef = $fnPmntRef;

        return $this;
    }

    /**
     * Get fnPmntRef
     *
     * @return string
     */
    public function getFnPmntRef()
    {
        return $this->fnPmntRef;
    }

    /**
     * Set fnPmntContraId
     *
     * @param string $fnPmntContraId
     *
     * @return FnPayment
     */
    public function setFnPmntContraId($fnPmntContraId)
    {
        $this->fnPmntContraId = $fnPmntContraId;

        return $this;
    }

    /**
     * Get fnPmntContraId
     *
     * @return string
     */
    public function getFnPmntContraId()
    {
        return $this->fnPmntContraId;
    }

    /**
     * Set fnInvoiceId
     *
     * @param string $fnInvoiceId
     *
     * @return FnPayment
     */
    public function setFnInvoiceId($fnInvoiceId)
    {
        $this->fnInvoiceId = $fnInvoiceId;

        return $this;
    }

    /**
     * Get fnInvoiceId
     *
     * @return string
     */
    public function getFnInvoiceId()
    {
        return $this->fnInvoiceId;
    }

    /**
     * Set rvPaymentItemId
     *
     * @param string $rvPaymentItemId
     *
     * @return FnPayment
     */
    public function setRvPaymentItemId($rvPaymentItemId)
    {
        $this->rvPaymentItemId = $rvPaymentItemId;

        return $this;
    }

    /**
     * Get rvPaymentItemId
     *
     * @return string
     */
    public function getRvPaymentItemId()
    {
        return $this->rvPaymentItemId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnPayment
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnPaymentTrfYn
     *
     * @param boolean $fnPaymentTrfYn
     *
     * @return FnPayment
     */
    public function setFnPaymentTrfYn($fnPaymentTrfYn)
    {
        $this->fnPaymentTrfYn = $fnPaymentTrfYn;

        return $this;
    }

    /**
     * Get fnPaymentTrfYn
     *
     * @return boolean
     */
    public function getFnPaymentTrfYn()
    {
        return $this->fnPaymentTrfYn;
    }
}
