<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnSystem
 *
 * @ORM\Table(name="fn_system", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_system_trf_yn", columns={"fn_system_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="fn_system_ix", columns={"fn_system_ix"})})
 * @ORM\Entity
 */
class FnSystem
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnSystemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnSystemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_system_id", type="integer", nullable=false)
     */
    private $fnSystemId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_name", type="string", length=50, nullable=true)
     */
    private $fnSystemName;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_desc", type="string", length=50, nullable=true)
     */
    private $fnSystemDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_sys_credit_note_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSysCreditNoteYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_sys_debtor_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSysDebtorYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_sys_invoice_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSysInvoiceYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_sys_payment_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSysPaymentYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_sys_refund_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSysRefundYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_sys_tran_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSysTranYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_sys_tran_summary_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSysTranSummaryYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_sys_tax_groups_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $fnSysTaxGroupsYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_system_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSystemInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_system_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSystemTrfYn;



    /**
     * Get fnSystemIx
     *
     * @return string
     */
    public function getFnSystemIx()
    {
        return $this->fnSystemIx;
    }

    /**
     * Set fnSystemDb
     *
     * @param string $fnSystemDb
     *
     * @return FnSystem
     */
    public function setFnSystemDb($fnSystemDb)
    {
        $this->fnSystemDb = $fnSystemDb;

        return $this;
    }

    /**
     * Get fnSystemDb
     *
     * @return string
     */
    public function getFnSystemDb()
    {
        return $this->fnSystemDb;
    }

    /**
     * Set fnSystemId
     *
     * @param integer $fnSystemId
     *
     * @return FnSystem
     */
    public function setFnSystemId($fnSystemId)
    {
        $this->fnSystemId = $fnSystemId;

        return $this;
    }

    /**
     * Get fnSystemId
     *
     * @return integer
     */
    public function getFnSystemId()
    {
        return $this->fnSystemId;
    }

    /**
     * Set fnSystemName
     *
     * @param string $fnSystemName
     *
     * @return FnSystem
     */
    public function setFnSystemName($fnSystemName)
    {
        $this->fnSystemName = $fnSystemName;

        return $this;
    }

    /**
     * Get fnSystemName
     *
     * @return string
     */
    public function getFnSystemName()
    {
        return $this->fnSystemName;
    }

    /**
     * Set fnSystemDesc
     *
     * @param string $fnSystemDesc
     *
     * @return FnSystem
     */
    public function setFnSystemDesc($fnSystemDesc)
    {
        $this->fnSystemDesc = $fnSystemDesc;

        return $this;
    }

    /**
     * Get fnSystemDesc
     *
     * @return string
     */
    public function getFnSystemDesc()
    {
        return $this->fnSystemDesc;
    }

    /**
     * Set fnSysCreditNoteYn
     *
     * @param boolean $fnSysCreditNoteYn
     *
     * @return FnSystem
     */
    public function setFnSysCreditNoteYn($fnSysCreditNoteYn)
    {
        $this->fnSysCreditNoteYn = $fnSysCreditNoteYn;

        return $this;
    }

    /**
     * Get fnSysCreditNoteYn
     *
     * @return boolean
     */
    public function getFnSysCreditNoteYn()
    {
        return $this->fnSysCreditNoteYn;
    }

    /**
     * Set fnSysDebtorYn
     *
     * @param boolean $fnSysDebtorYn
     *
     * @return FnSystem
     */
    public function setFnSysDebtorYn($fnSysDebtorYn)
    {
        $this->fnSysDebtorYn = $fnSysDebtorYn;

        return $this;
    }

    /**
     * Get fnSysDebtorYn
     *
     * @return boolean
     */
    public function getFnSysDebtorYn()
    {
        return $this->fnSysDebtorYn;
    }

    /**
     * Set fnSysInvoiceYn
     *
     * @param boolean $fnSysInvoiceYn
     *
     * @return FnSystem
     */
    public function setFnSysInvoiceYn($fnSysInvoiceYn)
    {
        $this->fnSysInvoiceYn = $fnSysInvoiceYn;

        return $this;
    }

    /**
     * Get fnSysInvoiceYn
     *
     * @return boolean
     */
    public function getFnSysInvoiceYn()
    {
        return $this->fnSysInvoiceYn;
    }

    /**
     * Set fnSysPaymentYn
     *
     * @param boolean $fnSysPaymentYn
     *
     * @return FnSystem
     */
    public function setFnSysPaymentYn($fnSysPaymentYn)
    {
        $this->fnSysPaymentYn = $fnSysPaymentYn;

        return $this;
    }

    /**
     * Get fnSysPaymentYn
     *
     * @return boolean
     */
    public function getFnSysPaymentYn()
    {
        return $this->fnSysPaymentYn;
    }

    /**
     * Set fnSysRefundYn
     *
     * @param boolean $fnSysRefundYn
     *
     * @return FnSystem
     */
    public function setFnSysRefundYn($fnSysRefundYn)
    {
        $this->fnSysRefundYn = $fnSysRefundYn;

        return $this;
    }

    /**
     * Get fnSysRefundYn
     *
     * @return boolean
     */
    public function getFnSysRefundYn()
    {
        return $this->fnSysRefundYn;
    }

    /**
     * Set fnSysTranYn
     *
     * @param boolean $fnSysTranYn
     *
     * @return FnSystem
     */
    public function setFnSysTranYn($fnSysTranYn)
    {
        $this->fnSysTranYn = $fnSysTranYn;

        return $this;
    }

    /**
     * Get fnSysTranYn
     *
     * @return boolean
     */
    public function getFnSysTranYn()
    {
        return $this->fnSysTranYn;
    }

    /**
     * Set fnSysTranSummaryYn
     *
     * @param boolean $fnSysTranSummaryYn
     *
     * @return FnSystem
     */
    public function setFnSysTranSummaryYn($fnSysTranSummaryYn)
    {
        $this->fnSysTranSummaryYn = $fnSysTranSummaryYn;

        return $this;
    }

    /**
     * Get fnSysTranSummaryYn
     *
     * @return boolean
     */
    public function getFnSysTranSummaryYn()
    {
        return $this->fnSysTranSummaryYn;
    }

    /**
     * Set fnSysTaxGroupsYn
     *
     * @param boolean $fnSysTaxGroupsYn
     *
     * @return FnSystem
     */
    public function setFnSysTaxGroupsYn($fnSysTaxGroupsYn)
    {
        $this->fnSysTaxGroupsYn = $fnSysTaxGroupsYn;

        return $this;
    }

    /**
     * Get fnSysTaxGroupsYn
     *
     * @return boolean
     */
    public function getFnSysTaxGroupsYn()
    {
        return $this->fnSysTaxGroupsYn;
    }

    /**
     * Set fnSystemInactiveYn
     *
     * @param boolean $fnSystemInactiveYn
     *
     * @return FnSystem
     */
    public function setFnSystemInactiveYn($fnSystemInactiveYn)
    {
        $this->fnSystemInactiveYn = $fnSystemInactiveYn;

        return $this;
    }

    /**
     * Get fnSystemInactiveYn
     *
     * @return boolean
     */
    public function getFnSystemInactiveYn()
    {
        return $this->fnSystemInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnSystem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnSystemTrfYn
     *
     * @param boolean $fnSystemTrfYn
     *
     * @return FnSystem
     */
    public function setFnSystemTrfYn($fnSystemTrfYn)
    {
        $this->fnSystemTrfYn = $fnSystemTrfYn;

        return $this;
    }

    /**
     * Get fnSystemTrfYn
     *
     * @return boolean
     */
    public function getFnSystemTrfYn()
    {
        return $this->fnSystemTrfYn;
    }
}
