<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnSystemOption
 *
 * @ORM\Table(name="fn_system_option")
 * @ORM\Entity
 */
class FnSystemOption
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_option_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnSystemOptionIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_option_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnSystemOptionDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_system_option_id", type="integer", nullable=false)
     */
    private $fnSystemOptionId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_id", type="string", length=36, nullable=true)
     */
    private $fnSystemId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_option_id", type="string", length=36, nullable=true)
     */
    private $fnOptionId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_option_desc", type="text", length=65535, nullable=true)
     */
    private $fnSystemOptionDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_option_default", type="text", length=65535, nullable=true)
     */
    private $fnSystemOptionDefault;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_system_option_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnSystemOptionTrfYn;

    /**
     * Get fnSystemOptionIx
     *
     * @return string
     */
    public function getFnSystemOptionIx()
    {
        return $this->fnSystemOptionIx;
    }

    /**
     * Set fnSystemOptionDb
     *
     * @param string $fnSystemOptionDb
     *
     * @return FnSystemOption
     */
    public function setFnSystemOptionDb($fnSystemOptionDb)
    {
        $this->fnSystemOptionDb = $fnSystemOptionDb;

        return $this;
    }

    /**
     * Get fnSystemOptionDb
     *
     * @return string
     */
    public function getFnSystemOptionDb()
    {
        return $this->fnSystemOptionDb;
    }

    /**
     * Set fnSystemOptionId
     *
     * @param integer $fnSystemOptionId
     *
     * @return FnSystemOption
     */
    public function setFnSystemOptionId($fnSystemOptionId)
    {
        $this->fnSystemOptionId = $fnSystemOptionId;

        return $this;
    }

    /**
     * Get fnSystemOptionId
     *
     * @return integer
     */
    public function getFnSystemOptionId()
    {
        return $this->fnSystemOptionId;
    }

    /**
     * Set fnSystemId
     *
     * @param string $fnSystemId
     *
     * @return PrBusiness
     */
    public function setFnSystemId($fnSystemId)
    {
        $this->fnSystemId = $fnSystemId;

        return $this;
    }

    /**
     * Get fnSystemId
     *
     * @return string
     */
    public function getFnSystemId()
    {
        return $this->fnSystemId;
    }

    /**
     * Set fnOptionId
     *
     * @param string $fnOptionId
     *
     * @return FnOptionData
     */
    public function setFnOptionId($fnOptionId)
    {
        $this->fnOptionId = $fnOptionId;

        return $this;
    }

    /**
     * Get fnOptionId
     *
     * @return string
     */
    public function getFnOptionId()
    {
        return $this->fnOptionId;
    }

    /**
     * Set fnSystemOptionDesc
     *
     * @param string $fnSystemOptionDesc
     *
     * @return FnSystemOption
     */
    public function setFnSystemOptionDesc($fnSystemOptionDesc)
    {
        $this->fnSystemOptionDesc = $fnSystemOptionDesc;

        return $this;
    }

    /**
     * Get fnSystemOptionDesc
     *
     * @return string
     */
    public function getFnSystemOptionDesc()
    {
        return $this->fnSystemOptionDesc;
    }

    /**
     * Set fnSystemOptionDefault
     *
     * @param string $fnSystemOptionDefault
     *
     * @return FnSystemOption
     */
    public function setFnSystemOptionDefault($fnSystemOptionDefault)
    {
        $this->fnSystemOptionDefault = $fnSystemOptionDefault;

        return $this;
    }

    /**
     * Get fnSystemOptionDefault
     *
     * @return string
     */
    public function getFnSystemOptionDefault()
    {
        return $this->fnSystemOptionDefault;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnOption
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnSystemOptionTrfYn
     *
     * @param boolean $fnSystemOptionTrfYn
     *
     * @return FnSystemOption
     */
    public function setFnSystemOptionTrfYn($fnSystemOptionTrfYn)
    {
        $this->fnSystemOptionTrfYn = $fnSystemOptionTrfYn;

        return $this;
    }

    /**
     * Get fnSystemOptionTrfYn
     *
     * @return boolean
     */
    public function getFnSystemOptionTrfYn()
    {
        return $this->fnSystemOptionTrfYn;
    }
}