<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnTran
 *
 * @ORM\Table(name="fn_tran", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_tran_trf_yn", columns={"fn_tran_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="fn_batch_id", columns={"fn_batch_id"}), @ORM\Index(name="pr_business_id", columns={"pr_business_id"}), @ORM\Index(name="fn_tran_link_source_id", columns={"fn_tran_link_id"})})
 * @ORM\Entity
 */
class FnTran
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnTranIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnTranDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_tran_id", type="integer", nullable=false)
     */
    private $fnTranId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_amt_excl", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnTranAmtExcl;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_amt_incl", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnTranAmtIncl;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_amt_source", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnTranAmtSource;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fn_tran_date_ledger", type="datetime", nullable=true)
     */
    private $fnTranDateLedger;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_detail", type="text", length=16777215, nullable=true)
     */
    private $fnTranDetail;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_exch_rate", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnTranExchRate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_tran_inv_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnTranInvYn;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_contra_id", type="string", length=36, nullable=true)
     */
    private $fnTranContraId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_tran_link_ind", type="boolean", nullable=true)
     */
    private $fnTranLinkInd;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_link_id", type="string", length=36, nullable=true)
     */
    private $fnTranLinkId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_batch_id", type="string", length=36, nullable=true)
     */
    private $fnBatchId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_folio_id", type="string", length=36, nullable=true)
     */
    private $fnFolioId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=true)
     */
    private $prPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_ctl_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerCtlId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_reservation_id", type="string", length=36, nullable=true)
     */
    private $rvReservationId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_tran_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnTranTrfYn;



    /**
     * Get fnTranIx
     *
     * @return string
     */
    public function getFnTranIx()
    {
        return $this->fnTranIx;
    }

    /**
     * Set fnTranDb
     *
     * @param string $fnTranDb
     *
     * @return FnTran
     */
    public function setFnTranDb($fnTranDb)
    {
        $this->fnTranDb = $fnTranDb;

        return $this;
    }

    /**
     * Get fnTranDb
     *
     * @return string
     */
    public function getFnTranDb()
    {
        return $this->fnTranDb;
    }

    /**
     * Set fnTranId
     *
     * @param integer $fnTranId
     *
     * @return FnTran
     */
    public function setFnTranId($fnTranId)
    {
        $this->fnTranId = $fnTranId;

        return $this;
    }

    /**
     * Get fnTranId
     *
     * @return integer
     */
    public function getFnTranId()
    {
        return $this->fnTranId;
    }

    /**
     * Set fnTranAmtExcl
     *
     * @param string $fnTranAmtExcl
     *
     * @return FnTran
     */
    public function setFnTranAmtExcl($fnTranAmtExcl)
    {
        $this->fnTranAmtExcl = $fnTranAmtExcl;

        return $this;
    }

    /**
     * Get fnTranAmtExcl
     *
     * @return string
     */
    public function getFnTranAmtExcl()
    {
        return $this->fnTranAmtExcl;
    }

    /**
     * Set fnTranAmtIncl
     *
     * @param string $fnTranAmtIncl
     *
     * @return FnTran
     */
    public function setFnTranAmtIncl($fnTranAmtIncl)
    {
        $this->fnTranAmtIncl = $fnTranAmtIncl;

        return $this;
    }

    /**
     * Get fnTranAmtIncl
     *
     * @return string
     */
    public function getFnTranAmtIncl()
    {
        return $this->fnTranAmtIncl;
    }

    /**
     * Set fnTranAmtSource
     *
     * @param string $fnTranAmtSource
     *
     * @return FnTran
     */
    public function setFnTranAmtSource($fnTranAmtSource)
    {
        $this->fnTranAmtSource = $fnTranAmtSource;

        return $this;
    }

    /**
     * Get fnTranAmtSource
     *
     * @return string
     */
    public function getFnTranAmtSource()
    {
        return $this->fnTranAmtSource;
    }

    /**
     * Set fnTranDateLedger
     *
     * @param \DateTime $fnTranDateLedger
     *
     * @return FnTran
     */
    public function setFnTranDateLedger($fnTranDateLedger)
    {
        $this->fnTranDateLedger = $fnTranDateLedger;

        return $this;
    }

    /**
     * Get fnTranDateLedger
     *
     * @return \DateTime
     */
    public function getFnTranDateLedger()
    {
        return $this->fnTranDateLedger;
    }

    /**
     * Set fnTranDetail
     *
     * @param string $fnTranDetail
     *
     * @return FnTran
     */
    public function setFnTranDetail($fnTranDetail)
    {
        $this->fnTranDetail = $fnTranDetail;

        return $this;
    }

    /**
     * Get fnTranDetail
     *
     * @return string
     */
    public function getFnTranDetail()
    {
        return $this->fnTranDetail;
    }

    /**
     * Set fnTranExchRate
     *
     * @param string $fnTranExchRate
     *
     * @return FnTran
     */
    public function setFnTranExchRate($fnTranExchRate)
    {
        $this->fnTranExchRate = $fnTranExchRate;

        return $this;
    }

    /**
     * Get fnTranExchRate
     *
     * @return string
     */
    public function getFnTranExchRate()
    {
        return $this->fnTranExchRate;
    }

    /**
     * Set fnTranInvYn
     *
     * @param boolean $fnTranInvYn
     *
     * @return FnTran
     */
    public function setFnTranInvYn($fnTranInvYn)
    {
        $this->fnTranInvYn = $fnTranInvYn;

        return $this;
    }

    /**
     * Get fnTranInvYn
     *
     * @return boolean
     */
    public function getFnTranInvYn()
    {
        return $this->fnTranInvYn;
    }

    /**
     * Set fnTranContraId
     *
     * @param string $fnTranContraId
     *
     * @return FnTran
     */
    public function setFnTranContraId($fnTranContraId)
    {
        $this->fnTranContraId = $fnTranContraId;

        return $this;
    }

    /**
     * Get fnTranContraId
     *
     * @return string
     */
    public function getFnTranContraId()
    {
        return $this->fnTranContraId;
    }

    /**
     * Set fnTranLinkInd
     *
     * @param boolean $fnTranLinkInd
     *
     * @return FnTran
     */
    public function setFnTranLinkInd($fnTranLinkInd)
    {
        $this->fnTranLinkInd = $fnTranLinkInd;

        return $this;
    }

    /**
     * Get fnTranLinkInd
     *
     * @return boolean
     */
    public function getFnTranLinkInd()
    {
        return $this->fnTranLinkInd;
    }

    /**
     * Set fnTranLinkId
     *
     * @param string $fnTranLinkId
     *
     * @return FnTran
     */
    public function setFnTranLinkId($fnTranLinkId)
    {
        $this->fnTranLinkId = $fnTranLinkId;

        return $this;
    }

    /**
     * Get fnTranLinkId
     *
     * @return string
     */
    public function getFnTranLinkId()
    {
        return $this->fnTranLinkId;
    }

    /**
     * Set fnBatchId
     *
     * @param string $fnBatchId
     *
     * @return FnTran
     */
    public function setFnBatchId($fnBatchId)
    {
        $this->fnBatchId = $fnBatchId;

        return $this;
    }

    /**
     * Get fnBatchId
     *
     * @return string
     */
    public function getFnBatchId()
    {
        return $this->fnBatchId;
    }

    /**
     * Set fnFolioId
     *
     * @param string $fnFolioId
     *
     * @return FnTran
     */
    public function setFnFolioId($fnFolioId)
    {
        $this->fnFolioId = $fnFolioId;

        return $this;
    }

    /**
     * Get fnFolioId
     *
     * @return string
     */
    public function getFnFolioId()
    {
        return $this->fnFolioId;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return FnTran
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set fnLedgerCtlId
     *
     * @param string $fnLedgerCtlId
     *
     * @return FnTran
     */
    public function setFnLedgerCtlId($fnLedgerCtlId)
    {
        $this->fnLedgerCtlId = $fnLedgerCtlId;

        return $this;
    }

    /**
     * Get fnLedgerCtlId
     *
     * @return string
     */
    public function getFnLedgerCtlId()
    {
        return $this->fnLedgerCtlId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnTran
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return FnTran
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rvReservationId
     *
     * @param string $rvReservationId
     *
     * @return FnTran
     */
    public function setRvReservationId($rvReservationId)
    {
        $this->rvReservationId = $rvReservationId;

        return $this;
    }

    /**
     * Get rvReservationId
     *
     * @return string
     */
    public function getRvReservationId()
    {
        return $this->rvReservationId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return FnTran
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return FnTran
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return FnTran
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return FnTran
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return FnTran
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return FnTran
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return FnTran
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return FnTran
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return FnTran
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnTran
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnTranTrfYn
     *
     * @param boolean $fnTranTrfYn
     *
     * @return FnTran
     */
    public function setFnTranTrfYn($fnTranTrfYn)
    {
        $this->fnTranTrfYn = $fnTranTrfYn;

        return $this;
    }

    /**
     * Get fnTranTrfYn
     *
     * @return boolean
     */
    public function getFnTranTrfYn()
    {
        return $this->fnTranTrfYn;
    }
}
