<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnTranItem
 *
 * @ORM\Table(name="fn_tran_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="fn_tran_id", columns={"fn_tran_id"}), @ORM\Index(name="fn_ledger_id", columns={"fn_ledger_id"}), @ORM\Index(name="fn_tran_item_trf_yn", columns={"fn_tran_item_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnTranItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnTranItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_item_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnTranItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_tran_item_id", type="integer", nullable=false)
     */
    private $fnTranItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_item_amt", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnTranItemAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_item_amt_incl", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnTranItemAmtIncl;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_item_amt_source", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnTranItemAmtSource;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_item_amt_source_incl", type="decimal", precision=16, scale=6, nullable=true)
     */
    private $fnTranItemAmtSourceIncl;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_tran_item_type_ind", type="boolean", nullable=true)
     */
    private $fnTranItemTypeInd;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_id", type="string", length=36, nullable=true)
     */
    private $fnDebtorId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_cost_ctr1_id", type="string", length=36, nullable=true)
     */
    private $fnTranCostCtr1Id;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_cost_ctr2_id", type="string", length=36, nullable=true)
     */
    private $fnTranCostCtr2Id;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_tran_id", type="string", length=36, nullable=true)
     */
    private $fnTranId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_inv_id", type="string", length=36, nullable=true)
     */
    private $rfTaxRateInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="rv_payment_item_id", type="string", length=36, nullable=true)
     */
    private $rvPaymentItemId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_tran_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnTranItemTrfYn;



    /**
     * Get fnTranItemIx
     *
     * @return string
     */
    public function getFnTranItemIx()
    {
        return $this->fnTranItemIx;
    }

    /**
     * Set fnTranItemDb
     *
     * @param string $fnTranItemDb
     *
     * @return FnTranItem
     */
    public function setFnTranItemDb($fnTranItemDb)
    {
        $this->fnTranItemDb = $fnTranItemDb;

        return $this;
    }

    /**
     * Get fnTranItemDb
     *
     * @return string
     */
    public function getFnTranItemDb()
    {
        return $this->fnTranItemDb;
    }

    /**
     * Set fnTranItemId
     *
     * @param integer $fnTranItemId
     *
     * @return FnTranItem
     */
    public function setFnTranItemId($fnTranItemId)
    {
        $this->fnTranItemId = $fnTranItemId;

        return $this;
    }

    /**
     * Get fnTranItemId
     *
     * @return integer
     */
    public function getFnTranItemId()
    {
        return $this->fnTranItemId;
    }

    /**
     * Set fnTranItemAmt
     *
     * @param string $fnTranItemAmt
     *
     * @return FnTranItem
     */
    public function setFnTranItemAmt($fnTranItemAmt)
    {
        $this->fnTranItemAmt = $fnTranItemAmt;

        return $this;
    }

    /**
     * Get fnTranItemAmt
     *
     * @return string
     */
    public function getFnTranItemAmt()
    {
        return $this->fnTranItemAmt;
    }

    /**
     * Set fnTranItemAmtIncl
     *
     * @param string $fnTranItemAmtIncl
     *
     * @return FnTranItem
     */
    public function setFnTranItemAmtIncl($fnTranItemAmtIncl)
    {
        $this->fnTranItemAmtIncl = $fnTranItemAmtIncl;

        return $this;
    }

    /**
     * Get fnTranItemAmtIncl
     *
     * @return string
     */
    public function getFnTranItemAmtIncl()
    {
        return $this->fnTranItemAmtIncl;
    }

    /**
     * Set fnTranItemAmtSource
     *
     * @param string $fnTranItemAmtSource
     *
     * @return FnTranItem
     */
    public function setFnTranItemAmtSource($fnTranItemAmtSource)
    {
        $this->fnTranItemAmtSource = $fnTranItemAmtSource;

        return $this;
    }

    /**
     * Get fnTranItemAmtSource
     *
     * @return string
     */
    public function getFnTranItemAmtSource()
    {
        return $this->fnTranItemAmtSource;
    }

     /**
     * Set fnTranItemAmtSourceIncl
     *
     * @param string $fnTranItemAmtSourceIncl
     *
     * @return FnTranItem
     */
    public function setFnTranItemAmtSourceIncl($fnTranItemAmtSourceIncl)
    {
        $this->fnTranItemAmtSourceIncl = $fnTranItemAmtSourceIncl;

        return $this;
    }

    /**
     * Get fnTranItemAmtSourceIncl
     *
     * @return string
     */
    public function getFnTranItemAmtSourceIncl()
    {
        return $this->fnTranItemAmtSourceIncl;
    }

    /**
     * Set fnTranItemTypeInd
     *
     * @param boolean $fnTranItemTypeInd
     *
     * @return FnTranItem
     */
    public function setFnTranItemTypeInd($fnTranItemTypeInd)
    {
        $this->fnTranItemTypeInd = $fnTranItemTypeInd;

        return $this;
    }

    /**
     * Get fnTranItemTypeInd
     *
     * @return boolean
     */
    public function getFnTranItemTypeInd()
    {
        return $this->fnTranItemTypeInd;
    }

    /**
     * Set fnLedgerId
     *
     * @param string $fnLedgerId
     *
     * @return FnTranItem
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return string
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set fnDebtorId
     *
     * @param string $fnDebtorId
     *
     * @return FnTranItem
     */
    public function setFnDebtorId($fnDebtorId)
    {
        $this->fnDebtorId = $fnDebtorId;

        return $this;
    }

    /**
     * Get fnDebtorId
     *
     * @return string
     */
    public function getFnDebtorId()
    {
        return $this->fnDebtorId;
    }

    /**
     * Set fnTranCostCtr1Id
     *
     * @param string $fnTranCostCtr1Id
     *
     * @return FnTranItem
     */
    public function setFnTranCostCtr1Id($fnTranCostCtr1Id)
    {
        $this->fnTranCostCtr1Id = $fnTranCostCtr1Id;

        return $this;
    }

    /**
     * Get fnTranCostCtr1Id
     *
     * @return string
     */
    public function getFnTranCostCtr1Id()
    {
        return $this->fnTranCostCtr1Id;
    }

    /**
     * Set fnTranCostCtr2Id
     *
     * @param string $fnTranCostCtr2Id
     *
     * @return FnTranItem
     */
    public function setFnTranCostCtr2Id($fnTranCostCtr2Id)
    {
        $this->fnTranCostCtr2Id = $fnTranCostCtr2Id;

        return $this;
    }

    /**
     * Get fnTranCostCtr2Id
     *
     * @return string
     */
    public function getFnTranCostCtr2Id()
    {
        return $this->fnTranCostCtr2Id;
    }

    /**
     * Set fnTranId
     *
     * @param string $fnTranId
     *
     * @return FnTranItem
     */
    public function setFnTranId($fnTranId)
    {
        $this->fnTranId = $fnTranId;

        return $this;
    }

    /**
     * Get fnTranId
     *
     * @return string
     */
    public function getFnTranId()
    {
        return $this->fnTranId;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return FnTranItem
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rfTaxRateInvId
     *
     * @param string $rfTaxRateInvId
     *
     * @return FnTranItem
     */
    public function setRfTaxRateInvId($rfTaxRateInvId)
    {
        $this->rfTaxRateInvId = $rfTaxRateInvId;

        return $this;
    }

    /**
     * Get rfTaxRateInvId
     *
     * @return string
     */
    public function getRfTaxRateInvId()
    {
        return $this->rfTaxRateInvId;
    }

    /**
     * Set rvPaymentItemId
     *
     * @param string $rvPaymentItemId
     *
     * @return FnTranItem
     */
    public function setRvPaymentItemId($rvPaymentItemId)
    {
        $this->rvPaymentItemId = $rvPaymentItemId;

        return $this;
    }

    /**
     * Get rvPaymentItemId
     *
     * @return string
     */
    public function getRvPaymentItemId()
    {
        return $this->rvPaymentItemId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return FnTranItem
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return FnTranItem
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return FnTranItem
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return FnTranItem
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return FnTranItem
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return FnTranItem
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return FnTranItem
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return FnTranItem
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return FnTranItem
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnTranItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnTranItemTrfYn
     *
     * @param boolean $fnTranItemTrfYn
     *
     * @return FnTranItem
     */
    public function setFnTranItemTrfYn($fnTranItemTrfYn)
    {
        $this->fnTranItemTrfYn = $fnTranItemTrfYn;

        return $this;
    }

    /**
     * Get fnTranItemTrfYn
     *
     * @return boolean
     */
    public function getFnTranItemTrfYn()
    {
        return $this->fnTranItemTrfYn;
    }
}
