<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FnYear
 *
 * @ORM\Table(name="fn_year", indexes={@ORM\Index(name="fn_year_trf_yn", columns={"fn_year_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class FnYear
{
    /**
     * @var string
     *
     * @ORM\Column(name="fn_year_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $fnYearIx;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_year_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $fnYearDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="fn_year_id", type="integer", nullable=false)
     */
    private $fnYearId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_year_desc", type="string", length=20, nullable=true)
     */
    private $fnYearDesc;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fn_year_end_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $fnYearEndDate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_year_status_ind", type="boolean", nullable=false, options={"default"="2"})
     */
    private $fnYearStatusInd;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="fn_year_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $fnYearTrfYn;



    /**
     * Get fnYearIx
     *
     * @return string
     */
    public function getFnYearIx()
    {
        return $this->fnYearIx;
    }

    /**
     * Set fnYearDb
     *
     * @param string $fnYearDb
     *
     * @return FnYear
     */
    public function setFnYearDb($fnYearDb)
    {
        $this->fnYearDb = $fnYearDb;

        return $this;
    }

    /**
     * Get fnYearDb
     *
     * @return string
     */
    public function getFnYearDb()
    {
        return $this->fnYearDb;
    }

    /**
     * Set fnYearId
     *
     * @param integer $fnYearId
     *
     * @return FnYear
     */
    public function setFnYearId($fnYearId)
    {
        $this->fnYearId = $fnYearId;

        return $this;
    }

    /**
     * Get fnYearId
     *
     * @return integer
     */
    public function getFnYearId()
    {
        return $this->fnYearId;
    }

    /**
     * Set fnYearDesc
     *
     * @param string $fnYearDesc
     *
     * @return FnYear
     */
    public function setFnYearDesc($fnYearDesc)
    {
        $this->fnYearDesc = $fnYearDesc;

        return $this;
    }

    /**
     * Get fnYearDesc
     *
     * @return string
     */
    public function getFnYearDesc()
    {
        return $this->fnYearDesc;
    }

    /**
     * Set fnYearEndDate
     *
     * @param \DateTime $fnYearEndDate
     *
     * @return FnYear
     */
    public function setFnYearEndDate($fnYearEndDate)
    {
        $this->fnYearEndDate = $fnYearEndDate;

        return $this;
    }

    /**
     * Get fnYearEndDate
     *
     * @return \DateTime
     */
    public function getFnYearEndDate()
    {
        return $this->fnYearEndDate;
    }

    /**
     * Set fnYearStatusInd
     *
     * @param boolean $fnYearStatusInd
     *
     * @return FnYear
     */
    public function setFnYearStatusInd($fnYearStatusInd)
    {
        $this->fnYearStatusInd = $fnYearStatusInd;

        return $this;
    }

    /**
     * Get fnYearStatusInd
     *
     * @return boolean
     */
    public function getFnYearStatusInd()
    {
        return $this->fnYearStatusInd;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return FnYear
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return FnYear
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return FnYear
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return FnYear
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return FnYear
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set fnYearTrfYn
     *
     * @param boolean $fnYearTrfYn
     *
     * @return FnYear
     */
    public function setFnYearTrfYn($fnYearTrfYn)
    {
        $this->fnYearTrfYn = $fnYearTrfYn;

        return $this;
    }

    /**
     * Get fnYearTrfYn
     *
     * @return boolean
     */
    public function getFnYearTrfYn()
    {
        return $this->fnYearTrfYn;
    }
}
