<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PfField
 *
 * @ORM\Table(name="pf_field", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pf_field_trf_yn", columns={"pf_field_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PfField
{
    /**
     * @var string
     *
     * @ORM\Column(name="pf_field_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pfFieldIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_field_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pfFieldDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pf_field_id", type="integer", nullable=false)
     */
    private $pfFieldId;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_field_contents", type="text", length=16777215, nullable=true)
     */
    private $pfFieldContents;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_field_name", type="string", length=50, nullable=true)
     */
    private $pfFieldName;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_option_id", type="string", length=36, nullable=true)
     */
    private $pfOptionId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pf_field_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pfFieldTrfYn;



    /**
     * Get pfFieldIx
     *
     * @return string
     */
    public function getPfFieldIx()
    {
        return $this->pfFieldIx;
    }

    /**
     * Set pfFieldDb
     *
     * @param string $pfFieldDb
     *
     * @return PfField
     */
    public function setPfFieldDb($pfFieldDb)
    {
        $this->pfFieldDb = $pfFieldDb;

        return $this;
    }

    /**
     * Get pfFieldDb
     *
     * @return string
     */
    public function getPfFieldDb()
    {
        return $this->pfFieldDb;
    }

    /**
     * Set pfFieldId
     *
     * @param integer $pfFieldId
     *
     * @return PfField
     */
    public function setPfFieldId($pfFieldId)
    {
        $this->pfFieldId = $pfFieldId;

        return $this;
    }

    /**
     * Get pfFieldId
     *
     * @return integer
     */
    public function getPfFieldId()
    {
        return $this->pfFieldId;
    }

    /**
     * Set pfFieldContents
     *
     * @param string $pfFieldContents
     *
     * @return PfField
     */
    public function setPfFieldContents($pfFieldContents)
    {
        $this->pfFieldContents = $pfFieldContents;

        return $this;
    }

    /**
     * Get pfFieldContents
     *
     * @return string
     */
    public function getPfFieldContents()
    {
        return $this->pfFieldContents;
    }

    /**
     * Set pfFieldName
     *
     * @param string $pfFieldName
     *
     * @return PfField
     */
    public function setPfFieldName($pfFieldName)
    {
        $this->pfFieldName = $pfFieldName;

        return $this;
    }

    /**
     * Get pfFieldName
     *
     * @return string
     */
    public function getPfFieldName()
    {
        return $this->pfFieldName;
    }

    /**
     * Set pfOptionId
     *
     * @param string $pfOptionId
     *
     * @return PfField
     */
    public function setPfOptionId($pfOptionId)
    {
        $this->pfOptionId = $pfOptionId;

        return $this;
    }

    /**
     * Get pfOptionId
     *
     * @return string
     */
    public function getPfOptionId()
    {
        return $this->pfOptionId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PfField
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pfFieldTrfYn
     *
     * @param boolean $pfFieldTrfYn
     *
     * @return PfField
     */
    public function setPfFieldTrfYn($pfFieldTrfYn)
    {
        $this->pfFieldTrfYn = $pfFieldTrfYn;

        return $this;
    }

    /**
     * Get pfFieldTrfYn
     *
     * @return boolean
     */
    public function getPfFieldTrfYn()
    {
        return $this->pfFieldTrfYn;
    }
}
