<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PfObject
 *
 * @ORM\Table(name="pf_object", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pf_object_trf_yn", columns={"pf_object_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="pf_object_ix", columns={"pf_object_ix"})})
 * @ORM\Entity
 */
class PfObject
{
    /**
     * @var string
     *
     * @ORM\Column(name="pf_object_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pfObjectIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_object_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pfObjectDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pf_object_id", type="integer", nullable=false)
     */
    private $pfObjectId;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_object_name", type="string", length=50, nullable=true)
     */
    private $pfObjectName;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_object_note", type="string", length=255, nullable=true)
     */
    private $pfObjectNote;

    /**
     * @var integer
     *
     * @ORM\Column(name="sc_job_id", type="integer", nullable=true)
     */
    private $scJobId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pf_object_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pfObjectTrfYn;



    /**
     * Get pfObjectIx
     *
     * @return string
     */
    public function getPfObjectIx()
    {
        return $this->pfObjectIx;
    }

    /**
     * Set pfObjectDb
     *
     * @param string $pfObjectDb
     *
     * @return PfObject
     */
    public function setPfObjectDb($pfObjectDb)
    {
        $this->pfObjectDb = $pfObjectDb;

        return $this;
    }

    /**
     * Get pfObjectDb
     *
     * @return string
     */
    public function getPfObjectDb()
    {
        return $this->pfObjectDb;
    }

    /**
     * Set pfObjectId
     *
     * @param integer $pfObjectId
     *
     * @return PfObject
     */
    public function setPfObjectId($pfObjectId)
    {
        $this->pfObjectId = $pfObjectId;

        return $this;
    }

    /**
     * Get pfObjectId
     *
     * @return integer
     */
    public function getPfObjectId()
    {
        return $this->pfObjectId;
    }

    /**
     * Set pfObjectName
     *
     * @param string $pfObjectName
     *
     * @return PfObject
     */
    public function setPfObjectName($pfObjectName)
    {
        $this->pfObjectName = $pfObjectName;

        return $this;
    }

    /**
     * Get pfObjectName
     *
     * @return string
     */
    public function getPfObjectName()
    {
        return $this->pfObjectName;
    }

    /**
     * Set pfObjectNote
     *
     * @param string $pfObjectNote
     *
     * @return PfObject
     */
    public function setPfObjectNote($pfObjectNote)
    {
        $this->pfObjectNote = $pfObjectNote;

        return $this;
    }

    /**
     * Get pfObjectNote
     *
     * @return string
     */
    public function getPfObjectNote()
    {
        return $this->pfObjectNote;
    }

    /**
     * Set scJobId
     *
     * @param integer $scJobId
     *
     * @return PfObject
     */
    public function setScJobId($scJobId)
    {
        $this->scJobId = $scJobId;

        return $this;
    }

    /**
     * Get scJobId
     *
     * @return integer
     */
    public function getScJobId()
    {
        return $this->scJobId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PfObject
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pfObjectTrfYn
     *
     * @param boolean $pfObjectTrfYn
     *
     * @return PfObject
     */
    public function setPfObjectTrfYn($pfObjectTrfYn)
    {
        $this->pfObjectTrfYn = $pfObjectTrfYn;

        return $this;
    }

    /**
     * Get pfObjectTrfYn
     *
     * @return boolean
     */
    public function getPfObjectTrfYn()
    {
        return $this->pfObjectTrfYn;
    }
}
