<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PfOption
 *
 * @ORM\Table(name="pf_option", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pf_option_trf_yn", columns={"pf_option_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PfOption
{
    /**
     * @var string
     *
     * @ORM\Column(name="pf_option_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pfOptionIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_option_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pfOptionDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pf_option_id", type="integer", nullable=false)
     */
    private $pfOptionId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pf_option_default_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pfOptionDefaultYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pf_option_favourite_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pfOptionFavouriteYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_option_name", type="string", length=50, nullable=true)
     */
    private $pfOptionName;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_option_title", type="string", length=30, nullable=true)
     */
    private $pfOptionTitle;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_option_note", type="string", length=255, nullable=true)
     */
    private $pfOptionNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pf_level_ind", type="boolean", nullable=true)
     */
    private $pfLevelInd;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_level_link_id", type="string", length=36, nullable=true)
     */
    private $pfLevelLinkId;

    /**
     * @var string
     *
     * @ORM\Column(name="pf_object_id", type="string", length=36, nullable=true)
     */
    private $pfObjectId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pf_option_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pfOptionTrfYn;



    /**
     * Get pfOptionIx
     *
     * @return string
     */
    public function getPfOptionIx()
    {
        return $this->pfOptionIx;
    }

    /**
     * Set pfOptionDb
     *
     * @param string $pfOptionDb
     *
     * @return PfOption
     */
    public function setPfOptionDb($pfOptionDb)
    {
        $this->pfOptionDb = $pfOptionDb;

        return $this;
    }

    /**
     * Get pfOptionDb
     *
     * @return string
     */
    public function getPfOptionDb()
    {
        return $this->pfOptionDb;
    }

    /**
     * Set pfOptionId
     *
     * @param integer $pfOptionId
     *
     * @return PfOption
     */
    public function setPfOptionId($pfOptionId)
    {
        $this->pfOptionId = $pfOptionId;

        return $this;
    }

    /**
     * Get pfOptionId
     *
     * @return integer
     */
    public function getPfOptionId()
    {
        return $this->pfOptionId;
    }

    /**
     * Set pfOptionDefaultYn
     *
     * @param boolean $pfOptionDefaultYn
     *
     * @return PfOption
     */
    public function setPfOptionDefaultYn($pfOptionDefaultYn)
    {
        $this->pfOptionDefaultYn = $pfOptionDefaultYn;

        return $this;
    }

    /**
     * Get pfOptionDefaultYn
     *
     * @return boolean
     */
    public function getPfOptionDefaultYn()
    {
        return $this->pfOptionDefaultYn;
    }

    /**
     * Set pfOptionFavouriteYn
     *
     * @param boolean $pfOptionFavouriteYn
     *
     * @return PfOption
     */
    public function setPfOptionFavouriteYn($pfOptionFavouriteYn)
    {
        $this->pfOptionFavouriteYn = $pfOptionFavouriteYn;

        return $this;
    }

    /**
     * Get pfOptionFavouriteYn
     *
     * @return boolean
     */
    public function getPfOptionFavouriteYn()
    {
        return $this->pfOptionFavouriteYn;
    }

    /**
     * Set pfOptionName
     *
     * @param string $pfOptionName
     *
     * @return PfOption
     */
    public function setPfOptionName($pfOptionName)
    {
        $this->pfOptionName = $pfOptionName;

        return $this;
    }

    /**
     * Get pfOptionName
     *
     * @return string
     */
    public function getPfOptionName()
    {
        return $this->pfOptionName;
    }

    /**
     * Set pfOptionTitle
     *
     * @param string $pfOptionTitle
     *
     * @return PfOption
     */
    public function setPfOptionTitle($pfOptionTitle)
    {
        $this->pfOptionTitle = $pfOptionTitle;

        return $this;
    }

    /**
     * Get pfOptionTitle
     *
     * @return string
     */
    public function getPfOptionTitle()
    {
        return $this->pfOptionTitle;
    }

    /**
     * Set pfOptionNote
     *
     * @param string $pfOptionNote
     *
     * @return PfOption
     */
    public function setPfOptionNote($pfOptionNote)
    {
        $this->pfOptionNote = $pfOptionNote;

        return $this;
    }

    /**
     * Get pfOptionNote
     *
     * @return string
     */
    public function getPfOptionNote()
    {
        return $this->pfOptionNote;
    }

    /**
     * Set pfLevelInd
     *
     * @param boolean $pfLevelInd
     *
     * @return PfOption
     */
    public function setPfLevelInd($pfLevelInd)
    {
        $this->pfLevelInd = $pfLevelInd;

        return $this;
    }

    /**
     * Get pfLevelInd
     *
     * @return boolean
     */
    public function getPfLevelInd()
    {
        return $this->pfLevelInd;
    }

    /**
     * Set pfLevelLinkId
     *
     * @param string $pfLevelLinkId
     *
     * @return PfOption
     */
    public function setPfLevelLinkId($pfLevelLinkId)
    {
        $this->pfLevelLinkId = $pfLevelLinkId;

        return $this;
    }

    /**
     * Get pfLevelLinkId
     *
     * @return string
     */
    public function getPfLevelLinkId()
    {
        return $this->pfLevelLinkId;
    }

    /**
     * Set pfObjectId
     *
     * @param string $pfObjectId
     *
     * @return PfOption
     */
    public function setPfObjectId($pfObjectId)
    {
        $this->pfObjectId = $pfObjectId;

        return $this;
    }

    /**
     * Get pfObjectId
     *
     * @return string
     */
    public function getPfObjectId()
    {
        return $this->pfObjectId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PfOption
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pfOptionTrfYn
     *
     * @param boolean $pfOptionTrfYn
     *
     * @return PfOption
     */
    public function setPfOptionTrfYn($pfOptionTrfYn)
    {
        $this->pfOptionTrfYn = $pfOptionTrfYn;

        return $this;
    }

    /**
     * Get pfOptionTrfYn
     *
     * @return boolean
     */
    public function getPfOptionTrfYn()
    {
        return $this->pfOptionTrfYn;
    }
}
