<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgAccBusiness
 *
 * @ORM\Table(name="pg_acc_business", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pg_acc_business_trf_yn", columns={"pg_acc_business_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PgAccBusiness
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_business_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgAccBusinessIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_business_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pgAccBusinessDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_acc_business_id", type="integer", nullable=false)
     */
    private $pgAccBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_account_id", type="string", length=36, nullable=true)
     */
    private $pgAccountId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_acc_business_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccBusinessTrfYn;



    /**
     * Get pgAccBusinessIx
     *
     * @return string
     */
    public function getPgAccBusinessIx()
    {
        return $this->pgAccBusinessIx;
    }

    /**
     * Set pgAccBusinessDb
     *
     * @param string $pgAccBusinessDb
     *
     * @return PgAccBusiness
     */
    public function setPgAccBusinessDb($pgAccBusinessDb)
    {
        $this->pgAccBusinessDb = $pgAccBusinessDb;

        return $this;
    }

    /**
     * Get pgAccBusinessDb
     *
     * @return string
     */
    public function getPgAccBusinessDb()
    {
        return $this->pgAccBusinessDb;
    }

    /**
     * Set pgAccBusinessId
     *
     * @param integer $pgAccBusinessId
     *
     * @return PgAccBusiness
     */
    public function setPgAccBusinessId($pgAccBusinessId)
    {
        $this->pgAccBusinessId = $pgAccBusinessId;

        return $this;
    }

    /**
     * Get pgAccBusinessId
     *
     * @return integer
     */
    public function getPgAccBusinessId()
    {
        return $this->pgAccBusinessId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return PgAccBusiness
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set pgAccountId
     *
     * @param string $pgAccountId
     *
     * @return PgAccBusiness
     */
    public function setPgAccountId($pgAccountId)
    {
        $this->pgAccountId = $pgAccountId;

        return $this;
    }

    /**
     * Get pgAccountId
     *
     * @return string
     */
    public function getPgAccountId()
    {
        return $this->pgAccountId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return PgAccBusiness
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return PgAccBusiness
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return PgAccBusiness
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return PgAccBusiness
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return PgAccBusiness
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return PgAccBusiness
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return PgAccBusiness
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return PgAccBusiness
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return PgAccBusiness
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgAccBusiness
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgAccBusinessTrfYn
     *
     * @param boolean $pgAccBusinessTrfYn
     *
     * @return PgAccBusiness
     */
    public function setPgAccBusinessTrfYn($pgAccBusinessTrfYn)
    {
        $this->pgAccBusinessTrfYn = $pgAccBusinessTrfYn;

        return $this;
    }

    /**
     * Get pgAccBusinessTrfYn
     *
     * @return boolean
     */
    public function getPgAccBusinessTrfYn()
    {
        return $this->pgAccBusinessTrfYn;
    }
}
