<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgAccCurrency
 *
 * @ORM\Table(name="pg_acc_currency", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pg_acc_currency_trf_yn", columns={"pg_acc_currency_trf_yn"})})
 * @ORM\Entity
 */
class PgAccCurrency
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_currency_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgAccCurrencyIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_currency_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"}))
     */
    private $pgAccCurrencyDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_acc_currency_id", type="integer", nullable=false)
     */
    private $pgAccCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_currency_code", type="string", length=20, nullable=false, options={"default"=""})
     */
    private $pgAccCurrencyCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_id", type="string", length=36, nullable=true)
     */
    private $rfBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_account_id", type="string", length=36, nullable=true)
     */
    private $pgAccountId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_acc_currency_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccCurrencyInactiveYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_acc_currency_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccCurrencyTrfYn;



    /**
     * Get pgAccCurrencyIx
     *
     * @return string
     */
    public function getPgAccCurrencyIx()
    {
        return $this->pgAccCurrencyIx;
    }

    /**
     * Set pgAccCurrencyDb
     *
     * @param string $pgAccCurrencyDb
     *
     * @return PgAccCurrency
     */
    public function setPgAccCurrencyDb($pgAccCurrencyDb)
    {
        $this->pgAccCurrencyDb = $pgAccCurrencyDb;

        return $this;
    }

    /**
     * Get pgAccCurrencyDb
     *
     * @return string
     */
    public function getPgAccCurrencyDb()
    {
        return $this->pgAccCurrencyDb;
    }

    /**
     * Set pgAccCurrencyId
     *
     * @param integer $pgAccCurrencyId
     *
     * @return PgAccCurrency
     */
    public function setPgAccCurrencyId($pgAccCurrencyId)
    {
        $this->pgAccCurrencyId = $pgAccCurrencyId;

        return $this;
    }

    /**
     * Get pgAccCurrencyId
     *
     * @return integer
     */
    public function getPgAccCurrencyId()
    {
        return $this->pgAccCurrencyId;
    }

    /**
     * Set pgAccCurrencyCode
     *
     * @param string $pgAccCurrencyCode
     *
     * @return PgAccCurrency
     */
    public function setPgAccCurrencyCode($pgAccCurrencyCode)
    {
        $this->pgAccCurrencyCode = $pgAccCurrencyCode;

        return $this;
    }

    /**
     * Get pgAccCurrencyCode
     *
     * @return string
     */
    public function getPgAccCurrencyCode()
    {
        return $this->pgAccCurrencyCode;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return PgAccCurrency
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rfBankId
     *
     * @param string $rfBankId
     *
     * @return PgAccCurrency
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return string
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set pgAccountId
     *
     * @param string $pgAccountId
     *
     * @return PgAccCurrency
     */
    public function setPgAccountId($pgAccountId)
    {
        $this->pgAccountId = $pgAccountId;

        return $this;
    }

    /**
     * Get pgAccountId
     *
     * @return string
     */
    public function getPgAccountId()
    {
        return $this->pgAccountId;
    }

    /**
     * Set pgAccCurrencyInactiveYn
     *
     * @param boolean $pgAccCurrencyInactiveYn
     *
     * @return PgAccCurrency
     */
    public function setPgAccCurrencyInactiveYn($pgAccCurrencyInactiveYn)
    {
        $this->pgAccCurrencyInactiveYn = $pgAccCurrencyInactiveYn;

        return $this;
    }

    /**
     * Get pgAccCurrencyInactiveYn
     *
     * @return boolean
     */
    public function getPgAccCurrencyInactiveYn()
    {
        return $this->pgAccCurrencyInactiveYn;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return PgAccCurrency
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return PgAccCurrency
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return PgAccCurrency
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return PgAccCurrency
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return PgAccCurrency
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return PgAccCurrency
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return PgAccCurrency
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return PgAccCurrency
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return PgAccCurrency
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgAccCurrency
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgAccCurrencyTrfYn
     *
     * @param boolean $pgAccCurrencyTrfYn
     *
     * @return PgAccCurrency
     */
    public function setPgAccCurrencyTrfYn($pgAccCurrencyTrfYn)
    {
        $this->pgAccCurrencyTrfYn = $pgAccCurrencyTrfYn;

        return $this;
    }

    /**
     * Get pgAccCurrencyTrfYn
     *
     * @return boolean
     */
    public function getPgAccCurrencyTrfYn()
    {
        return $this->pgAccCurrencyTrfYn;
    }
}
