<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgAccMethod
 *
 * @ORM\Table(name="pg_acc_method", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pg_acc_method_trf_yn", columns={"pg_acc_method_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PgAccMethod
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_method_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgAccMethodIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_method_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pgAccMethodDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_acc_method_id", type="integer", nullable=false)
     */
    private $pgAccMethodId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_method_id", type="string", length=36, nullable=true)
     */
    private $pgMethodId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_account_id", type="string", length=36, nullable=true)
     */
    private $pgAccountId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_acc_method_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccMethodTrfYn;



    /**
     * Get pgAccMethodIx
     *
     * @return string
     */
    public function getPgAccMethodIx()
    {
        return $this->pgAccMethodIx;
    }

    /**
     * Set pgAccMethodDb
     *
     * @param string $pgAccMethodDb
     *
     * @return PgAccMethod
     */
    public function setPgAccMethodDb($pgAccMethodDb)
    {
        $this->pgAccMethodDb = $pgAccMethodDb;

        return $this;
    }

    /**
     * Get pgAccMethodDb
     *
     * @return string
     */
    public function getPgAccMethodDb()
    {
        return $this->pgAccMethodDb;
    }

    /**
     * Set pgAccMethodId
     *
     * @param integer $pgAccMethodId
     *
     * @return PgAccMethod
     */
    public function setPgAccMethodId($pgAccMethodId)
    {
        $this->pgAccMethodId = $pgAccMethodId;

        return $this;
    }

    /**
     * Get pgAccMethodId
     *
     * @return integer
     */
    public function getPgAccMethodId()
    {
        return $this->pgAccMethodId;
    }

    /**
     * Set pgMethodId
     *
     * @param string $pgMethodId
     *
     * @return PgAccMethod
     */
    public function setPgMethodId($pgMethodId)
    {
        $this->pgMethodId = $pgMethodId;

        return $this;
    }

    /**
     * Get pgMethodId
     *
     * @return string
     */
    public function getPgMethodId()
    {
        return $this->pgMethodId;
    }

    /**
     * Set pgAccountId
     *
     * @param string $pgAccountId
     *
     * @return PgAccMethod
     */
    public function setPgAccountId($pgAccountId)
    {
        $this->pgAccountId = $pgAccountId;

        return $this;
    }

    /**
     * Get pgAccountId
     *
     * @return string
     */
    public function getPgAccountId()
    {
        return $this->pgAccountId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return PgAccMethod
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return PgAccMethod
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return PgAccMethod
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return PgAccMethod
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return PgAccMethod
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return PgAccMethod
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return PgAccMethod
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return PgAccMethod
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return PgAccMethod
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgAccMethod
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgAccMethodTrfYn
     *
     * @param boolean $pgAccMethodTrfYn
     *
     * @return PgAccMethod
     */
    public function setPgAccMethodTrfYn($pgAccMethodTrfYn)
    {
        $this->pgAccMethodTrfYn = $pgAccMethodTrfYn;

        return $this;
    }

    /**
     * Get pgAccMethodTrfYn
     *
     * @return boolean
     */
    public function getPgAccMethodTrfYn()
    {
        return $this->pgAccMethodTrfYn;
    }
}
