<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgAccObjData
 *
 * @ORM\Table(name="pg_acc_obj_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pg_acc_obj_data_trf_yn", columns={"pg_acc_obj_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PgAccObjData
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_obj_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgAccObjDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_obj_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pgAccObjDataDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_acc_obj_data_id", type="integer", nullable=false)
     */
    private $pgAccObjDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_obj_data", type="text", length=16777215, nullable=true)
     */
    private $pgAccObjData;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_account_id", type="string", length=36, nullable=true)
     */
    private $pgAccountId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_id", type="string", length=36, nullable=true)
     */
    private $pgTypeObjId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_data_id", type="string", length=36, nullable=true)
     */
    private $pgTypeObjDataId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_acc_obj_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccObjDataTrfYn;



    /**
     * Get pgAccObjDataIx
     *
     * @return string
     */
    public function getPgAccObjDataIx()
    {
        return $this->pgAccObjDataIx;
    }

    /**
     * Set pgAccObjDataDb
     *
     * @param string $pgAccObjDataDb
     *
     * @return PgAccObjData
     */
    public function setPgAccObjDataDb($pgAccObjDataDb)
    {
        $this->pgAccObjDataDb = $pgAccObjDataDb;

        return $this;
    }

    /**
     * Get pgAccObjDataDb
     *
     * @return string
     */
    public function getPgAccObjDataDb()
    {
        return $this->pgAccObjDataDb;
    }

    /**
     * Set pgAccObjDataId
     *
     * @param integer $pgAccObjDataId
     *
     * @return PgAccObjData
     */
    public function setPgAccObjDataId($pgAccObjDataId)
    {
        $this->pgAccObjDataId = $pgAccObjDataId;

        return $this;
    }

    /**
     * Get pgAccObjDataId
     *
     * @return integer
     */
    public function getPgAccObjDataId()
    {
        return $this->pgAccObjDataId;
    }

    /**
     * Set pgAccObjData
     *
     * @param string $pgAccObjData
     *
     * @return PgAccObjData
     */
    public function setPgAccObjData($pgAccObjData)
    {
        $this->pgAccObjData = $pgAccObjData;

        return $this;
    }

    /**
     * Get pgAccObjData
     *
     * @return string
     */
    public function getPgAccObjData()
    {
        return $this->pgAccObjData;
    }

    /**
     * Set pgAccountId
     *
     * @param string $pgAccountId
     *
     * @return PgAccObjData
     */
    public function setPgAccountId($pgAccountId)
    {
        $this->pgAccountId = $pgAccountId;

        return $this;
    }

    /**
     * Get pgAccountId
     *
     * @return string
     */
    public function getPgAccountId()
    {
        return $this->pgAccountId;
    }

    /**
     * Set pgTypeObjId
     *
     * @param string $pgTypeObjId
     *
     * @return PgAccObjData
     */
    public function setPgTypeObjId($pgTypeObjId)
    {
        $this->pgTypeObjId = $pgTypeObjId;

        return $this;
    }

    /**
     * Get pgTypeObjId
     *
     * @return string
     */
    public function getPgTypeObjId()
    {
        return $this->pgTypeObjId;
    }

    /**
     * Set pgTypeObjDataId
     *
     * @param string $pgTypeObjDataId
     *
     * @return PgAccObjData
     */
    public function setPgTypeObjDataId($pgTypeObjDataId)
    {
        $this->pgTypeObjDataId = $pgTypeObjDataId;

        return $this;
    }

    /**
     * Get pgTypeObjDataId
     *
     * @return string
     */
    public function getPgTypeObjDataId()
    {
        return $this->pgTypeObjDataId;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return PgAccObjData
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return PgAccObjData
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return PgAccObjData
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return PgAccObjData
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return PgAccObjData
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return PgAccObjData
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return PgAccObjData
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return PgAccObjData
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return PgAccObjData
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgAccObjData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgAccObjDataTrfYn
     *
     * @param boolean $pgAccObjDataTrfYn
     *
     * @return PgAccObjData
     */
    public function setPgAccObjDataTrfYn($pgAccObjDataTrfYn)
    {
        $this->pgAccObjDataTrfYn = $pgAccObjDataTrfYn;

        return $this;
    }

    /**
     * Get pgAccObjDataTrfYn
     *
     * @return boolean
     */
    public function getPgAccObjDataTrfYn()
    {
        return $this->pgAccObjDataTrfYn;
    }
}
