<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgAccount
 *
 * @ORM\Table(name="pg_account", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pg_account_trf_yn", columns={"pg_account_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PgAccount
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_account_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgAccountIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_account_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pgAccountDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_account_id", type="integer", nullable=false)
     */
    private $pgAccountId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_acc_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $pgAccName;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_acc_external_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccExternalYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_acc_internal_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccInternalYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_acc_public_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccPublicYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_id", type="string", length=36, nullable=true)
     */
    private $pgTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_mthd_pmnt_id", type="string", length=36, nullable=true)
     */
    private $rfMthdPmntId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_account_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccountInactiveYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_delete_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adDeleteDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_date_tz", type="string", length=40, nullable=false)
     */
    private $adDeleteDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_delete_user_id", type="string", length=36, nullable=true)
     */
    private $adDeleteUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=false)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_account_sys_code", type="boolean", nullable=true)
     */
    private $pgAccountSysCode;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_account_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgAccountTrfYn;



    /**
     * Get pgAccountIx
     *
     * @return string
     */
    public function getPgAccountIx()
    {
        return $this->pgAccountIx;
    }

    /**
     * Set pgAccountDb
     *
     * @param string $pgAccountDb
     *
     * @return PgAccount
     */
    public function setPgAccountDb($pgAccountDb)
    {
        $this->pgAccountDb = $pgAccountDb;

        return $this;
    }

    /**
     * Get pgAccountDb
     *
     * @return string
     */
    public function getPgAccountDb()
    {
        return $this->pgAccountDb;
    }

    /**
     * Set pgAccountId
     *
     * @param integer $pgAccountId
     *
     * @return PgAccount
     */
    public function setPgAccountId($pgAccountId)
    {
        $this->pgAccountId = $pgAccountId;

        return $this;
    }

    /**
     * Get pgAccountId
     *
     * @return integer
     */
    public function getPgAccountId()
    {
        return $this->pgAccountId;
    }

    /**
     * Set pgAccName
     *
     * @param string $pgAccName
     *
     * @return PgAccount
     */
    public function setPgAccName($pgAccName)
    {
        $this->pgAccName = $pgAccName;

        return $this;
    }

    /**
     * Get pgAccName
     *
     * @return string
     */
    public function getPgAccName()
    {
        return $this->pgAccName;
    }

    /**
     * Set pgAccExternalYn
     *
     * @param boolean $pgAccExternalYn
     *
     * @return PgAccount
     */
    public function setPgAccExternalYn($pgAccExternalYn)
    {
        $this->pgAccExternalYn = $pgAccExternalYn;

        return $this;
    }

    /**
     * Get pgAccExternalYn
     *
     * @return boolean
     */
    public function getPgAccExternalYn()
    {
        return $this->pgAccExternalYn;
    }

    /**
     * Set pgAccInternalYn
     *
     * @param boolean $pgAccInternalYn
     *
     * @return PgAccount
     */
    public function setPgAccInternalYn($pgAccInternalYn)
    {
        $this->pgAccInternalYn = $pgAccInternalYn;

        return $this;
    }

    /**
     * Get pgAccInternalYn
     *
     * @return boolean
     */
    public function getPgAccInternalYn()
    {
        return $this->pgAccInternalYn;
    }

    /**
     * Set pgAccPublicYn
     *
     * @param boolean $pgAccPublicYn
     *
     * @return PgAccount
     */
    public function setPgAccPublicYn($pgAccPublicYn)
    {
        $this->pgAccPublicYn = $pgAccPublicYn;

        return $this;
    }

    /**
     * Get pgAccPublicYn
     *
     * @return boolean
     */
    public function getPgAccPublicYn()
    {
        return $this->pgAccPublicYn;
    }

    /**
     * Set pgTypeId
     *
     * @param string $pgTypeId
     *
     * @return PgAccount
     */
    public function setPgTypeId($pgTypeId)
    {
        $this->pgTypeId = $pgTypeId;

        return $this;
    }

    /**
     * Get pgTypeId
     *
     * @return string
     */
    public function getPgTypeId()
    {
        return $this->pgTypeId;
    }

    /**
     * Set rfMthdPmntId
     *
     * @param string $rfMthdPmntId
     *
     * @return PgAccount
     */
    public function setRfMthdPmntId($rfMthdPmntId)
    {
        $this->rfMthdPmntId = $rfMthdPmntId;

        return $this;
    }

    /**
     * Get rfMthdPmntId
     *
     * @return string
     */
    public function getRfMthdPmntId()
    {
        return $this->rfMthdPmntId;
    }

    /**
     * Set pgAccountInactiveYn
     *
     * @param boolean $pgAccountInactiveYn
     *
     * @return PgAccount
     */
    public function setPgAccountInactiveYn($pgAccountInactiveYn)
    {
        $this->pgAccountInactiveYn = $pgAccountInactiveYn;

        return $this;
    }

    /**
     * Get pgAccountInactiveYn
     *
     * @return boolean
     */
    public function getPgAccountInactiveYn()
    {
        return $this->pgAccountInactiveYn;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return PgAccount
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return PgAccount
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return PgAccount
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adDeleteDate
     *
     * @param \DateTime $adDeleteDate
     *
     * @return PgAccount
     */
    public function setAdDeleteDate($adDeleteDate)
    {
        $this->adDeleteDate = $adDeleteDate;

        return $this;
    }

    /**
     * Get adDeleteDate
     *
     * @return \DateTime
     */
    public function getAdDeleteDate()
    {
        return $this->adDeleteDate;
    }

    /**
     * Set adDeleteDateTz
     *
     * @param string $adDeleteDateTz
     *
     * @return PgAccount
     */
    public function setAdDeleteDateTz($adDeleteDateTz)
    {
        $this->adDeleteDateTz = $adDeleteDateTz;

        return $this;
    }

    /**
     * Get adDeleteDateTz
     *
     * @return string
     */
    public function getAdDeleteDateTz()
    {
        return $this->adDeleteDateTz;
    }

    /**
     * Set adDeleteUserId
     *
     * @param string $adDeleteUserId
     *
     * @return PgAccount
     */
    public function setAdDeleteUserId($adDeleteUserId)
    {
        $this->adDeleteUserId = $adDeleteUserId;

        return $this;
    }

    /**
     * Get adDeleteUserId
     *
     * @return string
     */
    public function getAdDeleteUserId()
    {
        return $this->adDeleteUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param \DateTime $adModifyDate
     *
     * @return PgAccount
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = $adModifyDate;

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return PgAccount
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return PgAccount
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set pgAccountSysCode
     *
     * @param boolean $pgAccountSysCode
     *
     * @return PgAccount
     */
    public function setPgAccountSysCode($pgAccountSysCode)
    {
        $this->pgAccountSysCode = $pgAccountSysCode;

        return $this;
    }

    /**
     * Get pgAccountSysCode
     *
     * @return boolean
     */
    public function getPgAccountSysCode()
    {
        return $this->pgAccountSysCode;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgAccount
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgAccountTrfYn
     *
     * @param boolean $pgAccountTrfYn
     *
     * @return PgAccount
     */
    public function setPgAccountTrfYn($pgAccountTrfYn)
    {
        $this->pgAccountTrfYn = $pgAccountTrfYn;

        return $this;
    }

    /**
     * Get pgAccountTrfYn
     *
     * @return boolean
     */
    public function getPgAccountTrfYn()
    {
        return $this->pgAccountTrfYn;
    }
}
