<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgMethod
 *
 * @ORM\Table(name="pg_method", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, uniqueConstraints={@ORM\UniqueConstraint(name="pg_method_ix", columns={"pg_method_ix"})}, indexes={@ORM\Index(name="pg_method_trf_yn", columns={"pg_method_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PgMethod
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_method_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgMethodIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_method_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pgMethodDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_method_id", type="integer", nullable=false)
     */
    private $pgMethodId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_method_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $pgMethodName;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_method_note", type="text", length=65535, nullable=true)
     */
    private $pgMethodNote;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_method_image", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $pgMethodImage;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_method_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgMethodInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_method_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgMethodTrfYn;



    /**
     * Get pgMethodIx
     *
     * @return string
     */
    public function getPgMethodIx()
    {
        return $this->pgMethodIx;
    }

    /**
     * Set pgMethodDb
     *
     * @param string $pgMethodDb
     *
     * @return PgMethod
     */
    public function setPgMethodDb($pgMethodDb)
    {
        $this->pgMethodDb = $pgMethodDb;

        return $this;
    }

    /**
     * Get pgMethodDb
     *
     * @return string
     */
    public function getPgMethodDb()
    {
        return $this->pgMethodDb;
    }

    /**
     * Set pgMethodId
     *
     * @param integer $pgMethodId
     *
     * @return PgMethod
     */
    public function setPgMethodId($pgMethodId)
    {
        $this->pgMethodId = $pgMethodId;

        return $this;
    }

    /**
     * Get pgMethodId
     *
     * @return integer
     */
    public function getPgMethodId()
    {
        return $this->pgMethodId;
    }

    /**
     * Set pgMethodName
     *
     * @param string $pgMethodName
     *
     * @return PgMethod
     */
    public function setPgMethodName($pgMethodName)
    {
        $this->pgMethodName = $pgMethodName;

        return $this;
    }

    /**
     * Get pgMethodName
     *
     * @return string
     */
    public function getPgMethodName()
    {
        return $this->pgMethodName;
    }

    /**
     * Set pgMethodNote
     *
     * @param string $pgMethodNote
     *
     * @return PgMethod
     */
    public function setPgMethodNote($pgMethodNote)
    {
        $this->pgMethodNote = $pgMethodNote;

        return $this;
    }

    /**
     * Get pgMethodNote
     *
     * @return string
     */
    public function getPgMethodNote()
    {
        return $this->pgMethodNote;
    }

    /**
     * Set pgMethodImage
     *
     * @param string $pgMethodImage
     *
     * @return PgMethod
     */
    public function setPgMethodImage($pgMethodImage)
    {
        $this->pgMethodImage = $pgMethodImage;

        return $this;
    }

    /**
     * Get pgMethodImage
     *
     * @return string
     */
    public function getPgMethodImage()
    {
        return $this->pgMethodImage;
    }

    /**
     * Set pgMethodInactiveYn
     *
     * @param boolean $pgMethodInactiveYn
     *
     * @return PgMethod
     */
    public function setPgMethodInactiveYn($pgMethodInactiveYn)
    {
        $this->pgMethodInactiveYn = $pgMethodInactiveYn;

        return $this;
    }

    /**
     * Get pgMethodInactiveYn
     *
     * @return boolean
     */
    public function getPgMethodInactiveYn()
    {
        return $this->pgMethodInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgMethod
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgMethodTrfYn
     *
     * @param boolean $pgMethodTrfYn
     *
     * @return PgMethod
     */
    public function setPgMethodTrfYn($pgMethodTrfYn)
    {
        $this->pgMethodTrfYn = $pgMethodTrfYn;

        return $this;
    }

    /**
     * Get pgMethodTrfYn
     *
     * @return boolean
     */
    public function getPgMethodTrfYn()
    {
        return $this->pgMethodTrfYn;
    }
}
