<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgType
 *
 * @ORM\Table(name="pg_type", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pg_type_trf_yn", columns={"pg_type_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="pg_type_ix", columns={"pg_type_ix"})})
 * @ORM\Entity
 */
class PgType
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgTypeIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pgTypeDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_type_id", type="integer", nullable=false)
     */
    private $pgTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $pgTypeName;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_label", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $pgTypeLabel;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_logo", type="string", length=50, nullable=true)
     */
    private $pgTypeLogo;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_api_url", type="string", length=255, nullable=false, options={"default"=""})
     */
    private $pgTypeApiUrl;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_site_url", type="string", length=255, nullable=false, options={"default"=""})
     */
    private $pgTypeSiteUrl;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeTrfYn;



    /**
     * Get pgTypeIx
     *
     * @return string
     */
    public function getPgTypeIx()
    {
        return $this->pgTypeIx;
    }

    /**
     * Set pgTypeDb
     *
     * @param string $pgTypeDb
     *
     * @return PgType
     */
    public function setPgTypeDb($pgTypeDb)
    {
        $this->pgTypeDb = $pgTypeDb;

        return $this;
    }

    /**
     * Get pgTypeDb
     *
     * @return string
     */
    public function getPgTypeDb()
    {
        return $this->pgTypeDb;
    }

    /**
     * Set pgTypeId
     *
     * @param integer $pgTypeId
     *
     * @return PgType
     */
    public function setPgTypeId($pgTypeId)
    {
        $this->pgTypeId = $pgTypeId;

        return $this;
    }

    /**
     * Get pgTypeId
     *
     * @return integer
     */
    public function getPgTypeId()
    {
        return $this->pgTypeId;
    }

    /**
     * Set pgTypeName
     *
     * @param string $pgTypeName
     *
     * @return PgType
     */
    public function setPgTypeName($pgTypeName)
    {
        $this->pgTypeName = $pgTypeName;

        return $this;
    }

    /**
     * Get pgTypeName
     *
     * @return string
     */
    public function getPgTypeName()
    {
        return $this->pgTypeName;
    }

    /**
     * Set pgTypeLabel
     *
     * @param string $pgTypeLabel
     *
     * @return PgType
     */
    public function setPgTypeLabel($pgTypeLabel)
    {
        $this->pgTypeLabel = $pgTypeLabel;

        return $this;
    }

    /**
     * Get pgTypeLabel
     *
     * @return string
     */
    public function getPgTypeLabel()
    {
        return $this->pgTypeLabel;
    }

    /**
     * Set pgTypeLogo
     *
     * @param string $pgTypeLogo
     *
     * @return PgType
     */
    public function setPgTypeLogo($pgTypeLogo)
    {
        $this->pgTypeLogo = $pgTypeLogo;

        return $this;
    }

    /**
     * Get pgTypeLogo
     *
     * @return string
     */
    public function getPgTypeLogo()
    {
        return $this->pgTypeLogo;
    }

    /**
     * Set pgTypeApiUrl
     *
     * @param string $pgTypeApiUrl
     *
     * @return PgType
     */
    public function setPgTypeApiUrl($pgTypeApiUrl)
    {
        $this->pgTypeApiUrl = $pgTypeApiUrl;

        return $this;
    }

    /**
     * Get pgTypeApiUrl
     *
     * @return string
     */
    public function getPgTypeApiUrl()
    {
        return $this->pgTypeApiUrl;
    }

    /**
     * Set pgTypeSiteUrl
     *
     * @param string $pgTypeSiteUrl
     *
     * @return PgType
     */
    public function setPgTypeSiteUrl($pgTypeSiteUrl)
    {
        $this->pgTypeSiteUrl = $pgTypeSiteUrl;

        return $this;
    }

    /**
     * Get pgTypeSiteUrl
     *
     * @return string
     */
    public function getPgTypeSiteUrl()
    {
        return $this->pgTypeSiteUrl;
    }

    /**
     * Set pgTypeInactiveYn
     *
     * @param boolean $pgTypeInactiveYn
     *
     * @return PgType
     */
    public function setPgTypeInactiveYn($pgTypeInactiveYn)
    {
        $this->pgTypeInactiveYn = $pgTypeInactiveYn;

        return $this;
    }

    /**
     * Get pgTypeInactiveYn
     *
     * @return boolean
     */
    public function getPgTypeInactiveYn()
    {
        return $this->pgTypeInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgType
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgTypeTrfYn
     *
     * @param boolean $pgTypeTrfYn
     *
     * @return PgType
     */
    public function setPgTypeTrfYn($pgTypeTrfYn)
    {
        $this->pgTypeTrfYn = $pgTypeTrfYn;

        return $this;
    }

    /**
     * Get pgTypeTrfYn
     *
     * @return boolean
     */
    public function getPgTypeTrfYn()
    {
        return $this->pgTypeTrfYn;
    }
}
