<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgTypeObj
 *
 * @ORM\Table(name="pg_type_obj", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pg_type_obj_trf_yn", columns={"pg_type_obj_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})},  uniqueConstraints={@ORM\UniqueConstraint(name="pg_type_obj_ix", columns={"pg_type_obj_ix"})})
 * @ORM\Entity
 */
class PgTypeObj
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgTypeObjIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pgTypeObjDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_type_obj_id", type="integer", nullable=false)
     */
    private $pgTypeObjId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_name", type="string", length=30, nullable=false, options={"default"=""})
     */
    private $pgTypeObjName;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_label", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $pgTypeObjLabel;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_sort_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeObjSortSeq;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_type_ind", type="boolean", nullable=false, options={"default"="1"})
     */
    private $pgTypeObjTypeInd;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_id", type="string", length=36, nullable=true)
     */
    private $pgTypeId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_mandatory_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeObjMandatoryYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeObjInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeObjTrfYn;



    /**
     * Get pgTypeObjIx
     *
     * @return string
     */
    public function getPgTypeObjIx()
    {
        return $this->pgTypeObjIx;
    }

    /**
     * Set pgTypeObjDb
     *
     * @param string $pgTypeObjDb
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjDb($pgTypeObjDb)
    {
        $this->pgTypeObjDb = $pgTypeObjDb;

        return $this;
    }

    /**
     * Get pgTypeObjDb
     *
     * @return string
     */
    public function getPgTypeObjDb()
    {
        return $this->pgTypeObjDb;
    }

    /**
     * Set pgTypeObjId
     *
     * @param integer $pgTypeObjId
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjId($pgTypeObjId)
    {
        $this->pgTypeObjId = $pgTypeObjId;

        return $this;
    }

    /**
     * Get pgTypeObjId
     *
     * @return integer
     */
    public function getPgTypeObjId()
    {
        return $this->pgTypeObjId;
    }

    /**
     * Set pgTypeObjName
     *
     * @param string $pgTypeObjName
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjName($pgTypeObjName)
    {
        $this->pgTypeObjName = $pgTypeObjName;

        return $this;
    }

    /**
     * Get pgTypeObjName
     *
     * @return string
     */
    public function getPgTypeObjName()
    {
        return $this->pgTypeObjName;
    }

    /**
     * Set pgTypeObjLabel
     *
     * @param string $pgTypeObjLabel
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjLabel($pgTypeObjLabel)
    {
        $this->pgTypeObjLabel = $pgTypeObjLabel;

        return $this;
    }

    /**
     * Get pgTypeObjLabel
     *
     * @return string
     */
    public function getPgTypeObjLabel()
    {
        return $this->pgTypeObjLabel;
    }

    /**
     * Set pgTypeObjSortSeq
     *
     * @param boolean $pgTypeObjSortSeq
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjSortSeq($pgTypeObjSortSeq)
    {
        $this->pgTypeObjSortSeq = $pgTypeObjSortSeq;

        return $this;
    }

    /**
     * Get pgTypeObjSortSeq
     *
     * @return boolean
     */
    public function getPgTypeObjSortSeq()
    {
        return $this->pgTypeObjSortSeq;
    }

    /**
     * Set pgTypeObjTypeInd
     *
     * @param boolean $pgTypeObjTypeInd
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjTypeInd($pgTypeObjTypeInd)
    {
        $this->pgTypeObjTypeInd = $pgTypeObjTypeInd;

        return $this;
    }

    /**
     * Get pgTypeObjTypeInd
     *
     * @return boolean
     */
    public function getPgTypeObjTypeInd()
    {
        return $this->pgTypeObjTypeInd;
    }

    /**
     * Set pgTypeId
     *
     * @param string $pgTypeId
     *
     * @return PgTypeObj
     */
    public function setPgTypeId($pgTypeId)
    {
        $this->pgTypeId = $pgTypeId;

        return $this;
    }

    /**
     * Get pgTypeId
     *
     * @return string
     */
    public function getPgTypeId()
    {
        return $this->pgTypeId;
    }

    /**
     * Set pgTypeObjMandatoryYn
     *
     * @param boolean $pgTypeObjMandatoryYn
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjMandatoryYn($pgTypeObjMandatoryYn)
    {
        $this->pgTypeObjMandatoryYn = $pgTypeObjMandatoryYn;

        return $this;
    }

    /**
     * Get pgTypeObjMandatoryYn
     *
     * @return boolean
     */
    public function getPgTypeObjMandatoryYn()
    {
        return $this->pgTypeObjMandatoryYn;
    }

    /**
     * Set pgTypeObjInactiveYn
     *
     * @param boolean $pgTypeObjInactiveYn
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjInactiveYn($pgTypeObjInactiveYn)
    {
        $this->pgTypeObjInactiveYn = $pgTypeObjInactiveYn;

        return $this;
    }

    /**
     * Get pgTypeObjInactiveYn
     *
     * @return boolean
     */
    public function getPgTypeObjInactiveYn()
    {
        return $this->pgTypeObjInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgTypeObj
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgTypeObjTrfYn
     *
     * @param boolean $pgTypeObjTrfYn
     *
     * @return PgTypeObj
     */
    public function setPgTypeObjTrfYn($pgTypeObjTrfYn)
    {
        $this->pgTypeObjTrfYn = $pgTypeObjTrfYn;

        return $this;
    }

    /**
     * Get pgTypeObjTrfYn
     *
     * @return boolean
     */
    public function getPgTypeObjTrfYn()
    {
        return $this->pgTypeObjTrfYn;
    }
}
