<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PgTypeObjData
 *
 * @ORM\Table(name="pg_type_obj_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pg_type_obj_data_trf_yn", columns={"pg_type_obj_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PgTypeObjData
{
    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $pgTypeObjDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $pgTypeObjDataDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pg_type_obj_data_id", type="integer", nullable=false)
     */
    private $pgTypeObjDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_data_content", type="string", length=30, nullable=true)
     */
    private $pgTypeObjDataContent;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_data_sort_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeObjDataSortSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="pg_type_obj_id", type="string", length=36, nullable=true)
     */
    private $pgTypeObjId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_data_default_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeObjDataDefaultYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_data_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeObjDataInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pg_type_obj_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $pgTypeObjDataTrfYn;



    /**
     * Get pgTypeObjDataIx
     *
     * @return string
     */
    public function getPgTypeObjDataIx()
    {
        return $this->pgTypeObjDataIx;
    }

    /**
     * Set pgTypeObjDataDb
     *
     * @param string $pgTypeObjDataDb
     *
     * @return PgTypeObjData
     */
    public function setPgTypeObjDataDb($pgTypeObjDataDb)
    {
        $this->pgTypeObjDataDb = $pgTypeObjDataDb;

        return $this;
    }

    /**
     * Get pgTypeObjDataDb
     *
     * @return string
     */
    public function getPgTypeObjDataDb()
    {
        return $this->pgTypeObjDataDb;
    }

    /**
     * Set pgTypeObjDataId
     *
     * @param integer $pgTypeObjDataId
     *
     * @return PgTypeObjData
     */
    public function setPgTypeObjDataId($pgTypeObjDataId)
    {
        $this->pgTypeObjDataId = $pgTypeObjDataId;

        return $this;
    }

    /**
     * Get pgTypeObjDataId
     *
     * @return integer
     */
    public function getPgTypeObjDataId()
    {
        return $this->pgTypeObjDataId;
    }

    /**
     * Set pgTypeObjDataContent
     *
     * @param string $pgTypeObjDataContent
     *
     * @return PgTypeObjData
     */
    public function setPgTypeObjDataContent($pgTypeObjDataContent)
    {
        $this->pgTypeObjDataContent = $pgTypeObjDataContent;

        return $this;
    }

    /**
     * Get pgTypeObjDataContent
     *
     * @return string
     */
    public function getPgTypeObjDataContent()
    {
        return $this->pgTypeObjDataContent;
    }

    /**
     * Set pgTypeObjDataSortSeq
     *
     * @param boolean $pgTypeObjDataSortSeq
     *
     * @return PgTypeObjData
     */
    public function setPgTypeObjDataSortSeq($pgTypeObjDataSortSeq)
    {
        $this->pgTypeObjDataSortSeq = $pgTypeObjDataSortSeq;

        return $this;
    }

    /**
     * Get pgTypeObjDataSortSeq
     *
     * @return boolean
     */
    public function getPgTypeObjDataSortSeq()
    {
        return $this->pgTypeObjDataSortSeq;
    }

    /**
     * Set pgTypeObjId
     *
     * @param string $pgTypeObjId
     *
     * @return PgTypeObjData
     */
    public function setPgTypeObjId($pgTypeObjId)
    {
        $this->pgTypeObjId = $pgTypeObjId;

        return $this;
    }

    /**
     * Get pgTypeObjId
     *
     * @return string
     */
    public function getPgTypeObjId()
    {
        return $this->pgTypeObjId;
    }

    /**
     * Set pgTypeObjDataDefaultYn
     *
     * @param boolean $pgTypeObjDataDefaultYn
     *
     * @return PgTypeObjData
     */
    public function setPgTypeObjDataDefaultYn($pgTypeObjDataDefaultYn)
    {
        $this->pgTypeObjDataDefaultYn = $pgTypeObjDataDefaultYn;

        return $this;
    }

    /**
     * Get pgTypeObjDataDefaultYn
     *
     * @return boolean
     */
    public function getPgTypeObjDataDefaultYn()
    {
        return $this->pgTypeObjDataDefaultYn;
    }

    /**
     * Set pgTypeObjDataInactiveYn
     *
     * @param boolean $pgTypeObjDataInactiveYn
     *
     * @return PgTypeObjData
     */
    public function setPgTypeObjDataInactiveYn($pgTypeObjDataInactiveYn)
    {
        $this->pgTypeObjDataInactiveYn = $pgTypeObjDataInactiveYn;

        return $this;
    }

    /**
     * Get pgTypeObjDataInactiveYn
     *
     * @return boolean
     */
    public function getPgTypeObjDataInactiveYn()
    {
        return $this->pgTypeObjDataInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PgTypeObjData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set pgTypeObjDataTrfYn
     *
     * @param boolean $pgTypeObjDataTrfYn
     *
     * @return PgTypeObjData
     */
    public function setPgTypeObjDataTrfYn($pgTypeObjDataTrfYn)
    {
        $this->pgTypeObjDataTrfYn = $pgTypeObjDataTrfYn;

        return $this;
    }

    /**
     * Get pgTypeObjDataTrfYn
     *
     * @return boolean
     */
    public function getPgTypeObjDataTrfYn()
    {
        return $this->pgTypeObjDataTrfYn;
    }
}
