<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrAgent
 *
 * @ORM\Table(name="pr_agent", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_agent_trf_yn", columns={"pr_agent_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="ac_pay_plan_id", columns={"ac_pay_plan_id"})})
 * @ORM\Entity
 */
class PrAgent
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_agent_id", type="string", length=36, nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prAgentId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_agent_account", type="string", length=50, nullable=true)
     */
    private $prAgentAccount;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_agent_alloc_auto_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $prAgentAllocAutoYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_agent_alloc_ext_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prAgentAllocExtYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_agent_commission_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $prAgentCommissionPerc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_agent_comm_deduct_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prAgentCommDeductYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_agent_note_conf", type="text", length=65535, nullable=true)
     */
    private $prAgentNoteConf;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_agent_note_open", type="text", length=65535, nullable=true)
     */
    private $prAgentNoteOpen;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_agent_show_allocs_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prAgentShowAllocsInd;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_plan_id", type="string", length=36, nullable=true)
     */
    private $acPayPlanId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_final_base", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayFinalBase;

    /**
     * @var boolean
     *
     * @ORM\Column(name="ac_pay_final_days", type="boolean", nullable=false, options={"default"="0"})
     */
    private $acPayFinalDays;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true)
     */
    private $rtRateTypeId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_agent_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prAgentInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_agent_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prAgentTrfYn;



    /**
     * Get prAgentId
     *
     * @return string
     */
    public function getPrAgentId()
    {
        return $this->prAgentId;
    }

    /**
     * Set prAgentAccount
     *
     * @param string $prAgentAccount
     *
     * @return PrAgent
     */
    public function setPrAgentAccount($prAgentAccount)
    {
        $this->prAgentAccount = $prAgentAccount;

        return $this;
    }

    /**
     * Get prAgentAccount
     *
     * @return string
     */
    public function getPrAgentAccount()
    {
        return $this->prAgentAccount;
    }

    /**
     * Set prAgentAllocAutoYn
     *
     * @param boolean $prAgentAllocAutoYn
     *
     * @return PrAgent
     */
    public function setPrAgentAllocAutoYn($prAgentAllocAutoYn)
    {
        $this->prAgentAllocAutoYn = $prAgentAllocAutoYn;

        return $this;
    }

    /**
     * Get prAgentAllocAutoYn
     *
     * @return boolean
     */
    public function getPrAgentAllocAutoYn()
    {
        return $this->prAgentAllocAutoYn;
    }

    /**
     * Set prAgentAllocExtYn
     *
     * @param boolean $prAgentAllocExtYn
     *
     * @return PrAgent
     */
    public function setPrAgentAllocExtYn($prAgentAllocExtYn)
    {
        $this->prAgentAllocExtYn = $prAgentAllocExtYn;

        return $this;
    }

    /**
     * Get prAgentAllocExtYn
     *
     * @return boolean
     */
    public function getPrAgentAllocExtYn()
    {
        return $this->prAgentAllocExtYn;
    }

    /**
     * Set prAgentCommissionPerc
     *
     * @param string $prAgentCommissionPerc
     *
     * @return PrAgent
     */
    public function setPrAgentCommissionPerc($prAgentCommissionPerc)
    {
        $this->prAgentCommissionPerc = $prAgentCommissionPerc;

        return $this;
    }

    /**
     * Get prAgentCommissionPerc
     *
     * @return string
     */
    public function getPrAgentCommissionPerc()
    {
        return $this->prAgentCommissionPerc;
    }

    /**
     * Set prAgentCommDeductYn
     *
     * @param boolean $prAgentCommDeductYn
     *
     * @return PrAgent
     */
    public function setPrAgentCommDeductYn($prAgentCommDeductYn)
    {
        $this->prAgentCommDeductYn = $prAgentCommDeductYn;

        return $this;
    }

    /**
     * Get prAgentCommDeductYn
     *
     * @return boolean
     */
    public function getPrAgentCommDeductYn()
    {
        return $this->prAgentCommDeductYn;
    }

    /**
     * Set prAgentNoteConf
     *
     * @param string $prAgentNoteConf
     *
     * @return PrAgent
     */
    public function setPrAgentNoteConf($prAgentNoteConf)
    {
        $this->prAgentNoteConf = $prAgentNoteConf;

        return $this;
    }

    /**
     * Get prAgentNoteConf
     *
     * @return string
     */
    public function getPrAgentNoteConf()
    {
        return $this->prAgentNoteConf;
    }

    /**
     * Set prAgentNoteOpen
     *
     * @param string $prAgentNoteOpen
     *
     * @return PrAgent
     */
    public function setPrAgentNoteOpen($prAgentNoteOpen)
    {
        $this->prAgentNoteOpen = $prAgentNoteOpen;

        return $this;
    }

    /**
     * Get prAgentNoteOpen
     *
     * @return string
     */
    public function getPrAgentNoteOpen()
    {
        return $this->prAgentNoteOpen;
    }

    /**
     * Set prAgentShowAllocsInd
     *
     * @param boolean $prAgentShowAllocsInd
     *
     * @return PrAgent
     */
    public function setPrAgentShowAllocsInd($prAgentShowAllocsInd)
    {
        $this->prAgentShowAllocsInd = $prAgentShowAllocsInd;

        return $this;
    }

    /**
     * Get prAgentShowAllocsInd
     *
     * @return boolean
     */
    public function getPrAgentShowAllocsInd()
    {
        return $this->prAgentShowAllocsInd;
    }

    /**
     * Set acPayPlanId
     *
     * @param string $acPayPlanId
     *
     * @return PrAgent
     */
    public function setAcPayPlanId($acPayPlanId)
    {
        $this->acPayPlanId = $acPayPlanId;

        return $this;
    }

    /**
     * Get acPayPlanId
     *
     * @return string
     */
    public function getAcPayPlanId()
    {
        return $this->acPayPlanId;
    }

    /**
     * Set acPayFinalBase
     *
     * @param boolean $acPayFinalBase
     *
     * @return PrAgent
     */
    public function setAcPayFinalBase($acPayFinalBase)
    {
        $this->acPayFinalBase = $acPayFinalBase;

        return $this;
    }

    /**
     * Get acPayFinalBase
     *
     * @return boolean
     */
    public function getAcPayFinalBase()
    {
        return $this->acPayFinalBase;
    }

    /**
     * Set acPayFinalDays
     *
     * @param boolean $acPayFinalDays
     *
     * @return PrAgent
     */
    public function setAcPayFinalDays($acPayFinalDays)
    {
        $this->acPayFinalDays = $acPayFinalDays;

        return $this;
    }

    /**
     * Get acPayFinalDays
     *
     * @return boolean
     */
    public function getAcPayFinalDays()
    {
        return $this->acPayFinalDays;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return PrAgent
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set prAgentInactiveYn
     *
     * @param boolean $prAgentInactiveYn
     *
     * @return PrAgent
     */
    public function setPrAgentInactiveYn($prAgentInactiveYn)
    {
        $this->prAgentInactiveYn = $prAgentInactiveYn;

        return $this;
    }

    /**
     * Get prAgentInactiveYn
     *
     * @return boolean
     */
    public function getPrAgentInactiveYn()
    {
        return $this->prAgentInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrAgent
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prAgentTrfYn
     *
     * @param boolean $prAgentTrfYn
     *
     * @return PrAgent
     */
    public function setPrAgentTrfYn($prAgentTrfYn)
    {
        $this->prAgentTrfYn = $prAgentTrfYn;

        return $this;
    }

    /**
     * Get prAgentTrfYn
     *
     * @return boolean
     */
    public function getPrAgentTrfYn()
    {
        return $this->prAgentTrfYn;
    }
}
