<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrAgentRate
 *
 * @ORM\Table(name="pr_agent_rate", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_agent_rate_trf_yn", columns={"pr_agent_rate_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrAgentRate
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_agent_rate_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prAgentRateIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_agent_rate_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $prAgentRateDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_agent_rate_id", type="integer", nullable=false)
     */
    private $prAgentRateId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_agent_rate_default_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prAgentRateDefaultYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_agent_id", type="string", length=36, nullable=true)
     */
    private $prAgentId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true)
     */
    private $rtRateTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_agent_rate_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prAgentRateTrfYn;



    /**
     * Get prAgentRateIx
     *
     * @return string
     */
    public function getPrAgentRateIx()
    {
        return $this->prAgentRateIx;
    }

    /**
     * Set prAgentRateDb
     *
     * @param string $prAgentRateDb
     *
     * @return PrAgentRate
     */
    public function setPrAgentRateDb($prAgentRateDb)
    {
        $this->prAgentRateDb = $prAgentRateDb;

        return $this;
    }

    /**
     * Get prAgentRateDb
     *
     * @return string
     */
    public function getPrAgentRateDb()
    {
        return $this->prAgentRateDb;
    }

    /**
     * Set prAgentRateId
     *
     * @param integer $prAgentRateId
     *
     * @return PrAgentRate
     */
    public function setPrAgentRateId($prAgentRateId)
    {
        $this->prAgentRateId = $prAgentRateId;

        return $this;
    }

    /**
     * Get prAgentRateId
     *
     * @return integer
     */
    public function getPrAgentRateId()
    {
        return $this->prAgentRateId;
    }

    /**
     * Set prAgentRateDefaultYn
     *
     * @param boolean $prAgentRateDefaultYn
     *
     * @return PrAgentRate
     */
    public function setPrAgentRateDefaultYn($prAgentRateDefaultYn)
    {
        $this->prAgentRateDefaultYn = $prAgentRateDefaultYn;

        return $this;
    }

    /**
     * Get prAgentRateDefaultYn
     *
     * @return boolean
     */
    public function getPrAgentRateDefaultYn()
    {
        return $this->prAgentRateDefaultYn;
    }

    /**
     * Set prAgentId
     *
     * @param string $prAgentId
     *
     * @return PrAgentRate
     */
    public function setPrAgentId($prAgentId)
    {
        $this->prAgentId = $prAgentId;

        return $this;
    }

    /**
     * Get prAgentId
     *
     * @return string
     */
    public function getPrAgentId()
    {
        return $this->prAgentId;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return PrAgentRate
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrAgentRate
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prAgentRateTrfYn
     *
     * @param boolean $prAgentRateTrfYn
     *
     * @return PrAgentRate
     */
    public function setPrAgentRateTrfYn($prAgentRateTrfYn)
    {
        $this->prAgentRateTrfYn = $prAgentRateTrfYn;

        return $this;
    }

    /**
     * Get prAgentRateTrfYn
     *
     * @return boolean
     */
    public function getPrAgentRateTrfYn()
    {
        return $this->prAgentRateTrfYn;
    }
}
