<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrBusBank
 *
 * @ORM\Table(name="pr_bus_bank", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_bus_bank_trf_yn", columns={"pr_bus_bank_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrBusBank
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_bank_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prBusBankIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_bank_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $prBusBankDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_bus_bank_id", type="integer", nullable=true)
     */
    private $prBusBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_bank_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusBankTrfYn;



    /**
     * Get prBusBankIx
     *
     * @return string
     */
    public function getPrBusBankIx()
    {
        return $this->prBusBankIx;
    }

    /**
     * Set prBusBankDb
     *
     * @param string $prBusBankDb
     *
     * @return PrBusBank
     */
    public function setPrBusBankDb($prBusBankDb)
    {
        $this->prBusBankDb = $prBusBankDb;

        return $this;
    }

    /**
     * Get prBusBankDb
     *
     * @return string
     */
    public function getPrBusBankDb()
    {
        return $this->prBusBankDb;
    }
    
     /**
     * Set prBusBankId
     *
     * @param integer $prBusBankId
     *
     * @return PrBusBank
     */
    public function setPrBusBankId($prBusBankId)
    {
        $this->prBusBankId = $prBusBankId;

        return $this;
    }

    /**
     * Get prBusBankId
     *
     * @return integer
     */
    public function getPrBusBankId()
    {
        return $this->prBusBankId;
    }

    /**
     * Set rfBankId
     *
     * @param string $rfBankId
     *
     * @return PrBusBank
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return string
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return PrBusBank
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrBusBank
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prBusBankTrfYn
     *
     * @param boolean $prBusBankTrfYn
     *
     * @return PrBusBank
     */
    public function setPrBusBankTrfYn($prBusBankTrfYn)
    {
        $this->prBusBankTrfYn = $prBusBankTrfYn;

        return $this;
    }

    /**
     * Get prBusBankTrfYn
     *
     * @return boolean
     */
    public function getPrBusBankTrfYn()
    {
        return $this->prBusBankTrfYn;
    }
}
