<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrBusImage
 *
 * @ORM\Table(name="pr_bus_image", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_bus_image_trf_yn", columns={"pr_bus_image_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrBusImage
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_image_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prBusImageIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_image_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prBusImageDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_bus_image_id", type="integer", nullable=false)
     */
    private $prBusImageId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_image_desc", type="string", length=50, nullable=true, options={"default"=""})
     */
    private $prBusImageDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_image_filename", type="string", length=255, nullable=true)
     */
    private $prBusImageFilename;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_image_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusImageTrfYn;



    /**
     * Get prBusImageIx
     *
     * @return string
     */
    public function getPrBusImageIx()
    {
        return $this->prBusImageIx;
    }

    /**
     * Set prBusImageDb
     *
     * @param string $prBusImageDb
     *
     * @return PrBusImage
     */
    public function setPrBusImageDb($prBusImageDb)
    {
        $this->prBusImageDb = $prBusImageDb;

        return $this;
    }

    /**
     * Get prBusImageDb
     *
     * @return string
     */
    public function getPrBusImageDb()
    {
        return $this->prBusImageDb;
    }

    /**
     * Set prBusImageId
     *
     * @param integer $prBusImageId
     *
     * @return PrBusImage
     */
    public function setPrBusImageId($prBusImageId)
    {
        $this->prBusImageId = $prBusImageId;

        return $this;
    }

    /**
     * Get prBusImageId
     *
     * @return integer
     */
    public function getPrBusImageId()
    {
        return $this->prBusImageId;
    }

    /**
     * Set prBusImageDesc
     *
     * @param string $prBusImageDesc
     *
     * @return PrBusImage
     */
    public function setPrBusImageDesc($prBusImageDesc)
    {
        $this->prBusImageDesc = $prBusImageDesc;

        return $this;
    }

    /**
     * Get prBusImageDesc
     *
     * @return string
     */
    public function getPrBusImageDesc()
    {
        return $this->prBusImageDesc;
    }

    /**
     * Set prBusImageFilename
     *
     * @param string $prBusImageFilename
     *
     * @return PrBusImage
     */
    public function setPrBusImageFilename($prBusImageFilename)
    {
        $this->prBusImageFilename = $prBusImageFilename;

        return $this;
    }

    /**
     * Get prBusImageFilename
     *
     * @return string
     */
    public function getPrBusImageFilename()
    {
        return $this->prBusImageFilename;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return PrBusImage
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrBusImage
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prBusImageTrfYn
     *
     * @param boolean $prBusImageTrfYn
     *
     * @return PrBusImage
     */
    public function setPrBusImageTrfYn($prBusImageTrfYn)
    {
        $this->prBusImageTrfYn = $prBusImageTrfYn;

        return $this;
    }

    /**
     * Get prBusImageTrfYn
     *
     * @return boolean
     */
    public function getPrBusImageTrfYn()
    {
        return $this->prBusImageTrfYn;
    }
}
