<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrBusTax
 *
 * @ORM\Table(name="pr_bus_tax", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_bus_tax_trf_yn", columns={"pr_bus_tax_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrBusTax
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_tax_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prBusTaxIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_tax_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prBusTaxDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_bus_tax_id", type="integer", nullable=false)
     */
    private $prBusTaxId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_tax_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusTaxSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_id", type="string", length=36, nullable=true)
     */
    private $rfTaxRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_tax_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusTaxTrfYn;



    /**
     * Get prBusTaxIx
     *
     * @return string
     */
    public function getPrBusTaxIx()
    {
        return $this->prBusTaxIx;
    }

    /**
     * Set prBusTaxDb
     *
     * @param string $prBusTaxDb
     *
     * @return PrBusTax
     */
    public function setPrBusTaxDb($prBusTaxDb)
    {
        $this->prBusTaxDb = $prBusTaxDb;

        return $this;
    }

    /**
     * Get prBusTaxDb
     *
     * @return string
     */
    public function getPrBusTaxDb()
    {
        return $this->prBusTaxDb;
    }

    /**
     * Set prBusTaxId
     *
     * @param integer $prBusTaxId
     *
     * @return PrBusTax
     */
    public function setPrBusTaxId($prBusTaxId)
    {
        $this->prBusTaxId = $prBusTaxId;

        return $this;
    }

    /**
     * Get prBusTaxId
     *
     * @return integer
     */
    public function getPrBusTaxId()
    {
        return $this->prBusTaxId;
    }

    /**
     * Set prBusTaxSeq
     *
     * @param boolean $prBusTaxSeq
     *
     * @return PrBusTax
     */
    public function setPrBusTaxSeq($prBusTaxSeq)
    {
        $this->prBusTaxSeq = $prBusTaxSeq;

        return $this;
    }

    /**
     * Get prBusTaxSeq
     *
     * @return boolean
     */
    public function getPrBusTaxSeq()
    {
        return $this->prBusTaxSeq;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return PrBusTax
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfTaxRateId
     *
     * @param string $rfTaxRateId
     *
     * @return PrBusTax
     */
    public function setRfTaxRateId($rfTaxRateId)
    {
        $this->rfTaxRateId = $rfTaxRateId;

        return $this;
    }

    /**
     * Get rfTaxRateId
     *
     * @return string
     */
    public function getRfTaxRateId()
    {
        return $this->rfTaxRateId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrBusTax
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prBusTaxTrfYn
     *
     * @param boolean $prBusTaxTrfYn
     *
     * @return PrBusTax
     */
    public function setPrBusTaxTrfYn($prBusTaxTrfYn)
    {
        $this->prBusTaxTrfYn = $prBusTaxTrfYn;

        return $this;
    }

    /**
     * Get prBusTaxTrfYn
     *
     * @return boolean
     */
    public function getPrBusTaxTrfYn()
    {
        return $this->prBusTaxTrfYn;
    }
}
