<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrBusiness
 *
 * @ORM\Table(name="pr_business", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, uniqueConstraints={@ORM\UniqueConstraint(name="pr_bus_name_short", columns={"pr_bus_name_short"})}, indexes={@ORM\Index(name="pr_business_trf_yn", columns={"pr_business_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrBusiness
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prBusinessId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_billing_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusBillingYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_billing_prop_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusBillingPropYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_cost_ctr", type="string", length=10, nullable=true)
     */
    private $prBusCostCtr;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_inv_future_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusInvFutureInd;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_bus_inv_number", type="integer", nullable=false, options={"default"="0"})
     */
    private $prBusInvNumber;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_inv_prefix", type="string", length=5, nullable=false, options={"default"=""})
     */
    private $prBusInvPrefix;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_accomm", type="boolean", nullable=false, options={"default"="1"})
     */
    private $prBusOptAccomm;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_bank", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptBank;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_cca", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptCca;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_date", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptDate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_special", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptSpecial;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_special_note", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptSpecialNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_tax", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptTax;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_tax_table", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptTaxTable;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_tax_table_gl", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptTaxTableGl;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_tax_table_rate", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptTaxTableRate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_tax_table_total", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptTaxTableTotal;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_terms", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptTerms;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_opt_terms_bus", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusOptTermsBus;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_proforma_tax_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusProformaTaxInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_tax_table_align", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusTaxTableAlign = '0';

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_property_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusPropertyYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_post_level_gl", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusPostLevelGl;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_post_clear_dtrs_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusPostClearDtrsYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_post_level_dtrs", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusPostLevelDtrs;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_post_pmt_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $prBusPostPmtYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_post_dep_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $prBusPostDepYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_post_inv_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $prBusPostInvYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_post_tax_cost_ctr_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusPostTaxCostCtrYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_post_source_curr_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusPostSourceCurrYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_ignore_past_pmt_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $prBusIgnorePastPmtYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_statutory_1", type="string", length=50, nullable=true)
     */
    private $prBusStatutory1;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_statutory_2", type="string", length=50, nullable=true)
     */
    private $prBusStatutory2;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_statutory_3", type="string", length=50, nullable=true)
     */
    private $prBusStatutory3;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_statutory_label_1", type="string", length=50, nullable=true)
     */
    private $prBusStatutoryLabel1;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_statutory_label_2", type="string", length=50, nullable=true)
     */
    private $prBusStatutoryLabel2;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_statutory_label_3", type="string", length=50, nullable=true)
     */
    private $prBusStatutoryLabel3;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_wetu_id", type="string", length=50, nullable=true)
     */
    private $prBusWetuId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_wetu_exclude", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusWetuExclude;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_memo_cal", type="text", length=65535, nullable=true)
     */
    private $prBusMemoCal;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_memo_info", type="text", length=65535, nullable=true)
     */
    private $prBusMemoInfo;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_name_short", type="string", length=5, nullable=true)
     */
    private $prBusNameShort;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_business_sequence", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusinessSequence;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_parent", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prBusinessParent;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_1_default_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentre1DefaultId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_1_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentre1Id;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentreId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_id_cash", type="string", length=36, nullable=true)
     */
    private $fnDebtorIdCash;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_id_suspense", type="string", length=36, nullable=true)
     */
    private $fnDebtorIdSuspense;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_id_suspense_foreign", type="string", length=36, nullable=true)
     */
    private $fnDebtorIdSuspenseForeign;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_cash", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdCash;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_debtors", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdDebtors;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_suspense", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdSuspense;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_suspense_foreign", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdSuspenseForeign;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_forex", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdForex;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_id", type="string", length=36, nullable=true)
     */
    private $fnSystemId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_system_email", type="string", length=50, nullable=true)
     */
    private $fnSystemEmail;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_home_curr_id", type="string", length=36, nullable=true)
     */
    private $prBusHomeCurrId;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_bus_post_env_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $prBusPostEnvId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_prop_curr_id", type="string", length=36, nullable=true)
     */
    private $prBusPropCurrId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_prop_latitude", type="string", length=20, nullable=false)
     */
    private $prBusPropLatitude;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_bus_prop_longitude", type="string", length=20, nullable=false)
     */
    private $prBusPropLongitude;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_bus_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusInactiveYn;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_bus_xref_num", type="integer", nullable=false, options={"default"="0"}))
     */
    private $prBusXrefNum;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_business_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prBusinessTrfYn;



    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set prBusBillingYn
     *
     * @param boolean $prBusBillingYn
     *
     * @return PrBusiness
     */
    public function setPrBusBillingYn($prBusBillingYn)
    {
        $this->prBusBillingYn = $prBusBillingYn;

        return $this;
    }

    /**
     * Get prBusBillingYn
     *
     * @return boolean
     */
    public function getPrBusBillingYn()
    {
        return $this->prBusBillingYn;
    }

    /**
     * Set prBusBillingPropYn
     *
     * @param boolean $prBusBillingPropYn
     *
     * @return PrBusiness
     */
    public function setPrBusBillingPropYn($prBusBillingPropYn)
    {
        $this->prBusBillingPropYn = $prBusBillingPropYn;

        return $this;
    }

    /**
     * Get prBusBillingPropYn
     *
     * @return boolean
     */
    public function getPrBusBillingPropYn()
    {
        return $this->prBusBillingPropYn;
    }

    /**
     * Set prBusCostCtr
     *
     * @param string $prBusCostCtr
     *
     * @return PrBusiness
     */
    public function setPrBusCostCtr($prBusCostCtr)
    {
        $this->prBusCostCtr = $prBusCostCtr;

        return $this;
    }

    /**
     * Get prBusCostCtr
     *
     * @return string
     */
    public function getPrBusCostCtr()
    {
        return $this->prBusCostCtr;
    }

    /**
     * Set prBusInvFutureInd
     *
     * @param boolean $prBusInvFutureInd
     *
     * @return PrBusiness
     */
    public function setPrBusInvFutureInd($prBusInvFutureInd)
    {
        $this->prBusInvFutureInd = $prBusInvFutureInd;

        return $this;
    }

    /**
     * Get prBusInvFutureInd
     *
     * @return boolean
     */
    public function getPrBusInvFutureInd()
    {
        return $this->prBusInvFutureInd;
    }

    /**
     * Set prBusInvNumber
     *
     * @param integer $prBusInvNumber
     *
     * @return PrBusiness
     */
    public function setPrBusInvNumber($prBusInvNumber)
    {
        $this->prBusInvNumber = $prBusInvNumber;

        return $this;
    }

    /**
     * Get prBusInvNumber
     *
     * @return integer
     */
    public function getPrBusInvNumber()
    {
        return $this->prBusInvNumber;
    }

    /**
     * Set prBusInvPrefix
     *
     * @param string $prBusInvPrefix
     *
     * @return PrBusiness
     */
    public function setPrBusInvPrefix($prBusInvPrefix)
    {
        $this->prBusInvPrefix = $prBusInvPrefix;

        return $this;
    }

    /**
     * Get prBusInvPrefix
     *
     * @return string
     */
    public function getPrBusInvPrefix()
    {
        return $this->prBusInvPrefix;
    }

    /**
     * Set prBusOptAccomm
     *
     * @param boolean $prBusOptAccomm
     *
     * @return PrBusiness
     */
    public function setPrBusOptAccomm($prBusOptAccomm)
    {
        $this->prBusOptAccomm = $prBusOptAccomm;

        return $this;
    }

    /**
     * Get prBusOptAccomm
     *
     * @return boolean
     */
    public function getPrBusOptAccomm()
    {
        return $this->prBusOptAccomm;
    }

    /**
     * Set prBusOptBank
     *
     * @param boolean $prBusOptBank
     *
     * @return PrBusiness
     */
    public function setPrBusOptBank($prBusOptBank)
    {
        $this->prBusOptBank = $prBusOptBank;

        return $this;
    }

    /**
     * Get prBusOptBank
     *
     * @return boolean
     */
    public function getPrBusOptBank()
    {
        return $this->prBusOptBank;
    }

    /**
     * Set prBusOptCca
     *
     * @param boolean $prBusOptCca
     *
     * @return PrBusiness
     */
    public function setPrBusOptCca($prBusOptCca)
    {
        $this->prBusOptCca = $prBusOptCca;

        return $this;
    }

    /**
     * Get prBusOptCca
     *
     * @return boolean
     */
    public function getPrBusOptCca()
    {
        return $this->prBusOptCca;
    }

    /**
     * Set prBusOptDate
     *
     * @param boolean $prBusOptDate
     *
     * @return PrBusiness
     */
    public function setPrBusOptDate($prBusOptDate)
    {
        $this->prBusOptDate = $prBusOptDate;

        return $this;
    }

    /**
     * Get prBusOptDate
     *
     * @return boolean
     */
    public function getPrBusOptDate()
    {
        return $this->prBusOptDate;
    }

    /**
     * Set prBusOptSpecial
     *
     * @param boolean $prBusOptSpecial
     *
     * @return PrBusiness
     */
    public function setPrBusOptSpecial($prBusOptSpecial)
    {
        $this->prBusOptSpecial = $prBusOptSpecial;

        return $this;
    }

    /**
     * Get prBusOptSpecial
     *
     * @return boolean
     */
    public function getPrBusOptSpecial()
    {
        return $this->prBusOptSpecial;
    }

    /**
     * Set prBusOptSpecialNote
     *
     * @param boolean $prBusOptSpecialNote
     *
     * @return PrBusiness
     */
    public function setPrBusOptSpecialNote($prBusOptSpecialNote)
    {
        $this->prBusOptSpecialNote = $prBusOptSpecialNote;

        return $this;
    }

    /**
     * Get prBusOptSpecialNote
     *
     * @return boolean
     */
    public function getPrBusOptSpecialNote()
    {
        return $this->prBusOptSpecialNote;
    }

    /**
     * Set prBusOptTax
     *
     * @param boolean $prBusOptTax
     *
     * @return PrBusiness
     */
    public function setPrBusOptTax($prBusOptTax)
    {
        $this->prBusOptTax = $prBusOptTax;

        return $this;
    }

    /**
     * Get prBusOptTax
     *
     * @return boolean
     */
    public function getPrBusOptTax()
    {
        return $this->prBusOptTax;
    }

    /**
     * Set prBusOptTaxTable
     *
     * @param boolean $prBusOptTaxTable
     *
     * @return PrBusiness
     */
    public function setPrBusOptTaxTable($prBusOptTaxTable)
    {
        $this->prBusOptTaxTable = $prBusOptTaxTable;

        return $this;
    }

    /**
     * Get prBusOptTaxTable
     *
     * @return boolean
     */
    public function getPrBusOptTaxTable()
    {
        return $this->prBusOptTaxTable;
    }

    /**
     * Set prBusOptTaxTableGl
     *
     * @param boolean $prBusOptTaxTableGl
     *
     * @return PrBusiness
     */
    public function setPrBusOptTaxTableGl($prBusOptTaxTableGl)
    {
        $this->prBusOptTaxTableGl = $prBusOptTaxTableGl;

        return $this;
    }

    /**
     * Get prBusOptTaxTableGl
     *
     * @return boolean
     */
    public function getPrBusOptTaxTableGl()
    {
        return $this->prBusOptTaxTableGl;
    }

    /**
     * Set prBusOptTaxTableRate
     *
     * @param boolean $prBusOptTaxTableRate
     *
     * @return PrBusiness
     */
    public function setPrBusOptTaxTableRate($prBusOptTaxTableRate)
    {
        $this->prBusOptTaxTableRate = $prBusOptTaxTableRate;

        return $this;
    }

    /**
     * Get prBusOptTaxTableRate
     *
     * @return boolean
     */
    public function getPrBusOptTaxTableRate()
    {
        return $this->prBusOptTaxTableRate;
    }

    /**
     * Set prBusOptTaxTableTotal
     *
     * @param boolean $prBusOptTaxTableTotal
     *
     * @return PrBusiness
     */
    public function setPrBusOptTaxTableTotal($prBusOptTaxTableTotal)
    {
        $this->prBusOptTaxTableTotal = $prBusOptTaxTableTotal;

        return $this;
    }

    /**
     * Get prBusOptTaxTableTotal
     *
     * @return boolean
     */
    public function getPrBusOptTaxTableTotal()
    {
        return $this->prBusOptTaxTableTotal;
    }

    /**
     * Set prBusOptTerms
     *
     * @param boolean $prBusOptTerms
     *
     * @return PrBusiness
     */
    public function setPrBusOptTerms($prBusOptTerms)
    {
        $this->prBusOptTerms = $prBusOptTerms;

        return $this;
    }

    /**
     * Get prBusOptTerms
     *
     * @return boolean
     */
    public function getPrBusOptTerms()
    {
        return $this->prBusOptTerms;
    }

    /**
     * Set prBusOptTermsBus
     *
     * @param boolean $prBusOptTermsBus
     *
     * @return PrBusiness
     */
    public function setPrBusOptTermsBus($prBusOptTermsBus)
    {
        $this->prBusOptTermsBus = $prBusOptTermsBus;

        return $this;
    }

    /**
     * Get prBusOptTermsBus
     *
     * @return boolean
     */
    public function getPrBusOptTermsBus()
    {
        return $this->prBusOptTermsBus;
    }

    /**
     * Set prBusProformaTaxInd
     *
     * @param boolean $prBusProformaTaxInd
     *
     * @return PrBusiness
     */
    public function setPrBusProformaTaxInd($prBusProformaTaxInd)
    {
        $this->prBusProformaTaxInd = $prBusProformaTaxInd;

        return $this;
    }

    /**
     * Get prBusProformaTaxInd
     *
     * @return boolean
     */
    public function getPrBusProformaTaxInd()
    {
        return $this->prBusProformaTaxInd;
    }

    /**
     * Set prBusTaxTableAlign
     *
     * @param boolean $prBusTaxTableAlign
     *
     * @return PrBusiness
     */
    public function setPrBusTaxTableAlign($prBusTaxTableAlign)
    {
        $this->prBusTaxTableAlign = $prBusTaxTableAlign;

        return $this;
    }

    /**
     * Get prBusTaxTableAlign
     *
     * @return boolean
     */
    public function getPrBusTaxTableAlign()
    {
        return $this->prBusTaxTableAlign;
    }


    /**
     * Set prBusPropertyYn
     *
     * @param boolean $prBusPropertyYn
     *
     * @return PrBusiness
     */
    public function setPrBusPropertyYn($prBusPropertyYn)
    {
        $this->prBusPropertyYn = $prBusPropertyYn;

        return $this;
    }

    /**
     * Get prBusPropertyYn
     *
     * @return boolean
     */
    public function getPrBusPropertyYn()
    {
        return $this->prBusPropertyYn;
    }

    /**
     * Set prBusPostLevelGl
     *
     * @param boolean $prBusPostLevelGl
     *
     * @return PrBusiness
     */
    public function setPrBusPostLevelGl($prBusPostLevelGl)
    {
        $this->prBusPostLevelGl = $prBusPostLevelGl;

        return $this;
    }

    /**
     * Get prBusPostLevelGl
     *
     * @return boolean
     */
    public function getPrBusPostLevelGl()
    {
        return $this->prBusPostLevelGl;
    }

    /**
     * Set prBusPostClearDtrsYn
     *
     * @param boolean $prBusPostClearDtrsYn
     *
     * @return PrBusiness
     */
    public function setPrBusPostClearDtrsYn($prBusPostClearDtrsYn)
    {
        $this->prBusPostClearDtrsYn = $prBusPostClearDtrsYn;

        return $this;
    }

    /**
     * Get prBusPostClearDtrsYn
     *
     * @return boolean
     */
    public function getPrBusPostClearDtrsYn()
    {
        return $this->prBusPostClearDtrsYn;
    }

    /**
     * Set prBusPostLevelDtrs
     *
     * @param boolean $prBusPostLevelDtrs
     *
     * @return PrBusiness
     */
    public function setPrBusPostLevelDtrs($prBusPostLevelDtrs)
    {
        $this->prBusPostLevelDtrs = $prBusPostLevelDtrs;

        return $this;
    }

    /**
     * Get prBusPostLevelDtrs
     *
     * @return boolean
     */
    public function getPrBusPostLevelDtrs()
    {
        return $this->prBusPostLevelDtrs;
    }

    /**
     * Set prBusPostPmtYn
     *
     * @param boolean $prBusPostPmtYn
     *
     * @return PrBusiness
     */
    public function setPrBusPostPmtYn($prBusPostPmtYn)
    {
        $this->prBusPostPmtYn = $prBusPostPmtYn;

        return $this;
    }

    /**
     * Get prBusPostPmtYn
     *
     * @return boolean
     */
    public function getPrBusPostPmtYn()
    {
        return $this->prBusPostPmtYn;
    }

    /**
     * Set prBusPostDepYn
     *
     * @param boolean $prBusPostDepYn
     *
     * @return PrBusiness
     */
    public function setPrBusPostDepYn($prBusPostDepYn)
    {
        $this->prBusPostDepYn = $prBusPostDepYn;

        return $this;
    }

    /**
     * Get prBusPostDepYn
     *
     * @return boolean
     */
    public function getPrBusPostDepYn()
    {
        return $this->prBusPostDepYn;
    }

    /**
     * Set prBusPostInvYn
     *
     * @param boolean $prBusPostInvYn
     *
     * @return PrBusiness
     */
    public function setPrBusPostInvYn($prBusPostInvYn)
    {
        $this->prBusPostInvYn = $prBusPostInvYn;

        return $this;
    }

    /**
     * Get prBusPostInvYn
     *
     * @return boolean
     */
    public function getPrBusPostInvYn()
    {
        return $this->prBusPostInvYn;
    }

    /**
     * Set prBusPostTaxCostCtrYn
     *
     * @param boolean $prBusPostTaxCostCtrYn
     *
     * @return PrBusiness
     */
    public function setPrBusPostTaxCostCtrYn($prBusPostTaxCostCtrYn)
    {
        $this->prBusPostTaxCostCtrYn = $prBusPostTaxCostCtrYn;

        return $this;
    }

    /**
     * Get prBusPostTaxCostCtrYn
     *
     * @return boolean
     */
    public function getPrBusPostTaxCostCtrYn()
    {
        return $this->prBusPostTaxCostCtrYn;
    }

    /**
     * Set prBusPostSourceCurrYn
     *
     * @param boolean $prBusPostSourceCurrYn
     *
     * @return PrBusiness
     */
    public function setPrBusPostSourceCurrYn($prBusPostSourceCurrYn)
    {
        $this->prBusPostSourceCurrYn = $prBusPostSourceCurrYn;

        return $this;
    }

    /**
     * Get prBusPostSourceCurrYn
     *
     * @return boolean
     */
    public function getPrBusPostSourceCurrYn()
    {
        return $this->prBusPostSourceCurrYn;
    }

    /**
     * Set prBusIgnorePastPmtYn
     *
     * @param boolean $prBusIgnorePastPmtYn
     *
     * @return PrBusiness
     */
    public function setPrBusIgnorePastPmtYn($prBusIgnorePastPmtYn)
    {
        $this->prBusIgnorePastPmtYn = $prBusIgnorePastPmtYn;

        return $this;
    }

    /**
     * Get prBusIgnorePastPmtYn
     *
     * @return boolean
     */
    public function getPrBusIgnorePastPmtYn()
    {
        return $this->prBusIgnorePastPmtYn;
    }

    /**
     * Set prBusStatutory1
     *
     * @param string $prBusStatutory1
     *
     * @return PrBusiness
     */
    public function setPrBusStatutory1($prBusStatutory1)
    {
        $this->prBusStatutory1 = $prBusStatutory1;

        return $this;
    }

    /**
     * Get prBusStatutory1
     *
     * @return string
     */
    public function getPrBusStatutory1()
    {
        return $this->prBusStatutory1;
    }

    /**
     * Set prBusStatutory2
     *
     * @param string $prBusStatutory2
     *
     * @return PrBusiness
     */
    public function setPrBusStatutory2($prBusStatutory2)
    {
        $this->prBusStatutory2 = $prBusStatutory2;

        return $this;
    }

    /**
     * Get prBusStatutory2
     *
     * @return string
     */
    public function getPrBusStatutory2()
    {
        return $this->prBusStatutory2;
    }

    /**
     * Set prBusStatutory3
     *
     * @param string $prBusStatutory3
     *
     * @return PrBusiness
     */
    public function setPrBusStatutory3($prBusStatutory3)
    {
        $this->prBusStatutory3 = $prBusStatutory3;

        return $this;
    }

    /**
     * Get prBusStatutory3
     *
     * @return string
     */
    public function getPrBusStatutory3()
    {
        return $this->prBusStatutory3;
    }

    /**
     * Set prBusStatutoryLabel1
     *
     * @param string $prBusStatutoryLabel1
     *
     * @return PrBusiness
     */
    public function setPrBusStatutoryLabel1($prBusStatutoryLabel1)
    {
        $this->prBusStatutoryLabel1 = $prBusStatutoryLabel1;

        return $this;
    }

    /**
     * Get prBusStatutoryLabel1
     *
     * @return string
     */
    public function getPrBusStatutoryLabel1()
    {
        return $this->prBusStatutoryLabel1;
    }

    /**
     * Set prBusStatutoryLabel2
     *
     * @param string $prBusStatutoryLabel2
     *
     * @return PrBusiness
     */
    public function setPrBusStatutoryLabel2($prBusStatutoryLabel2)
    {
        $this->prBusStatutoryLabel2 = $prBusStatutoryLabel2;

        return $this;
    }

    /**
     * Get prBusStatutoryLabel2
     *
     * @return string
     */
    public function getPrBusStatutoryLabel2()
    {
        return $this->prBusStatutoryLabel2;
    }

    /**
     * Set prBusStatutoryLabel3
     *
     * @param string $prBusStatutoryLabel3
     *
     * @return PrBusiness
     */
    public function setPrBusStatutoryLabel3($prBusStatutoryLabel3)
    {
        $this->prBusStatutoryLabel3 = $prBusStatutoryLabel3;

        return $this;
    }

    /**
     * Get prBusStatutoryLabel3
     *
     * @return string
     */
    public function getPrBusStatutoryLabel3()
    {
        return $this->prBusStatutoryLabel3;
    }

    /**
     * Set prBusWetuId
     *
     * @param string $prBusWetuId
     *
     * @return PrBusiness
     */
    public function setPrBusWetuId($prBusWetuId)
    {
        $this->prBusWetuId = $prBusWetuId;

        return $this;
    }

    /**
     * Get prBusWetuId
     *
     * @return string
     */
    public function getPrBusWetuId()
    {
        return $this->prBusWetuId;
    }

    /**
     * Set prBusWetuExclude
     *
     * @param boolean $prBusWetuExclude
     *
     * @return PrBusiness
     */
    public function setPrBusWetuExclude($prBusWetuExclude)
    {
        $this->prBusWetuExclude = $prBusWetuExclude;

        return $this;
    }

    /**
     * Get prBusWetuExclude
     *
     * @return boolean
     */
    public function getPrBusWetuExclude()
    {
        return $this->prBusWetuExclude;
    }

    /**
     * Set prBusMemoCal
     *
     * @param string $prBusMemoCal
     *
     * @return PrBusiness
     */
    public function setPrBusMemoCal($prBusMemoCal)
    {
        $this->prBusMemoCal = $prBusMemoCal;

        return $this;
    }

    /**
     * Get prBusMemoCal
     *
     * @return string
     */
    public function getPrBusMemoCal()
    {
        return $this->prBusMemoCal;
    }

    /**
     * Set prBusMemoInfo
     *
     * @param string $prBusMemoInfo
     *
     * @return PrBusiness
     */
    public function setPrBusMemoInfo($prBusMemoInfo)
    {
        $this->prBusMemoInfo = $prBusMemoInfo;

        return $this;
    }

    /**
     * Get prBusMemoInfo
     *
     * @return string
     */
    public function getPrBusMemoInfo()
    {
        return $this->prBusMemoInfo;
    }

    /**
     * Set prBusNameShort
     *
     * @param string $prBusNameShort
     *
     * @return PrBusiness
     */
    public function setPrBusNameShort($prBusNameShort)
    {
        $this->prBusNameShort = $prBusNameShort;

        return $this;
    }

    /**
     * Get prBusNameShort
     *
     * @return string
     */
    public function getPrBusNameShort()
    {
        return $this->prBusNameShort;
    }

    /**
     * Set prBusinessSequence
     *
     * @param boolean $prBusinessSequence
     *
     * @return PrBusiness
     */
    public function setPrBusinessSequence($prBusinessSequence)
    {
        $this->prBusinessSequence = $prBusinessSequence;

        return $this;
    }

    /**
     * Get prBusinessSequence
     *
     * @return boolean
     */
    public function getPrBusinessSequence()
    {
        return $this->prBusinessSequence;
    }

    /**
     * Set prBusinessParent
     *
     * @param string $prBusinessParent
     *
     * @return PrBusiness
     */
    public function setPrBusinessParent($prBusinessParent)
    {
        $this->prBusinessParent = $prBusinessParent;

        return $this;
    }

    /**
     * Get prBusinessParent
     *
     * @return string
     */
    public function getPrBusinessParent()
    {
        return $this->prBusinessParent;
    }

    /**
     * Set fnCostCentre1DefaultId
     *
     * @param string $fnCostCentre1DefaultId
     *
     * @return PrBusiness
     */
    public function setFnCostCentre1DefaultId($fnCostCentre1DefaultId)
    {
        $this->fnCostCentre1DefaultId = $fnCostCentre1DefaultId;

        return $this;
    }

    /**
     * Get fnCostCentre1DefaultId
     *
     * @return string
     */
    public function getFnCostCentre1DefaultId()
    {
        return $this->fnCostCentre1DefaultId;
    }

    /**
     * Set fnCostCentre1Id
     *
     * @param string $fnCostCentre1Id
     *
     * @return PrBusiness
     */
    public function setFnCostCentre1Id($fnCostCentre1Id)
    {
        $this->fnCostCentre1Id = $fnCostCentre1Id;

        return $this;
    }

    /**
     * Get fnCostCentre1Id
     *
     * @return string
     */
    public function getFnCostCentre1Id()
    {
        return $this->fnCostCentre1Id;
    }

    /**
     * Set fnCostCentreId
     *
     * @param string $fnCostCentreId
     *
     * @return PrBusiness
     */
    public function setFnCostCentreId($fnCostCentreId)
    {
        $this->fnCostCentreId = $fnCostCentreId;

        return $this;
    }

    /**
     * Get fnCostCentreId
     *
     * @return string
     */
    public function getFnCostCentreId()
    {
        return $this->fnCostCentreId;
    }

    /**
     * Set fnDebtorIdCash
     *
     * @param string $fnDebtorIdCash
     *
     * @return PrBusiness
     */
    public function setFnDebtorIdCash($fnDebtorIdCash)
    {
        $this->fnDebtorIdCash = $fnDebtorIdCash;

        return $this;
    }

    /**
     * Get fnDebtorIdCash
     *
     * @return string
     */
    public function getFnDebtorIdCash()
    {
        return $this->fnDebtorIdCash;
    }

    /**
     * Set fnDebtorIdSuspense
     *
     * @param string $fnDebtorIdSuspense
     *
     * @return PrBusiness
     */
    public function setFnDebtorIdSuspense($fnDebtorIdSuspense)
    {
        $this->fnDebtorIdSuspense = $fnDebtorIdSuspense;

        return $this;
    }

    /**
     * Get fnDebtorIdSuspense
     *
     * @return string
     */
    public function getFnDebtorIdSuspense()
    {
        return $this->fnDebtorIdSuspense;
    }

    /**
     * Set fnDebtorIdSuspenseForeign
     *
     * @param string $fnDebtorIdSuspenseForeign
     *
     * @return PrBusiness
     */
    public function setFnDebtorIdSuspenseForeign($fnDebtorIdSuspenseForeign)
    {
        $this->fnDebtorIdSuspenseForeign = $fnDebtorIdSuspenseForeign;

        return $this;
    }

    /**
     * Get fnDebtorIdSuspenseForeign
     *
     * @return string
     */
    public function getFnDebtorIdSuspenseForeign()
    {
        return $this->fnDebtorIdSuspenseForeign;
    }

    /**
     * Set fnLedgerIdCash
     *
     * @param string $fnLedgerIdCash
     *
     * @return PrBusiness
     */
    public function setFnLedgerIdCash($fnLedgerIdCash)
    {
        $this->fnLedgerIdCash = $fnLedgerIdCash;

        return $this;
    }

    /**
     * Get fnLedgerIdCash
     *
     * @return string
     */
    public function getFnLedgerIdCash()
    {
        return $this->fnLedgerIdCash;
    }

    /**
     * Set fnLedgerIdDebtors
     *
     * @param string $fnLedgerIdDebtors
     *
     * @return PrBusiness
     */
    public function setFnLedgerIdDebtors($fnLedgerIdDebtors)
    {
        $this->fnLedgerIdDebtors = $fnLedgerIdDebtors;

        return $this;
    }

    /**
     * Get fnLedgerIdDebtors
     *
     * @return string
     */
    public function getFnLedgerIdDebtors()
    {
        return $this->fnLedgerIdDebtors;
    }

    /**
     * Set fnLedgerIdSuspense
     *
     * @param string $fnLedgerIdSuspense
     *
     * @return PrBusiness
     */
    public function setFnLedgerIdSuspense($fnLedgerIdSuspense)
    {
        $this->fnLedgerIdSuspense = $fnLedgerIdSuspense;

        return $this;
    }

    /**
     * Get fnLedgerIdSuspense
     *
     * @return string
     */
    public function getFnLedgerIdSuspense()
    {
        return $this->fnLedgerIdSuspense;
    }

    /**
     * Set fnLedgerIdSuspenseForeign
     *
     * @param string $fnLedgerIdSuspenseForeign
     *
     * @return PrBusiness
     */
    public function setFnLedgerIdSuspenseForeign($fnLedgerIdSuspenseForeign)
    {
        $this->fnLedgerIdSuspenseForeign = $fnLedgerIdSuspenseForeign;

        return $this;
    }

    /**
     * Get fnLedgerIdSuspenseForeign
     *
     * @return string
     */
    public function getFnLedgerIdSuspenseForeign()
    {
        return $this->fnLedgerIdSuspenseForeign;
    }

    /**
     * Set fnLedgerIdForex
     *
     * @param string $fnLedgerIdForex
     *
     * @return PrBusiness
     */
    public function setFnLedgerIdForex($fnLedgerIdForex)
    {
        $this->fnLedgerIdForex = $fnLedgerIdForex;

        return $this;
    }

    /**
     * Get fnLedgerIdForex
     *
     * @return string
     */
    public function getFnLedgerIdForex()
    {
        return $this->fnLedgerIdForex;
    }

    /**
     * Set fnSystemId
     *
     * @param string $fnSystemId
     *
     * @return PrBusiness
     */
    public function setFnSystemId($fnSystemId)
    {
        $this->fnSystemId = $fnSystemId;

        return $this;
    }

    /**
     * Get fnSystemId
     *
     * @return string
     */
    public function getFnSystemId()
    {
        return $this->fnSystemId;
    }

    /**
     * Set fnSystemEmail
     *
     * @param string $fnSystemEmail
     *
     * @return PrBusiness
     */
    public function setFnSystemEmail($fnSystemEmail)
    {
        $this->fnSystemEmail = $fnSystemEmail;

        return $this;
    }

    /**
     * Get fnSystemEmail
     *
     * @return string
     */
    public function getFnSystemEmail()
    {
        return $this->fnSystemEmail;
    }

    /**
     * Set prBusHomeCurrId
     *
     * @param string $prBusHomeCurrId
     *
     * @return PrBusiness
     */
    public function setPrBusHomeCurrId($prBusHomeCurrId)
    {
        $this->prBusHomeCurrId = $prBusHomeCurrId;

        return $this;
    }

    /**
     * Get prBusHomeCurrId
     *
     * @return string
     */
    public function getPrBusHomeCurrId()
    {
        return $this->prBusHomeCurrId;
    }

    /**
     * Set prBusPostEnvId
     *
     * @param integer $prBusPostEnvId
     *
     * @return PrBusiness
     */
    public function setPrBusPostEnvId($prBusPostEnvId)
    {
        $this->prBusPostEnvId = $prBusPostEnvId;

        return $this;
    }

    /**
     * Get prBusPostEnvId
     *
     * @return integer
     */
    public function getPrBusPostEnvId()
    {
        return $this->prBusPostEnvId;
    }

    /**
     * Set prBusPropCurrId
     *
     * @param string $prBusPropCurrId
     *
     * @return PrBusiness
     */
    public function setPrBusPropCurrId($prBusPropCurrId)
    {
        $this->prBusPropCurrId = $prBusPropCurrId;

        return $this;
    }

    /**
     * Get prBusPropCurrId
     *
     * @return string
     */
    public function getPrBusPropCurrId()
    {
        return $this->prBusPropCurrId;
    }

    /**
     * Set prBusPropLatitude
     *
     * @param string $prBusPropLatitude
     *
     * @return PrBusiness
     */
    public function setPrBusPropLatitude($prBusPropLatitude)
    {
        $this->prBusPropLatitude = $prBusPropLatitude;

        return $this;
    }

    /**
     * Get prBusPropLatitude
     *
     * @return string
     */
    public function getPrBusPropLatitude()
    {
        return $this->prBusPropLatitude;
    }

    /**
     * Set prBusPropLongitude
     *
     * @param string $prBusPropLongitude
     *
     * @return PrBusiness
     */
    public function setPrBusPropLongitude($prBusPropLongitude)
    {
        $this->prBusPropLongitude = $prBusPropLongitude;

        return $this;
    }

    /**
     * Get prBusPropLongitude
     *
     * @return string
     */
    public function getPrBusPropLongitude()
    {
        return $this->prBusPropLongitude;
    }

    /**
     * Set prBusInactiveYn
     *
     * @param boolean $prBusInactiveYn
     *
     * @return PrBusiness
     */
    public function setPrBusInactiveYn($prBusInactiveYn)
    {
        $this->prBusInactiveYn = $prBusInactiveYn;

        return $this;
    }

    /**
     * Get prBusInactiveYn
     *
     * @return boolean
     */
    public function getPrBusInactiveYn()
    {
        return $this->prBusInactiveYn;
    }

    /**
     * Set prBusXrefNum
     *
     * @param integer $prBusXrefNum
     *
     * @return PrBusiness
     */
    public function setPrBusXrefNum($prBusXrefNum)
    {
        $this->prBusXrefNum = $prBusXrefNum;

        return $this;
    }

    /**
     * Get prBusXrefNum
     *
     * @return integer
     */
    public function getPrBusXrefNum()
    {
        return $this->prBusXrefNum;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrBusiness
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prBusinessTrfYn
     *
     * @param boolean $prBusinessTrfYn
     *
     * @return PrBusiness
     */
    public function setPrBusinessTrfYn($prBusinessTrfYn)
    {
        $this->prBusinessTrfYn = $prBusinessTrfYn;

        return $this;
    }

    /**
     * Get prBusinessTrfYn
     *
     * @return boolean
     */
    public function getPrBusinessTrfYn()
    {
        return $this->prBusinessTrfYn;
    }
}
