<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrEvent
 *
 * @ORM\Table(name="pr_event", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rc_action_id", columns={"rc_action_id"}), @ORM\Index(name="rc_event_id", columns={"rc_event_id"}), @ORM\Index(name="pr_event_trf_yn", columns={"pr_event_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrEvent
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prEventIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prEventDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_event_id", type="integer", nullable=false)
     */
    private $prEventId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_action_id", type="string", length=36, nullable=true)
     */
    private $rcActionId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pr_event_date", type="date", nullable=true, options={"default"="0000-00-00"})
     */
    private $prEventDate;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_time", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $prEventTime;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pr_event_completed_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $prEventCompletedDate;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_completed_date_tz", type="string", length=40, nullable=false)
     */
    private $prEventCompletedDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_id", type="string", length=36, nullable=true)
     */
    private $rcEventId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_note", type="text", length=65535, nullable=true)
     */
    private $prEventNote;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_duration", type="string", length=10, nullable=true)
     */
    private $prEventDuration;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_event_completed_yn", type="boolean", nullable=true)
     */
    private $prEventCompletedYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_event_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $prEventInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_event_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prEventTrfYn;



    /**
     * Get prEventIx
     *
     * @return string
     */
    public function getPrEventIx()
    {
        return $this->prEventIx;
    }

    /**
     * Set prEventDb
     *
     * @param string $prEventDb
     *
     * @return PrEvent
     */
    public function setPrEventDb($prEventDb)
    {
        $this->prEventDb = $prEventDb;

        return $this;
    }

    /**
     * Get prEventDb
     *
     * @return string
     */
    public function getPrEventDb()
    {
        return $this->prEventDb;
    }

    /**
     * Set prEventId
     *
     * @param integer $prEventId
     *
     * @return PrEvent
     */
    public function setPrEventId($prEventId)
    {
        $this->prEventId = $prEventId;

        return $this;
    }

    /**
     * Get prEventId
     *
     * @return integer
     */
    public function getPrEventId()
    {
        return $this->prEventId;
    }

    /**
     * Set rcActionId
     *
     * @param string $rcActionId
     *
     * @return PrEvent
     */
    public function setRcActionId($rcActionId)
    {
        $this->rcActionId = $rcActionId;

        return $this;
    }

    /**
     * Get rcActionId
     *
     * @return string
     */
    public function getRcActionId()
    {
        return $this->rcActionId;
    }

    /**
     * Set prEventDate
     *
     * @param \DateTime $prEventDate
     *
     * @return PrEvent
     */
    public function setPrEventDate($prEventDate)
    {
        $this->prEventDate = $prEventDate;

        return $this;
    }

    /**
     * Get prEventDate
     *
     * @return \DateTime
     */
    public function getPrEventDate()
    {
        return $this->prEventDate;
    }

    /**
     * Set prEventTime
     *
     * @param string $prEventTime
     *
     * @return PrEvent
     */
    public function setPrEventTime($prEventTime)
    {
        $this->prEventTime = $prEventTime;

        return $this;
    }

    /**
     * Get prEventTime
     *
     * @return string
     */
    public function getPrEventTime()
    {
        return $this->prEventTime;
    }

    /**
     * Set prEventCompletedDate
     *
     * @param \DateTime $prEventCompletedDate
     *
     * @return PrEvent
     */
    public function setPrEventCompletedDate($prEventCompletedDate)
    {
        $this->prEventCompletedDate = $prEventCompletedDate;

        return $this;
    }

    /**
     * Get prEventCompletedDate
     *
     * @return \DateTime
     */
    public function getPrEventCompletedDate()
    {
        return $this->prEventCompletedDate;
    }

    /**
     * Set prEventCompletedDateTz
     *
     * @param string $prEventCompletedDateTz
     *
     * @return PrEvent
     */
    public function setPrEventCompletedDateTz($prEventCompletedDateTz)
    {
        $this->prEventCompletedDateTz = $prEventCompletedDateTz;

        return $this;
    }

    /**
     * Get prEventCompletedDateTz
     *
     * @return string
     */
    public function getPrEventCompletedDateTz()
    {
        return $this->prEventCompletedDateTz;
    }

    /**
     * Set rcEventId
     *
     * @param string $rcEventId
     *
     * @return PrEvent
     */
    public function setRcEventId($rcEventId)
    {
        $this->rcEventId = $rcEventId;

        return $this;
    }

    /**
     * Get rcEventId
     *
     * @return string
     */
    public function getRcEventId()
    {
        return $this->rcEventId;
    }

    /**
     * Set prEventNote
     *
     * @param string $prEventNote
     *
     * @return PrEvent
     */
    public function setPrEventNote($prEventNote)
    {
        $this->prEventNote = $prEventNote;

        return $this;
    }

    /**
     * Get prEventNote
     *
     * @return string
     */
    public function getPrEventNote()
    {
        return $this->prEventNote;
    }

    /**
     * Set prEventDuration
     *
     * @param string $prEventDuration
     *
     * @return PrEvent
     */
    public function setPrEventDuration($prEventDuration)
    {
        $this->prEventDuration = $prEventDuration;

        return $this;
    }

    /**
     * Get prEventDuration
     *
     * @return string
     */
    public function getPrEventDuration()
    {
        return $this->prEventDuration;
    }

    /**
     * Set prEventCompletedYn
     *
     * @param boolean $prEventCompletedYn
     *
     * @return PrEvent
     */
    public function setPrEventCompletedYn($prEventCompletedYn)
    {
        $this->prEventCompletedYn = $prEventCompletedYn;

        return $this;
    }

    /**
     * Get prEventCompletedYn
     *
     * @return boolean
     */
    public function getPrEventCompletedYn()
    {
        return $this->prEventCompletedYn;
    }

    /**
     * Set prEventInactiveYn
     *
     * @param boolean $prEventInactiveYn
     *
     * @return PrEvent
     */
    public function setPrEventInactiveYn($prEventInactiveYn)
    {
        $this->prEventInactiveYn = $prEventInactiveYn;

        return $this;
    }

    /**
     * Get prEventInactiveYn
     *
     * @return boolean
     */
    public function getPrEventInactiveYn()
    {
        return $this->prEventInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrEvent
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prEventTrfYn
     *
     * @param boolean $prEventTrfYn
     *
     * @return PrEvent
     */
    public function setPrEventTrfYn($prEventTrfYn)
    {
        $this->prEventTrfYn = $prEventTrfYn;

        return $this;
    }

    /**
     * Get prEventTrfYn
     *
     * @return boolean
     */
    public function getPrEventTrfYn()
    {
        return $this->prEventTrfYn;
    }
}
