<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrEventPersona
 *
 * @ORM\Table(name="pr_event_persona", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_event_persona_trf_yn", columns={"pr_event_persona_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_event_id", columns={"pr_event_id"}), @ORM\Index(name="pr_persona_id", columns={"pr_persona_id"})})
 * @ORM\Entity
 */
class PrEventPersona
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_persona_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prEventPersonaIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_persona_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prEventPersonaDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_event_persona_id", type="integer", nullable=false)
     */
    private $prEventPersonaId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_event_rep_ind", type="boolean", nullable=true)
     */
    private $prEventRepInd;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_event_id", type="string", length=36, nullable=true)
     */
    private $prEventId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=true)
     */
    private $prPersonaId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_event_inactive_yn", type="boolean", nullable=true)
     */
    private $prEventInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_event_persona_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prEventPersonaTrfYn;



    /**
     * Get prEventPersonaIx
     *
     * @return string
     */
    public function getPrEventPersonaIx()
    {
        return $this->prEventPersonaIx;
    }

    /**
     * Set prEventPersonaDb
     *
     * @param string $prEventPersonaDb
     *
     * @return PrEventPersona
     */
    public function setPrEventPersonaDb($prEventPersonaDb)
    {
        $this->prEventPersonaDb = $prEventPersonaDb;

        return $this;
    }

    /**
     * Get prEventPersonaDb
     *
     * @return string
     */
    public function getPrEventPersonaDb()
    {
        return $this->prEventPersonaDb;
    }

    /**
     * Set prEventPersonaId
     *
     * @param integer $prEventPersonaId
     *
     * @return PrEventPersona
     */
    public function setPrEventPersonaId($prEventPersonaId)
    {
        $this->prEventPersonaId = $prEventPersonaId;

        return $this;
    }

    /**
     * Get prEventPersonaId
     *
     * @return integer
     */
    public function getPrEventPersonaId()
    {
        return $this->prEventPersonaId;
    }

    /**
     * Set prEventRepInd
     *
     * @param boolean $prEventRepInd
     *
     * @return PrEventPersona
     */
    public function setPrEventRepInd($prEventRepInd)
    {
        $this->prEventRepInd = $prEventRepInd;

        return $this;
    }

    /**
     * Get prEventRepInd
     *
     * @return boolean
     */
    public function getPrEventRepInd()
    {
        return $this->prEventRepInd;
    }

    /**
     * Set prEventId
     *
     * @param string $prEventId
     *
     * @return PrEventPersona
     */
    public function setPrEventId($prEventId)
    {
        $this->prEventId = $prEventId;

        return $this;
    }

    /**
     * Get prEventId
     *
     * @return string
     */
    public function getPrEventId()
    {
        return $this->prEventId;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return PrEventPersona
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set prEventInactiveYn
     *
     * @param boolean $prEventInactiveYn
     *
     * @return PrEventPersona
     */
    public function setPrEventInactiveYn($prEventInactiveYn)
    {
        $this->prEventInactiveYn = $prEventInactiveYn;

        return $this;
    }

    /**
     * Get prEventInactiveYn
     *
     * @return boolean
     */
    public function getPrEventInactiveYn()
    {
        return $this->prEventInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrEventPersona
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prEventPersonaTrfYn
     *
     * @param boolean $prEventPersonaTrfYn
     *
     * @return PrEventPersona
     */
    public function setPrEventPersonaTrfYn($prEventPersonaTrfYn)
    {
        $this->prEventPersonaTrfYn = $prEventPersonaTrfYn;

        return $this;
    }

    /**
     * Get prEventPersonaTrfYn
     *
     * @return boolean
     */
    public function getPrEventPersonaTrfYn()
    {
        return $this->prEventPersonaTrfYn;
    }
}
