<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrGuest
 *
 * @ORM\Table(name="pr_guest", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_guest_trf_yn", columns={"pr_guest_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrGuest
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_id", type="string", length=36, nullable=false, options={"default"=""})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_gender", type="string", length=1, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prGuestGender;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_type_id", type="string", length=36, nullable=true)
     */
    private $rfGuestTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_id", type="string", length=36, nullable=true)
     */
    private $rfCountryId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_note", type="text", length=65535, nullable=false)
     */
    private $prGuestNote;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_memo", type="text", length=65535, nullable=false)
     */
    private $prGuestMemo;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_guest_primary_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prGuestPrimaryYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_guest_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prGuestInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_guest_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prGuestTrfYn;



    /**
     * Get prGuestId
     *
     * @return string
     */
    public function getPrGuestId()
    {
        return $this->prGuestId;
    }

    /**
     * Set prGuestGender
     *
     * @param string $prGuestGender
     *
     * @return PrGuest
     */
    public function setPrGuestGender($prGuestGender)
    {
        $this->prGuestGender = $prGuestGender;

        return $this;
    }

    /**
     * Get prGuestGender
     *
     * @return string
     */
    public function getPrGuestGender()
    {
        return $this->prGuestGender;
    }

    /**
     * Set rfGuestTypeId
     *
     * @param string $rfGuestTypeId
     *
     * @return PrGuest
     */
    public function setRfGuestTypeId($rfGuestTypeId)
    {
        $this->rfGuestTypeId = $rfGuestTypeId;

        return $this;
    }

    /**
     * Get rfGuestTypeId
     *
     * @return string
     */
    public function getRfGuestTypeId()
    {
        return $this->rfGuestTypeId;
    }

    /**
     * Set rfCountryId
     *
     * @param string $rfCountryId
     *
     * @return PrGuest
     */
    public function setRfCountryId($rfCountryId)
    {
        $this->rfCountryId = $rfCountryId;

        return $this;
    }

    /**
     * Get rfCountryId
     *
     * @return string
     */
    public function getRfCountryId()
    {
        return $this->rfCountryId;
    }

    /**
     * Set prGuestNote
     *
     * @param string $prGuestNote
     *
     * @return PrGuest
     */
    public function setPrGuestNote($prGuestNote)
    {
        $this->prGuestNote = $prGuestNote;

        return $this;
    }

    /**
     * Get prGuestNote
     *
     * @return string
     */
    public function getPrGuestNote()
    {
        return $this->prGuestNote;
    }

    /**
     * Set prGuestMemo
     *
     * @param string $prGuestMemo
     *
     * @return PrGuest
     */
    public function setPrGuestMemo($prGuestMemo)
    {
        $this->prGuestMemo = $prGuestMemo;

        return $this;
    }

    /**
     * Get prGuestMemo
     *
     * @return string
     */
    public function getPrGuestMemo()
    {
        return $this->prGuestMemo;
    }

    /**
     * Set prGuestPrimaryYn
     *
     * @param boolean $prGuestPrimaryYn
     *
     * @return PrGuest
     */
    public function setPrGuestPrimaryYn($prGuestPrimaryYn)
    {
        $this->prGuestPrimaryYn = $prGuestPrimaryYn;

        return $this;
    }

    /**
     * Get prGuestPrimaryYn
     *
     * @return boolean
     */
    public function getPrGuestPrimaryYn()
    {
        return $this->prGuestPrimaryYn;
    }

    /**
     * Set prGuestInactiveYn
     *
     * @param boolean $prGuestInactiveYn
     *
     * @return PrGuest
     */
    public function setPrGuestInactiveYn($prGuestInactiveYn)
    {
        $this->prGuestInactiveYn = $prGuestInactiveYn;

        return $this;
    }

    /**
     * Get prGuestInactiveYn
     *
     * @return boolean
     */
    public function getPrGuestInactiveYn()
    {
        return $this->prGuestInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrGuest
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prGuestTrfYn
     *
     * @param boolean $prGuestTrfYn
     *
     * @return PrGuest
     */
    public function setPrGuestTrfYn($prGuestTrfYn)
    {
        $this->prGuestTrfYn = $prGuestTrfYn;

        return $this;
    }

    /**
     * Get prGuestTrfYn
     *
     * @return boolean
     */
    public function getPrGuestTrfYn()
    {
        return $this->prGuestTrfYn;
    }
}
