<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrGuestObjData
 *
 * @ORM\Table(name="pr_guest_obj_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_obj_guest_id", columns={"rf_obj_guest_id"}), @ORM\Index(name="pr_guest_id", columns={"pr_guest_id"}), @ORM\Index(name="rf_obj_guest_data_id", columns={"rf_obj_guest_data_id"}), @ORM\Index(name="pr_guest_obj_data_trf_yn", columns={"pr_guest_obj_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrGuestObjData
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_obj_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prGuestObjDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_obj_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prGuestObjDataDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_guest_obj_data_id", type="integer", nullable=false)
     */
    private $prGuestObjDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_obj_data_text", type="string", length=30, nullable=true)
     */
    private $prGuestObjDataText;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_obj_data_memo", type="text", length=65535, nullable=true)
     */
    private $prGuestObjDataMemo;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_guest_id", type="string", length=36, nullable=true)
     */
    private $prGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_data_id", type="string", length=36, nullable=true)
     */
    private $rfObjGuestDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_id", type="string", length=36, nullable=true)
     */
    private $rfObjGuestId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_guest_obj_data_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $prGuestObjDataInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_guest_obj_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prGuestObjDataTrfYn;



    /**
     * Get prGuestObjDataIx
     *
     * @return string
     */
    public function getPrGuestObjDataIx()
    {
        return $this->prGuestObjDataIx;
    }

    /**
     * Set prGuestObjDataDb
     *
     * @param string $prGuestObjDataDb
     *
     * @return PrGuestObjData
     */
    public function setPrGuestObjDataDb($prGuestObjDataDb)
    {
        $this->prGuestObjDataDb = $prGuestObjDataDb;

        return $this;
    }

    /**
     * Get prGuestObjDataDb
     *
     * @return string
     */
    public function getPrGuestObjDataDb()
    {
        return $this->prGuestObjDataDb;
    }

    /**
     * Set prGuestObjDataId
     *
     * @param integer $prGuestObjDataId
     *
     * @return PrGuestObjData
     */
    public function setPrGuestObjDataId($prGuestObjDataId)
    {
        $this->prGuestObjDataId = $prGuestObjDataId;

        return $this;
    }

    /**
     * Get prGuestObjDataId
     *
     * @return integer
     */
    public function getPrGuestObjDataId()
    {
        return $this->prGuestObjDataId;
    }

    /**
     * Set prGuestObjDataText
     *
     * @param string $prGuestObjDataText
     *
     * @return PrGuestObjData
     */
    public function setPrGuestObjDataText($prGuestObjDataText)
    {
        $this->prGuestObjDataText = $prGuestObjDataText;

        return $this;
    }

    /**
     * Get prGuestObjDataText
     *
     * @return string
     */
    public function getPrGuestObjDataText()
    {
        return $this->prGuestObjDataText;
    }

    /**
     * Set prGuestObjDataMemo
     *
     * @param string $prGuestObjDataMemo
     *
     * @return PrGuestObjData
     */
    public function setPrGuestObjDataMemo($prGuestObjDataMemo)
    {
        $this->prGuestObjDataMemo = $prGuestObjDataMemo;

        return $this;
    }

    /**
     * Get prGuestObjDataMemo
     *
     * @return string
     */
    public function getPrGuestObjDataMemo()
    {
        return $this->prGuestObjDataMemo;
    }

    /**
     * Set prGuestId
     *
     * @param string $prGuestId
     *
     * @return PrGuestObjData
     */
    public function setPrGuestId($prGuestId)
    {
        $this->prGuestId = $prGuestId;

        return $this;
    }

    /**
     * Get prGuestId
     *
     * @return string
     */
    public function getPrGuestId()
    {
        return $this->prGuestId;
    }

    /**
     * Set rfObjGuestDataId
     *
     * @param string $rfObjGuestDataId
     *
     * @return PrGuestObjData
     */
    public function setRfObjGuestDataId($rfObjGuestDataId)
    {
        $this->rfObjGuestDataId = $rfObjGuestDataId;

        return $this;
    }

    /**
     * Get rfObjGuestDataId
     *
     * @return string
     */
    public function getRfObjGuestDataId()
    {
        return $this->rfObjGuestDataId;
    }

    /**
     * Set rfObjGuestId
     *
     * @param string $rfObjGuestId
     *
     * @return PrGuestObjData
     */
    public function setRfObjGuestId($rfObjGuestId)
    {
        $this->rfObjGuestId = $rfObjGuestId;

        return $this;
    }

    /**
     * Get rfObjGuestId
     *
     * @return string
     */
    public function getRfObjGuestId()
    {
        return $this->rfObjGuestId;
    }

    /**
     * Set prGuestObjDataInactiveYn
     *
     * @param boolean $prGuestObjDataInactiveYn
     *
     * @return PrGuestObjData
     */
    public function setPrGuestObjDataInactiveYn($prGuestObjDataInactiveYn)
    {
        $this->prGuestObjDataInactiveYn = $prGuestObjDataInactiveYn;

        return $this;
    }

    /**
     * Get prGuestObjDataInactiveYn
     *
     * @return boolean
     */
    public function getPrGuestObjDataInactiveYn()
    {
        return $this->prGuestObjDataInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrGuestObjData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prGuestObjDataTrfYn
     *
     * @param boolean $prGuestObjDataTrfYn
     *
     * @return PrGuestObjData
     */
    public function setPrGuestObjDataTrfYn($prGuestObjDataTrfYn)
    {
        $this->prGuestObjDataTrfYn = $prGuestObjDataTrfYn;

        return $this;
    }

    /**
     * Get prGuestObjDataTrfYn
     *
     * @return boolean
     */
    public function getPrGuestObjDataTrfYn()
    {
        return $this->prGuestObjDataTrfYn;
    }
}
