<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrLink
 *
 * @ORM\Table(name="pr_link", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_link_trf_yn", columns={"pr_link_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_link_to", columns={"pr_link_to"}), @ORM\Index(name="pr_link_from", columns={"pr_link_from"})})
 * @ORM\Entity
 */
class PrLink
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_link_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prLinkIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_link_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $prLinkDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_link_id", type="integer", nullable=true)
     */
    private $prLinkId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_link_to", type="string", length=36, nullable=true)
     */
    private $prLinkTo;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_link_from", type="string", length=36, nullable=true)
     */
    private $prLinkFrom;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_link_type_id", type="string", length=36, nullable=true)
     */
    private $rfLinkTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_link_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prLinkTrfYn;



    /**
     * Get prLinkIx
     *
     * @return string
     */
    public function getPrLinkIx()
    {
        return $this->prLinkIx;
    }

    /**
     * Set prLinkDb
     *
     * @param string $prLinkDb
     *
     * @return PrLink
     */
    public function setPrLinkDb($prLinkDb)
    {
        $this->prLinkDb = $prLinkDb;

        return $this;
    }

    /**
     * Get prLinkDb
     *
     * @return string
     */
    public function getPrLinkDb()
    {
        return $this->prLinkDb;
    }

    /**
     * Set prLinkId
     *
     * @param integer $prLinkId
     *
     * @return PrLink
     */
    public function setPrLinkId($prLinkId)
    {
        $this->prLinkId = $prLinkId;

        return $this;
    }

    /**
     * Get prLinkId
     *
     * @return integer
     */
    public function getPrLinkId()
    {
        return $this->prLinkId;
    }

    /**
     * Set prLinkTo
     *
     * @param string $prLinkTo
     *
     * @return PrLink
     */
    public function setPrLinkTo($prLinkTo)
    {
        $this->prLinkTo = $prLinkTo;

        return $this;
    }

    /**
     * Get prLinkTo
     *
     * @return string
     */
    public function getPrLinkTo()
    {
        return $this->prLinkTo;
    }

    /**
     * Set prLinkFrom
     *
     * @param string $prLinkFrom
     *
     * @return PrLink
     */
    public function setPrLinkFrom($prLinkFrom)
    {
        $this->prLinkFrom = $prLinkFrom;

        return $this;
    }

    /**
     * Get prLinkFrom
     *
     * @return string
     */
    public function getPrLinkFrom()
    {
        return $this->prLinkFrom;
    }

    /**
     * Set rfLinkTypeId
     *
     * @param string $rfLinkTypeId
     *
     * @return PrLink
     */
    public function setRfLinkTypeId($rfLinkTypeId)
    {
        $this->rfLinkTypeId = $rfLinkTypeId;

        return $this;
    }

    /**
     * Get rfLinkTypeId
     *
     * @return string
     */
    public function getRfLinkTypeId()
    {
        return $this->rfLinkTypeId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrLink
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prLinkTrfYn
     *
     * @param boolean $prLinkTrfYn
     *
     * @return PrLink
     */
    public function setPrLinkTrfYn($prLinkTrfYn)
    {
        $this->prLinkTrfYn = $prLinkTrfYn;

        return $this;
    }

    /**
     * Get prLinkTrfYn
     *
     * @return boolean
     */
    public function getPrLinkTrfYn()
    {
        return $this->prLinkTrfYn;
    }
}
