<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrPersona
 *
 * @ORM\Table(name="pr_persona", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_persona_trf_yn", columns={"pr_persona_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_sys_code", columns={"pr_sys_code"})})
 * @ORM\Entity
 */
class PrPersona
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prPersonaIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $prPersonaDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_persona_id", type="integer", nullable=false)
     */
    private $prPersonaId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_org_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prOrgYn;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pr_anniversary", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $prAnniversary;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pr_birthdate", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $prBirthdate;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_name_first", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $prNameFirst;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_name_second", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $prNameSecond;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_name_last", type="string", length=95, nullable=false, options={"default"=""})
     */
    private $prNameLast;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_name_suffix_id", type="string", length=36, nullable=true)
     */
    private $prNameSuffixId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_title_id", type="string", length=36, nullable=true)
     */
    private $prTitleId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_email", type="string", length=50, nullable=true)
     */
    private $prEmail;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_mail_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prMailInd;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_link_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prPersonaLinkId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_fwd_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prPersonaFwdId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_colour", type="string", length=6, nullable=true)
     */
    private $prColour;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_corr_addr_line1", type="string", length=50, nullable=true)
     */
    private $prCorrAddrLine1;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_corr_addr_line2", type="string", length=50, nullable=true)
     */
    private $prCorrAddrLine2;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_corr_addr_line3", type="string", length=50, nullable=true)
     */
    private $prCorrAddrLine3;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_corr_post_office_id", type="string", length=36, nullable=true)
     */
    private $prCorrPostOfficeId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_corr_country_id", type="string", length=36, nullable=true)
     */
    private $prCorrCountryId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_corr_post_code", type="string", length=50, nullable=true)
     */
    private $prCorrPostCode;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_corr_city", type="string", length=50, nullable=true)
     */
    private $prCorrCity;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phone_sms", type="string", length=50, nullable=true)
     */
    private $prPhoneSms;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phys_addr_line1", type="string", length=50, nullable=true)
     */
    private $prPhysAddrLine1;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phys_addr_line2", type="string", length=50, nullable=true)
     */
    private $prPhysAddrLine2;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phys_addr_line3", type="string", length=50, nullable=true)
     */
    private $prPhysAddrLine3;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phys_post_office_id", type="string", length=36, nullable=true)
     */
    private $prPhysPostOfficeId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phys_country_id", type="string", length=36, nullable=true)
     */
    private $prPhysCountryId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phys_post_code", type="string", length=50, nullable=true)
     */
    private $prPhysPostCode;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phys_city", type="string", length=50, nullable=true)
     */
    private $prPhysCity;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_identity_no", type="string", length=50, nullable=true)
     */
    private $prIdentityNo;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prSysCode;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_statutory_1", type="string", length=20, nullable=true)
     */
    private $prStatutory1;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_statutory_2", type="string", length=50, nullable=true)
     */
    private $prStatutory2;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_statutory_3", type="string", length=50, nullable=true)
     */
    private $prStatutory3;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_web_addr", type="string", length=50, nullable=true)
     */
    private $prWebAddr;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_comms_preference_id", type="string", length=36, nullable=true)
     */
    private $rfCommsPreferenceId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pr_persona_timestamp", type="datetime", columnDefinition="timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")
     */
    private $prPersonaTimestamp;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_persona_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prPersonaInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_persona_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prPersonaTrfYn;



    /**
     * Get prPersonaIx
     *
     * @return string
     */
    public function getPrPersonaIx()
    {
        return $this->prPersonaIx;
    }

    /**
     * Set prPersonaDb
     *
     * @param string $prPersonaDb
     *
     * @return PrPersona
     */
    public function setPrPersonaDb($prPersonaDb)
    {
        $this->prPersonaDb = $prPersonaDb;

        return $this;
    }

    /**
     * Get prPersonaDb
     *
     * @return string
     */
    public function getPrPersonaDb()
    {
        return $this->prPersonaDb;
    }

    /**
     * Set prPersonaId
     *
     * @param integer $prPersonaId
     *
     * @return PrPersona
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return integer
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set prOrgYn
     *
     * @param boolean $prOrgYn
     *
     * @return PrPersona
     */
    public function setPrOrgYn($prOrgYn)
    {
        $this->prOrgYn = $prOrgYn;

        return $this;
    }

    /**
     * Get prOrgYn
     *
     * @return boolean
     */
    public function getPrOrgYn()
    {
        return $this->prOrgYn;
    }

    /**
     * Set prAnniversary
     *
     * @param \DateTime $prAnniversary
     *
     * @return PrPersona
     */
    public function setPrAnniversary($prAnniversary)
    {
        $this->prAnniversary = $prAnniversary;

        return $this;
    }

    /**
     * Get prAnniversary
     *
     * @return \DateTime
     */
    public function getPrAnniversary()
    {
        return $this->prAnniversary;
    }

    /**
     * Set prBirthdate
     *
     * @param \DateTime $prBirthdate
     *
     * @return PrPersona
     */
    public function setPrBirthdate($prBirthdate)
    {
        $this->prBirthdate = $prBirthdate;

        return $this;
    }

    /**
     * Get prBirthdate
     *
     * @return \DateTime
     */
    public function getPrBirthdate()
    {
        return $this->prBirthdate;
    }

    /**
     * Set prNameFirst
     *
     * @param string $prNameFirst
     *
     * @return PrPersona
     */
    public function setPrNameFirst($prNameFirst)
    {
        $this->prNameFirst = $prNameFirst;

        return $this;
    }

    /**
     * Get prNameFirst
     *
     * @return string
     */
    public function getPrNameFirst()
    {
        return $this->prNameFirst;
    }

    /**
     * Set prNameSecond
     *
     * @param string $prNameSecond
     *
     * @return PrPersona
     */
    public function setPrNameSecond($prNameSecond)
    {
        $this->prNameSecond = $prNameSecond;

        return $this;
    }

    /**
     * Get prNameSecond
     *
     * @return string
     */
    public function getPrNameSecond()
    {
        return $this->prNameSecond;
    }

    /**
     * Set prNameLast
     *
     * @param string $prNameLast
     *
     * @return PrPersona
     */
    public function setPrNameLast($prNameLast)
    {
        $this->prNameLast = $prNameLast;

        return $this;
    }

    /**
     * Get prNameLast
     *
     * @return string
     */
    public function getPrNameLast()
    {
        return $this->prNameLast;
    }

    /**
     * Set prNameSuffixId
     *
     * @param string $prNameSuffixId
     *
     * @return PrPersona
     */
    public function setPrNameSuffixId($prNameSuffixId)
    {
        $this->prNameSuffixId = $prNameSuffixId;

        return $this;
    }

    /**
     * Get prNameSuffixId
     *
     * @return string
     */
    public function getPrNameSuffixId()
    {
        return $this->prNameSuffixId;
    }

    /**
     * Set prTitleId
     *
     * @param string $prTitleId
     *
     * @return PrPersona
     */
    public function setPrTitleId($prTitleId)
    {
        $this->prTitleId = $prTitleId;

        return $this;
    }

    /**
     * Get prTitleId
     *
     * @return string
     */
    public function getPrTitleId()
    {
        return $this->prTitleId;
    }

    /**
     * Set prEmail
     *
     * @param string $prEmail
     *
     * @return PrPersona
     */
    public function setPrEmail($prEmail)
    {
        $this->prEmail = $prEmail;

        return $this;
    }

    /**
     * Get prEmail
     *
     * @return string
     */
    public function getPrEmail()
    {
        return $this->prEmail;
    }

    /**
     * Set prMailInd
     *
     * @param boolean $prMailInd
     *
     * @return PrPersona
     */
    public function setPrMailInd($prMailInd)
    {
        $this->prMailInd = $prMailInd;

        return $this;
    }

    /**
     * Get prMailInd
     *
     * @return boolean
     */
    public function getPrMailInd()
    {
        return $this->prMailInd;
    }

    /**
     * Set prPersonaLinkId
     *
     * @param string $prPersonaLinkId
     *
     * @return PrPersona
     */
    public function setPrPersonaLinkId($prPersonaLinkId)
    {
        $this->prPersonaLinkId = $prPersonaLinkId;

        return $this;
    }

    /**
     * Get prPersonaLinkId
     *
     * @return string
     */
    public function getPrPersonaLinkId()
    {
        return $this->prPersonaLinkId;
    }

    /**
     * Set prPersonaFwdId
     *
     * @param string $prPersonaFwdId
     *
     * @return PrPersona
     */
    public function setPrPersonaFwdId($prPersonaFwdId)
    {
        $this->prPersonaFwdId = $prPersonaFwdId;

        return $this;
    }

    /**
     * Get prPersonaFwdId
     *
     * @return string
     */
    public function getPrPersonaFwdId()
    {
        return $this->prPersonaFwdId;
    }

    /**
     * Set prColour
     *
     * @param string $prColour
     *
     * @return PrPersona
     */
    public function setPrColour($prColour)
    {
        $this->prColour = $prColour;

        return $this;
    }

    /**
     * Get prColour
     *
     * @return string
     */
    public function getPrColour()
    {
        return $this->prColour;
    }

    /**
     * Set prCorrAddrLine1
     *
     * @param string $prCorrAddrLine1
     *
     * @return PrPersona
     */
    public function setPrCorrAddrLine1($prCorrAddrLine1)
    {
        $this->prCorrAddrLine1 = $prCorrAddrLine1;

        return $this;
    }

    /**
     * Get prCorrAddrLine1
     *
     * @return string
     */
    public function getPrCorrAddrLine1()
    {
        return $this->prCorrAddrLine1;
    }

    /**
     * Set prCorrAddrLine2
     *
     * @param string $prCorrAddrLine2
     *
     * @return PrPersona
     */
    public function setPrCorrAddrLine2($prCorrAddrLine2)
    {
        $this->prCorrAddrLine2 = $prCorrAddrLine2;

        return $this;
    }

    /**
     * Get prCorrAddrLine2
     *
     * @return string
     */
    public function getPrCorrAddrLine2()
    {
        return $this->prCorrAddrLine2;
    }

    /**
     * Set prCorrAddrLine3
     *
     * @param string $prCorrAddrLine3
     *
     * @return PrPersona
     */
    public function setPrCorrAddrLine3($prCorrAddrLine3)
    {
        $this->prCorrAddrLine3 = $prCorrAddrLine3;

        return $this;
    }

    /**
     * Get prCorrAddrLine3
     *
     * @return string
     */
    public function getPrCorrAddrLine3()
    {
        return $this->prCorrAddrLine3;
    }

    /**
     * Set prCorrPostOfficeId
     *
     * @param string $prCorrPostOfficeId
     *
     * @return PrPersona
     */
    public function setPrCorrPostOfficeId($prCorrPostOfficeId)
    {
        $this->prCorrPostOfficeId = $prCorrPostOfficeId;

        return $this;
    }

    /**
     * Get prCorrPostOfficeId
     *
     * @return string
     */
    public function getPrCorrPostOfficeId()
    {
        return $this->prCorrPostOfficeId;
    }

    /**
     * Set prCorrCountryId
     *
     * @param string $prCorrCountryId
     *
     * @return PrPersona
     */
    public function setPrCorrCountryId($prCorrCountryId)
    {
        $this->prCorrCountryId = $prCorrCountryId;

        return $this;
    }

    /**
     * Get prCorrCountryId
     *
     * @return string
     */
    public function getPrCorrCountryId()
    {
        return $this->prCorrCountryId;
    }

    /**
     * Set prCorrPostCode
     *
     * @param string $prCorrPostCode
     *
     * @return PrPersona
     */
    public function setPrCorrPostCode($prCorrPostCode)
    {
        $this->prCorrPostCode = $prCorrPostCode;

        return $this;
    }

    /**
     * Get prCorrPostCode
     *
     * @return string
     */
    public function getPrCorrPostCode()
    {
        return $this->prCorrPostCode;
    }

    /**
     * Set prCorrCity
     *
     * @param string $prCorrCity
     *
     * @return PrPersona
     */
    public function setPrCorrCity($prCorrCity)
    {
        $this->prCorrCity = $prCorrCity;

        return $this;
    }

    /**
     * Get prCorrCity
     *
     * @return string
     */
    public function getPrCorrCity()
    {
        return $this->prCorrCity;
    }

    /**
     * Set prPhoneSms
     *
     * @param string $prPhoneSms
     *
     * @return PrPersona
     */
    public function setPrPhoneSms($prPhoneSms)
    {
        $this->prPhoneSms = $prPhoneSms;

        return $this;
    }

    /**
     * Get prPhoneSms
     *
     * @return string
     */
    public function getPrPhoneSms()
    {
        return $this->prPhoneSms;
    }

    /**
     * Set prPhysAddrLine1
     *
     * @param string $prPhysAddrLine1
     *
     * @return PrPersona
     */
    public function setPrPhysAddrLine1($prPhysAddrLine1)
    {
        $this->prPhysAddrLine1 = $prPhysAddrLine1;

        return $this;
    }

    /**
     * Get prPhysAddrLine1
     *
     * @return string
     */
    public function getPrPhysAddrLine1()
    {
        return $this->prPhysAddrLine1;
    }

    /**
     * Set prPhysAddrLine2
     *
     * @param string $prPhysAddrLine2
     *
     * @return PrPersona
     */
    public function setPrPhysAddrLine2($prPhysAddrLine2)
    {
        $this->prPhysAddrLine2 = $prPhysAddrLine2;

        return $this;
    }

    /**
     * Get prPhysAddrLine2
     *
     * @return string
     */
    public function getPrPhysAddrLine2()
    {
        return $this->prPhysAddrLine2;
    }

    /**
     * Set prPhysAddrLine3
     *
     * @param string $prPhysAddrLine3
     *
     * @return PrPersona
     */
    public function setPrPhysAddrLine3($prPhysAddrLine3)
    {
        $this->prPhysAddrLine3 = $prPhysAddrLine3;

        return $this;
    }

    /**
     * Get prPhysAddrLine3
     *
     * @return string
     */
    public function getPrPhysAddrLine3()
    {
        return $this->prPhysAddrLine3;
    }

    /**
     * Set prPhysPostOfficeId
     *
     * @param string $prPhysPostOfficeId
     *
     * @return PrPersona
     */
    public function setPrPhysPostOfficeId($prPhysPostOfficeId)
    {
        $this->prPhysPostOfficeId = $prPhysPostOfficeId;

        return $this;
    }

    /**
     * Get prPhysPostOfficeId
     *
     * @return string
     */
    public function getPrPhysPostOfficeId()
    {
        return $this->prPhysPostOfficeId;
    }

    /**
     * Set prPhysCountryId
     *
     * @param string $prPhysCountryId
     *
     * @return PrPersona
     */
    public function setPrPhysCountryId($prPhysCountryId)
    {
        $this->prPhysCountryId = $prPhysCountryId;

        return $this;
    }

    /**
     * Get prPhysCountryId
     *
     * @return string
     */
    public function getPrPhysCountryId()
    {
        return $this->prPhysCountryId;
    }

    /**
     * Set prPhysPostCode
     *
     * @param string $prPhysPostCode
     *
     * @return PrPersona
     */
    public function setPrPhysPostCode($prPhysPostCode)
    {
        $this->prPhysPostCode = $prPhysPostCode;

        return $this;
    }

    /**
     * Get prPhysPostCode
     *
     * @return string
     */
    public function getPrPhysPostCode()
    {
        return $this->prPhysPostCode;
    }

    /**
     * Set prPhysCity
     *
     * @param string $prPhysCity
     *
     * @return PrPersona
     */
    public function setPrPhysCity($prPhysCity)
    {
        $this->prPhysCity = $prPhysCity;

        return $this;
    }

    /**
     * Get prPhysCity
     *
     * @return string
     */
    public function getPrPhysCity()
    {
        return $this->prPhysCity;
    }

    /**
     * Set prIdentityNo
     *
     * @param string $prIdentityNo
     *
     * @return PrPersona
     */
    public function setPrIdentityNo($prIdentityNo)
    {
        $this->prIdentityNo = $prIdentityNo;

        return $this;
    }

    /**
     * Get prIdentityNo
     *
     * @return string
     */
    public function getPrIdentityNo()
    {
        return $this->prIdentityNo;
    }

    /**
     * Set prSysCode
     *
     * @param boolean $prSysCode
     *
     * @return PrPersona
     */
    public function setPrSysCode($prSysCode)
    {
        $this->prSysCode = $prSysCode;

        return $this;
    }

    /**
     * Get prSysCode
     *
     * @return boolean
     */
    public function getPrSysCode()
    {
        return $this->prSysCode;
    }

    /**
     * Set prStatutory1
     *
     * @param string $prStatutory1
     *
     * @return PrPersona
     */
    public function setPrStatutory1($prStatutory1)
    {
        $this->prStatutory1 = $prStatutory1;

        return $this;
    }

    /**
     * Get prStatutory1
     *
     * @return string
     */
    public function getPrStatutory1()
    {
        return $this->prStatutory1;
    }

    /**
     * Set prStatutory2
     *
     * @param string $prStatutory2
     *
     * @return PrPersona
     */
    public function setPrStatutory2($prStatutory2)
    {
        $this->prStatutory2 = $prStatutory2;

        return $this;
    }

    /**
     * Get prStatutory2
     *
     * @return string
     */
    public function getPrStatutory2()
    {
        return $this->prStatutory2;
    }

    /**
     * Set prStatutory3
     *
     * @param string $prStatutory3
     *
     * @return PrPersona
     */
    public function setPrStatutory3($prStatutory3)
    {
        $this->prStatutory3 = $prStatutory3;

        return $this;
    }

    /**
     * Get prStatutory3
     *
     * @return string
     */
    public function getPrStatutory3()
    {
        return $this->prStatutory3;
    }

    /**
     * Set prWebAddr
     *
     * @param string $prWebAddr
     *
     * @return PrPersona
     */
    public function setPrWebAddr($prWebAddr)
    {
        $this->prWebAddr = $prWebAddr;

        return $this;
    }

    /**
     * Get prWebAddr
     *
     * @return string
     */
    public function getPrWebAddr()
    {
        return $this->prWebAddr;
    }

    /**
     * Set rfCommsPreferenceId
     *
     * @param string $rfCommsPreferenceId
     *
     * @return PrPersona
     */
    public function setRfCommsPreferenceId($rfCommsPreferenceId)
    {
        $this->rfCommsPreferenceId = $rfCommsPreferenceId;

        return $this;
    }

    /**
     * Get rfCommsPreferenceId
     *
     * @return string
     */
    public function getRfCommsPreferenceId()
    {
        return $this->rfCommsPreferenceId;
    }

    /**
     * Set prPersonaTimestamp
     *
     * @param \DateTime $prPersonaTimestamp
     *
     * @return PrPersona
     */
    public function setPrPersonaTimestamp($prPersonaTimestamp)
    {
        $this->prPersonaTimestamp = $prPersonaTimestamp;

        return $this;
    }

    /**
     * Get prPersonaTimestamp
     *
     * @return \DateTime
     */
    public function getPrPersonaTimestamp()
    {
        return $this->prPersonaTimestamp;
    }

    /**
     * Set prPersonaInactiveYn
     *
     * @param boolean $prPersonaInactiveYn
     *
     * @return PrPersona
     */
    public function setPrPersonaInactiveYn($prPersonaInactiveYn)
    {
        $this->prPersonaInactiveYn = $prPersonaInactiveYn;

        return $this;
    }

    /**
     * Get prPersonaInactiveYn
     *
     * @return boolean
     */
    public function getPrPersonaInactiveYn()
    {
        return $this->prPersonaInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrPersona
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prPersonaTrfYn
     *
     * @param boolean $prPersonaTrfYn
     *
     * @return PrPersona
     */
    public function setPrPersonaTrfYn($prPersonaTrfYn)
    {
        $this->prPersonaTrfYn = $prPersonaTrfYn;

        return $this;
    }

    /**
     * Get prPersonaTrfYn
     *
     * @return boolean
     */
    public function getPrPersonaTrfYn()
    {
        return $this->prPersonaTrfYn;
    }
}
