<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrPersonaInv
 *
 * @ORM\Table(name="pr_persona_inv", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_business_id", columns={"pr_business_id"}), @ORM\Index(name="pr_persona_id", columns={"pr_persona_id"}), @ORM\Index(name="fn_debtor_id", columns={"fn_debtor_id"}), @ORM\Index(name="pr_persona_inv_trf_yn", columns={"pr_persona_inv_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrPersonaInv
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_inv_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prPersonaInvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_inv_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prPersonaInvDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_persona_inv_id", type="integer", nullable=false)
     */
    private $prPersonaInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_debtor_id", type="string", length=36, nullable=true)
     */
    private $fnDebtorId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=true)
     */
    private $prPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_persona_inv_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prPersonaInvTrfYn;



    /**
     * Get prPersonaInvIx
     *
     * @return string
     */
    public function getPrPersonaInvIx()
    {
        return $this->prPersonaInvIx;
    }

    /**
     * Set prPersonaInvDb
     *
     * @param string $prPersonaInvDb
     *
     * @return PrPersonaInv
     */
    public function setPrPersonaInvDb($prPersonaInvDb)
    {
        $this->prPersonaInvDb = $prPersonaInvDb;

        return $this;
    }

    /**
     * Get prPersonaInvDb
     *
     * @return string
     */
    public function getPrPersonaInvDb()
    {
        return $this->prPersonaInvDb;
    }

    /**
     * Set prPersonaInvId
     *
     * @param integer $prPersonaInvId
     *
     * @return PrPersonaInv
     */
    public function setPrPersonaInvId($prPersonaInvId)
    {
        $this->prPersonaInvId = $prPersonaInvId;

        return $this;
    }

    /**
     * Get prPersonaInvId
     *
     * @return integer
     */
    public function getPrPersonaInvId()
    {
        return $this->prPersonaInvId;
    }

    /**
     * Set fnDebtorId
     *
     * @param string $fnDebtorId
     *
     * @return PrPersonaInv
     */
    public function setFnDebtorId($fnDebtorId)
    {
        $this->fnDebtorId = $fnDebtorId;

        return $this;
    }

    /**
     * Get fnDebtorId
     *
     * @return string
     */
    public function getFnDebtorId()
    {
        return $this->fnDebtorId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return PrPersonaInv
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return PrPersonaInv
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrPersonaInv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prPersonaInvTrfYn
     *
     * @param boolean $prPersonaInvTrfYn
     *
     * @return PrPersonaInv
     */
    public function setPrPersonaInvTrfYn($prPersonaInvTrfYn)
    {
        $this->prPersonaInvTrfYn = $prPersonaInvTrfYn;

        return $this;
    }

    /**
     * Get prPersonaInvTrfYn
     *
     * @return boolean
     */
    public function getPrPersonaInvTrfYn()
    {
        return $this->prPersonaInvTrfYn;
    }
}
