<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrPhone
 *
 * @ORM\Table(name="pr_phone", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_phone_trf_yn", columns={"pr_phone_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_persona_id", columns={"pr_persona_id"})})
 * @ORM\Entity
 */
class PrPhone
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_phone_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prPhoneIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phone_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $prPhoneDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_phone_id", type="integer", nullable=false)
     */
    private $prPhoneId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_default_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prDefaultYn;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phone_detail", type="string", length=50, nullable=true)
     */
    private $prPhoneDetail;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_phone_number", type="string", length=50, nullable=true)
     */
    private $prPhoneNumber;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_type_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfPhoneTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $prPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_phone_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prPhoneTrfYn;



    /**
     * Get prPhoneIx
     *
     * @return string
     */
    public function getPrPhoneIx()
    {
        return $this->prPhoneIx;
    }

    /**
     * Set prPhoneDb
     *
     * @param string $prPhoneDb
     *
     * @return PrPhone
     */
    public function setPrPhoneDb($prPhoneDb)
    {
        $this->prPhoneDb = $prPhoneDb;

        return $this;
    }

    /**
     * Get prPhoneDb
     *
     * @return string
     */
    public function getPrPhoneDb()
    {
        return $this->prPhoneDb;
    }

    /**
     * Set prPhoneId
     *
     * @param integer $prPhoneId
     *
     * @return PrPhone
     */
    public function setPrPhoneId($prPhoneId)
    {
        $this->prPhoneId = $prPhoneId;

        return $this;
    }

    /**
     * Get prPhoneId
     *
     * @return integer
     */
    public function getPrPhoneId()
    {
        return $this->prPhoneId;
    }

    /**
     * Set prDefaultYn
     *
     * @param boolean $prDefaultYn
     *
     * @return PrPhone
     */
    public function setPrDefaultYn($prDefaultYn)
    {
        $this->prDefaultYn = $prDefaultYn;

        return $this;
    }

    /**
     * Get prDefaultYn
     *
     * @return boolean
     */
    public function getPrDefaultYn()
    {
        return $this->prDefaultYn;
    }

    /**
     * Set prPhoneDetail
     *
     * @param string $prPhoneDetail
     *
     * @return PrPhone
     */
    public function setPrPhoneDetail($prPhoneDetail)
    {
        $this->prPhoneDetail = $prPhoneDetail;

        return $this;
    }

    /**
     * Get prPhoneDetail
     *
     * @return string
     */
    public function getPrPhoneDetail()
    {
        return $this->prPhoneDetail;
    }

    /**
     * Set prPhoneNumber
     *
     * @param string $prPhoneNumber
     *
     * @return PrPhone
     */
    public function setPrPhoneNumber($prPhoneNumber)
    {
        $this->prPhoneNumber = $prPhoneNumber;

        return $this;
    }

    /**
     * Get prPhoneNumber
     *
     * @return string
     */
    public function getPrPhoneNumber()
    {
        return $this->prPhoneNumber;
    }

    /**
     * Set rfPhoneTypeId
     *
     * @param string $rfPhoneTypeId
     *
     * @return PrPhone
     */
    public function setRfPhoneTypeId($rfPhoneTypeId)
    {
        $this->rfPhoneTypeId = $rfPhoneTypeId;

        return $this;
    }

    /**
     * Get rfPhoneTypeId
     *
     * @return string
     */
    public function getRfPhoneTypeId()
    {
        return $this->rfPhoneTypeId;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return PrPhone
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrPhone
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prPhoneTrfYn
     *
     * @param boolean $prPhoneTrfYn
     *
     * @return PrPhone
     */
    public function setPrPhoneTrfYn($prPhoneTrfYn)
    {
        $this->prPhoneTrfYn = $prPhoneTrfYn;

        return $this;
    }

    /**
     * Get prPhoneTrfYn
     *
     * @return boolean
     */
    public function getPrPhoneTrfYn()
    {
        return $this->prPhoneTrfYn;
    }
}
