<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrSalesObjData
 *
 * @ORM\Table(name="pr_sales_obj_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_sales_obj_data_trf_yn", columns={"pr_sales_obj_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="pr_persona_id", columns={"pr_persona_id"}), @ORM\Index(name="rc_obj_sales_data_id", columns={"rc_obj_sales_data_id"}), @ORM\Index(name="rc_obj_sales_id", columns={"rc_obj_sales_id"})})
 * @ORM\Entity
 */
class PrSalesObjData
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_sales_obj_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prSalesObjDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_sales_obj_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prSalesObjDataDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_sales_obj_data_id", type="integer", nullable=false)
     */
    private $prSalesObjDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_sales_obj_data_text", type="string", length=30, nullable=true)
     */
    private $prSalesObjDataText;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_sales_obj_data_memo", type="text", length=16777215, nullable=true)
     */
    private $prSalesObjDataMemo;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=true)
     */
    private $prPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_data_id", type="string", length=36, nullable=true)
     */
    private $rcObjSalesDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_id", type="string", length=36, nullable=true)
     */
    private $rcObjSalesId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_sales_obj_data_inactive_yn", type="boolean", nullable=true)
     */
    private $prSalesObjDataInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_sales_obj_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prSalesObjDataTrfYn;



    /**
     * Get prSalesObjDataIx
     *
     * @return string
     */
    public function getPrSalesObjDataIx()
    {
        return $this->prSalesObjDataIx;
    }

    /**
     * Set prSalesObjDataDb
     *
     * @param string $prSalesObjDataDb
     *
     * @return PrSalesObjData
     */
    public function setPrSalesObjDataDb($prSalesObjDataDb)
    {
        $this->prSalesObjDataDb = $prSalesObjDataDb;

        return $this;
    }

    /**
     * Get prSalesObjDataDb
     *
     * @return string
     */
    public function getPrSalesObjDataDb()
    {
        return $this->prSalesObjDataDb;
    }

    /**
     * Set prSalesObjDataId
     *
     * @param integer $prSalesObjDataId
     *
     * @return PrSalesObjData
     */
    public function setPrSalesObjDataId($prSalesObjDataId)
    {
        $this->prSalesObjDataId = $prSalesObjDataId;

        return $this;
    }

    /**
     * Get prSalesObjDataId
     *
     * @return integer
     */
    public function getPrSalesObjDataId()
    {
        return $this->prSalesObjDataId;
    }

    /**
     * Set prSalesObjDataText
     *
     * @param string $prSalesObjDataText
     *
     * @return PrSalesObjData
     */
    public function setPrSalesObjDataText($prSalesObjDataText)
    {
        $this->prSalesObjDataText = $prSalesObjDataText;

        return $this;
    }

    /**
     * Get prSalesObjDataText
     *
     * @return string
     */
    public function getPrSalesObjDataText()
    {
        return $this->prSalesObjDataText;
    }

    /**
     * Set prSalesObjDataMemo
     *
     * @param string $prSalesObjDataMemo
     *
     * @return PrSalesObjData
     */
    public function setPrSalesObjDataMemo($prSalesObjDataMemo)
    {
        $this->prSalesObjDataMemo = $prSalesObjDataMemo;

        return $this;
    }

    /**
     * Get prSalesObjDataMemo
     *
     * @return string
     */
    public function getPrSalesObjDataMemo()
    {
        return $this->prSalesObjDataMemo;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return PrSalesObjData
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set rcObjSalesDataId
     *
     * @param string $rcObjSalesDataId
     *
     * @return PrSalesObjData
     */
    public function setRcObjSalesDataId($rcObjSalesDataId)
    {
        $this->rcObjSalesDataId = $rcObjSalesDataId;

        return $this;
    }

    /**
     * Get rcObjSalesDataId
     *
     * @return string
     */
    public function getRcObjSalesDataId()
    {
        return $this->rcObjSalesDataId;
    }

    /**
     * Set rcObjSalesId
     *
     * @param string $rcObjSalesId
     *
     * @return PrSalesObjData
     */
    public function setRcObjSalesId($rcObjSalesId)
    {
        $this->rcObjSalesId = $rcObjSalesId;

        return $this;
    }

    /**
     * Get rcObjSalesId
     *
     * @return string
     */
    public function getRcObjSalesId()
    {
        return $this->rcObjSalesId;
    }

    /**
     * Set prSalesObjDataInactiveYn
     *
     * @param boolean $prSalesObjDataInactiveYn
     *
     * @return PrSalesObjData
     */
    public function setPrSalesObjDataInactiveYn($prSalesObjDataInactiveYn)
    {
        $this->prSalesObjDataInactiveYn = $prSalesObjDataInactiveYn;

        return $this;
    }

    /**
     * Get prSalesObjDataInactiveYn
     *
     * @return boolean
     */
    public function getPrSalesObjDataInactiveYn()
    {
        return $this->prSalesObjDataInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrSalesObjData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prSalesObjDataTrfYn
     *
     * @param boolean $prSalesObjDataTrfYn
     *
     * @return PrSalesObjData
     */
    public function setPrSalesObjDataTrfYn($prSalesObjDataTrfYn)
    {
        $this->prSalesObjDataTrfYn = $prSalesObjDataTrfYn;

        return $this;
    }

    /**
     * Get prSalesObjDataTrfYn
     *
     * @return boolean
     */
    public function getPrSalesObjDataTrfYn()
    {
        return $this->prSalesObjDataTrfYn;
    }
}
