<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrSocial
 *
 * @ORM\Table(name="pr_social", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_social_trf_yn", columns={"pr_social_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="pr_social_ix", columns={"pr_social_ix"})})
 * @ORM\Entity
 */
class PrSocial
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_social_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prSocialIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_social_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prSocialDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_social_id", type="integer", nullable=false)
     */
    private $prSocialId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_social_name", type="string", length=50, nullable=true)
     */
    private $prSocialName;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_social_label", type="string", length=50, nullable=true)
     */
    private $prSocialLabel;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_social_sort_seq", type="boolean", nullable=true, options={"default"="0"})
     */
    private $prSocialSortSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_social_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prSocialTrfYn;



    /**
     * Get prSocialIx
     *
     * @return string
     */
    public function getPrSocialIx()
    {
        return $this->prSocialIx;
    }

    /**
     * Set prSocialDb
     *
     * @param string $prSocialDb
     *
     * @return PrSocial
     */
    public function setPrSocialDb($prSocialDb)
    {
        $this->prSocialDb = $prSocialDb;

        return $this;
    }

    /**
     * Get prSocialDb
     *
     * @return string
     */
    public function getPrSocialDb()
    {
        return $this->prSocialDb;
    }

    /**
     * Set prSocialId
     *
     * @param integer $prSocialId
     *
     * @return PrSocial
     */
    public function setPrSocialId($prSocialId)
    {
        $this->prSocialId = $prSocialId;

        return $this;
    }

    /**
     * Get prSocialId
     *
     * @return integer
     */
    public function getPrSocialId()
    {
        return $this->prSocialId;
    }

    /**
     * Set prSocialName
     *
     * @param string $prSocialName
     *
     * @return PrSocial
     */
    public function setPrSocialName($prSocialName)
    {
        $this->prSocialName = $prSocialName;

        return $this;
    }

    /**
     * Get prSocialName
     *
     * @return string
     */
    public function getPrSocialName()
    {
        return $this->prSocialName;
    }

    /**
     * Set prSocialLabel
     *
     * @param string $prSocialLabel
     *
     * @return PrSocial
     */
    public function setPrSocialLabel($prSocialLabel)
    {
        $this->prSocialLabel = $prSocialLabel;

        return $this;
    }

    /**
     * Get prSocialLabel
     *
     * @return string
     */
    public function getPrSocialLabel()
    {
        return $this->prSocialLabel;
    }

    /**
     * Set prSocialSortSeq
     *
     * @param boolean $prSocialSortSeq
     *
     * @return PrSocial
     */
    public function setPrSocialSortSeq($prSocialSortSeq)
    {
        $this->prSocialSortSeq = $prSocialSortSeq;

        return $this;
    }

    /**
     * Get prSocialSortSeq
     *
     * @return boolean
     */
    public function getPrSocialSortSeq()
    {
        return $this->prSocialSortSeq;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrSocial
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prSocialTrfYn
     *
     * @param boolean $prSocialTrfYn
     *
     * @return PrSocial
     */
    public function setPrSocialTrfYn($prSocialTrfYn)
    {
        $this->prSocialTrfYn = $prSocialTrfYn;

        return $this;
    }

    /**
     * Get prSocialTrfYn
     *
     * @return boolean
     */
    public function getPrSocialTrfYn()
    {
        return $this->prSocialTrfYn;
    }
}
