<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrSupplier
 *
 * @ORM\Table(name="pr_supplier", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_supplier_trf_yn", columns={"pr_supplier_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrSupplier
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_supplier_id", type="string", length=36, nullable=false, options={"default"=""})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prSupplierId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="pr_supp_date_chg", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $prSuppDateChg;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_supp_date_chg_tz", type="string", length=40, nullable=false)
     */
    private $prSuppDateChgTz;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_supplier_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prSupplierTrfYn;



    /**
     * Get prSupplierId
     *
     * @return string
     */
    public function getPrSupplierId()
    {
        return $this->prSupplierId;
    }

    /**
     * Set prSuppDateChg
     *
     * @param \DateTime $prSuppDateChg
     *
     * @return PrSupplier
     */
    public function setPrSuppDateChg($prSuppDateChg)
    {
        $this->prSuppDateChg = $prSuppDateChg;

        return $this;
    }

    /**
     * Get prSuppDateChg
     *
     * @return \DateTime
     */
    public function getPrSuppDateChg()
    {
        return $this->prSuppDateChg;
    }

    /**
     * Set prSuppDateChgTz
     *
     * @param string $prSuppDateChgTz
     *
     * @return PrSupplier
     */
    public function setPrSuppDateChgTz($prSuppDateChgTz)
    {
        $this->prSuppDateChgTz = $prSuppDateChgTz;

        return $this;
    }

    /**
     * Get prSuppDateChgTz
     *
     * @return string
     */
    public function getPrSuppDateChgTz()
    {
        return $this->prSuppDateChgTz;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrSupplier
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prSupplierTrfYn
     *
     * @param boolean $prSupplierTrfYn
     *
     * @return PrSupplier
     */
    public function setPrSupplierTrfYn($prSupplierTrfYn)
    {
        $this->prSupplierTrfYn = $prSupplierTrfYn;

        return $this;
    }

    /**
     * Get prSupplierTrfYn
     *
     * @return boolean
     */
    public function getPrSupplierTrfYn()
    {
        return $this->prSupplierTrfYn;
    }
}
