<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrUser
 *
 * @ORM\Table(name="pr_user", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_user_trf_yn", columns={"pr_user_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="pr_user_name", columns={"pr_user_name"})})
 * @ORM\Entity
 */
class PrUser
{
	const PASSWORD_TYPE_INSECURE = 0;
	const PASSWORD_TYPE_NORMAL = 1;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_name", type="string", length=25, nullable=true)
     */
    private $prUserName;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_password", type="string", length=255, nullable=true)
     */
    private $prUserPassword;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_user_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prUserInactiveYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_user_notify_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prUserNotifyYn;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="pr_auth_password_type_ind", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $prAuthPasswordTypeInd;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_user_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prUserTrfYn;



    /**
     * Get prUserId
     *
     * @return string
     */
    public function getPrUserId()
    {
        return $this->prUserId;
    }

    /**
     * Set prUserName
     *
     * @param string $prUserName
     *
     * @return PrUser
     */
    public function setPrUserName($prUserName)
    {
        $this->prUserName = $prUserName;

        return $this;
    }

    /**
     * Get prUserName
     *
     * @return string
     */
    public function getPrUserName()
    {
        return $this->prUserName;
    }

    /**
     * Set prUserPassword
     *
     * @param string $prUserPassword
     *
     * @return PrUser
     */
    public function setPrUserPassword($prUserPassword)
    {
        $this->prUserPassword = $prUserPassword;

        return $this;
    }

    /**
     * Get prUserPassword
     *
     * @return string
     */
    public function getPrUserPassword()
    {
        return $this->prUserPassword;
    }

    /**
     * Set prUserInactiveYn
     *
     * @param boolean $prUserInactiveYn
     *
     * @return PrUser
     */
    public function setPrUserInactiveYn($prUserInactiveYn)
    {
        $this->prUserInactiveYn = $prUserInactiveYn;

        return $this;
    }

    /**
     * Get prUserInactiveYn
     *
     * @return boolean
     */
    public function getPrUserInactiveYn()
    {
        return $this->prUserInactiveYn;
    }

    /**
     * Set prUserNotifyYn
     *
     * @param boolean $prUserNotifyYn
     *
     * @return PrUser
     */
    public function setPrUserNotifyYn($prUserNotifyYn)
    {
        $this->prUserNotifyYn = $prUserNotifyYn;

        return $this;
    }

    /**
     * Get prUserNotifyYn
     *
     * @return boolean
     */
    public function getPrUserNotifyYn()
    {
        return $this->prUserNotifyYn;
    }

	/** Set prAuthPasswordTypeInd
	 *
	 * @param boolean $prAuthPasswordTypeInd
	 *
	 * @return PrUser
	 */
	public function setPrAuthPasswordTypeInd($prAuthPasswordTypeInd)
	{
		$this->prAuthPasswordTypeInd = $prAuthPasswordTypeInd;

		return $this;
	}

	/** Get prAuthPasswordTypeInd
	 *
	 * @return boolean
	 */
	public function getPrAuthPasswordTypeInd()
	{
		return $this->prAuthPasswordTypeInd;
	}

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrUser
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prUserTrfYn
     *
     * @param boolean $prUserTrfYn
     *
     * @return PrUser
     */
    public function setPrUserTrfYn($prUserTrfYn)
    {
        $this->prUserTrfYn = $prUserTrfYn;

        return $this;
    }

    /**
     * Get prUserTrfYn
     *
     * @return boolean
     */
    public function getPrUserTrfYn()
    {
        return $this->prUserTrfYn;
    }
}
