<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PrUserPassword
 *
 * @ORM\Table(name="pr_user_password", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_user_id", columns={"pr_user_id"}), @ORM\Index(name="pr_user_password_trf_yn", columns={"pr_user_password_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class PrUserPassword
{
    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_password_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $prUserPasswordIx;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_password_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $prUserPasswordDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="pr_user_password_id", type="integer", nullable=false)
     */
    private $prUserPasswordId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_user_id", type="string", length=36, nullable=true)
     */
    private $prUserId;

	/**
	 * @var string
	 *
	 * @ORM\Column(name="pr_user_password", type="string", length=255, nullable=false, options={"default"=""})
	 */
	private $prUserPassword;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="pr_user_password_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $prUserPasswordTrfYn;



    /**
     * Get prUserPasswordIx
     *
     * @return string
     */
    public function getPrUserPasswordIx()
    {
        return $this->prUserPasswordIx;
    }

    /**
     * Set prUserPasswordDb
     *
     * @param string $prUserPasswordDb
     *
     * @return PrUserPassword
     */
    public function setPrUserPasswordDb($prUserPasswordDb)
    {
        $this->prUserPasswordDb = $prUserPasswordDb;

        return $this;
    }

    /**
     * Get prUserPasswordDb
     *
     * @return string
     */
    public function getPrUserPasswordDb()
    {
        return $this->prUserPasswordDb;
    }

    /**
     * Set prUserPasswordId
     *
     * @param integer $prUserPasswordId
     *
     * @return PrUserPassword
     */
    public function setPrUserPasswordId($prUserPasswordId)
    {
        $this->prUserPasswordId = $prUserPasswordId;

        return $this;
    }

    /**
     * Get prUserPasswordId
     *
     * @return integer
     */
    public function getPrUserPasswordId()
    {
        return $this->prUserPasswordId;
	}

	/**
	 * Set prUserId
	 *
	 * @param string $prUserId
	 *
	 * @return PrUserPassword
	 */
	public function setPrUserId($prUserId)
	{
		$this->prUserId = $prUserId;

		return $this;
	}

	/**
	 * Get prUserId
	 *
	 * @return string
	 */
	public function getPrUserId()
	{
		return $this->prUserId;
	}

	/**
	 * Set prUserPassword
	 *
	 * @param string $prUserPassword
	 *
	 * @return PrUserPassword
	 */
	public function setPrUserPassword($prUserPassword)
	{
		$this->prUserPassword = $prUserPassword;

		return $this;
	}

	/**
	 * Get prUserPassword
	 *
	 * @return string
	 */
	public function getPrUserPassword()
	{
		return $this->prUserPassword;
	}

	/**
	 * Set adCreateDate
	 *
	 * @param \Datetime $adCreateDate
	 *
	 * @return PrUserPassword
	 */
	public function setAdCreateDate($adCreateDate)
	{
		$this->adCreateDate = $adCreateDate;

		return $this;
	}

	/**
	 * Get adCreateDate
	 *
	 * @return \Datetime
	 */
	public function getAdCreateDate()
	{
		return $this->adCreateDate;
	}

	/**
	 * Set adCreateDateTz
	 *
	 * @param string $adCreateDateTz
	 *
	 * @return PrUserPassword
	 */
	public function setAdCreateDateTz($adCreateDateTz)
	{
		$this->adCreateDateTz = $adCreateDateTz;

		return $this;
	}

	/**
	 * Get adCreateDateTz
	 *
	 * @return string
	 */
	public function getAdCreateDateTz()
	{
		return $this->adCreateDateTz;
	}

	/**
	 * Set adCreateUserId
	 *
	 * @param string $adCreateUserId
	 *
	 * @return PrUserPassword
	 */
	public function setAdCreateUserId($adCreateUserId)
	{
		$this->adCreateUserId = $adCreateUserId;

		return $this;
	}

	/**
	 * Get adCreateUserId
	 *
	 * @return string
	 */
	public function getAdCreateUserId()
	{
		return $this->adCreateUserId;
	}

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return PrUser
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set prUserPasswordTrfYn
     *
     * @param boolean $prUserPasswordTrfYn
     *
     * @return PrUserPassword
     */
    public function setPrUserPasswordTrfYn($prUserPasswordTrfYn)
    {
        $this->prUserPasswordTrfYn = $prUserPasswordTrfYn;

        return $this;
    }

    /**
     * Get prUserPasswordTrfYn
     *
     * @return boolean
     */
    public function getPrUserPasswordTrfYn()
    {
        return $this->prUserPasswordTrfYn;
    }
}
