<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RcAction
 *
 * @ORM\Table(name="rc_action", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rc_action_trf_yn", columns={"rc_action_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RcAction
{
    /**
     * @var string
     *
     * @ORM\Column(name="rc_action_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rcActionIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_action_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rcActionDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rc_action_id", type="integer", nullable=false)
     */
    private $rcActionId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_action_colour", type="string", length=6, nullable=true)
     */
    private $rcActionColour;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_action_desc", type="string", length=30, nullable=true)
     */
    private $rcActionDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_action_icon", type="string", length=50, nullable=true)
     */
    private $rcActionIcon;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_action_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rcActionSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_action_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcActionInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_action_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rcActionTrfYn;



    /**
     * Get rcActionIx
     *
     * @return string
     */
    public function getRcActionIx()
    {
        return $this->rcActionIx;
    }

    /**
     * Set rcActionDb
     *
     * @param string $rcActionDb
     *
     * @return RcAction
     */
    public function setRcActionDb($rcActionDb)
    {
        $this->rcActionDb = $rcActionDb;

        return $this;
    }

    /**
     * Get rcActionDb
     *
     * @return string
     */
    public function getRcActionDb()
    {
        return $this->rcActionDb;
    }

    /**
     * Set rcActionId
     *
     * @param integer $rcActionId
     *
     * @return RcAction
     */
    public function setRcActionId($rcActionId)
    {
        $this->rcActionId = $rcActionId;

        return $this;
    }

    /**
     * Get rcActionId
     *
     * @return integer
     */
    public function getRcActionId()
    {
        return $this->rcActionId;
    }

    /**
     * Set rcActionColour
     *
     * @param string $rcActionColour
     *
     * @return RcAction
     */
    public function setRcActionColour($rcActionColour)
    {
        $this->rcActionColour = $rcActionColour;

        return $this;
    }

    /**
     * Get rcActionColour
     *
     * @return string
     */
    public function getRcActionColour()
    {
        return $this->rcActionColour;
    }

    /**
     * Set rcActionDesc
     *
     * @param string $rcActionDesc
     *
     * @return RcAction
     */
    public function setRcActionDesc($rcActionDesc)
    {
        $this->rcActionDesc = $rcActionDesc;

        return $this;
    }

    /**
     * Get rcActionDesc
     *
     * @return string
     */
    public function getRcActionDesc()
    {
        return $this->rcActionDesc;
    }

    /**
     * Set rcActionIcon
     *
     * @param string $rcActionIcon
     *
     * @return RcAction
     */
    public function setRcActionIcon($rcActionIcon)
    {
        $this->rcActionIcon = $rcActionIcon;

        return $this;
    }

    /**
     * Get rcActionIcon
     *
     * @return string
     */
    public function getRcActionIcon()
    {
        return $this->rcActionIcon;
    }

    /**
     * Set rcActionSysCode
     *
     * @param boolean $rcActionSysCode
     *
     * @return RcAction
     */
    public function setRcActionSysCode($rcActionSysCode)
    {
        $this->rcActionSysCode = $rcActionSysCode;

        return $this;
    }

    /**
     * Get rcActionSysCode
     *
     * @return boolean
     */
    public function getRcActionSysCode()
    {
        return $this->rcActionSysCode;
    }

    /**
     * Set rcActionInactiveYn
     *
     * @param boolean $rcActionInactiveYn
     *
     * @return RcAction
     */
    public function setRcActionInactiveYn($rcActionInactiveYn)
    {
        $this->rcActionInactiveYn = $rcActionInactiveYn;

        return $this;
    }

    /**
     * Get rcActionInactiveYn
     *
     * @return boolean
     */
    public function getRcActionInactiveYn()
    {
        return $this->rcActionInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RcAction
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rcActionTrfYn
     *
     * @param boolean $rcActionTrfYn
     *
     * @return RcAction
     */
    public function setRcActionTrfYn($rcActionTrfYn)
    {
        $this->rcActionTrfYn = $rcActionTrfYn;

        return $this;
    }

    /**
     * Get rcActionTrfYn
     *
     * @return boolean
     */
    public function getRcActionTrfYn()
    {
        return $this->rcActionTrfYn;
    }
}
