<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RcEvent
 *
 * @ORM\Table(name="rc_event", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rc_event_trf_yn", columns={"rc_event_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RcEvent
{
    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rcEventIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rcEventDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rc_event_id", type="integer", nullable=false)
     */
    private $rcEventId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_abbrv", type="string", length=6, nullable=true)
     */
    private $rcEventAbbrv;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_desc", type="string", length=30, nullable=true)
     */
    private $rcEventDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_note", type="text", length=65535, nullable=true)
     */
    private $rcEventNote;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_colour", type="text", length=65535, nullable=true)
     */
    private $rcEventColour;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_event_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rcEventSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_event_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcEventInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_event_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rcEventTrfYn;



    /**
     * Get rcEventIx
     *
     * @return string
     */
    public function getRcEventIx()
    {
        return $this->rcEventIx;
    }

    /**
     * Set rcEventDb
     *
     * @param string $rcEventDb
     *
     * @return RcEvent
     */
    public function setRcEventDb($rcEventDb)
    {
        $this->rcEventDb = $rcEventDb;

        return $this;
    }

    /**
     * Get rcEventDb
     *
     * @return string
     */
    public function getRcEventDb()
    {
        return $this->rcEventDb;
    }

    /**
     * Set rcEventId
     *
     * @param integer $rcEventId
     *
     * @return RcEvent
     */
    public function setRcEventId($rcEventId)
    {
        $this->rcEventId = $rcEventId;

        return $this;
    }

    /**
     * Get rcEventId
     *
     * @return integer
     */
    public function getRcEventId()
    {
        return $this->rcEventId;
    }

    /**
     * Set rcEventAbbrv
     *
     * @param string $rcEventAbbrv
     *
     * @return RcEvent
     */
    public function setRcEventAbbrv($rcEventAbbrv)
    {
        $this->rcEventAbbrv = $rcEventAbbrv;

        return $this;
    }

    /**
     * Get rcEventAbbrv
     *
     * @return string
     */
    public function getRcEventAbbrv()
    {
        return $this->rcEventAbbrv;
    }

    /**
     * Set rcEventDesc
     *
     * @param string $rcEventDesc
     *
     * @return RcEvent
     */
    public function setRcEventDesc($rcEventDesc)
    {
        $this->rcEventDesc = $rcEventDesc;

        return $this;
    }

    /**
     * Get rcEventDesc
     *
     * @return string
     */
    public function getRcEventDesc()
    {
        return $this->rcEventDesc;
    }

    /**
     * Set rcEventNote
     *
     * @param string $rcEventNote
     *
     * @return RcEvent
     */
    public function setRcEventNote($rcEventNote)
    {
        $this->rcEventNote = $rcEventNote;

        return $this;
    }

    /**
     * Get rcEventNote
     *
     * @return string
     */
    public function getRcEventNote()
    {
        return $this->rcEventNote;
    }

    /**
     * Set rcEventColour
     *
     * @param string $rcEventColour
     *
     * @return RcEvent
     */
    public function setRcEventColour($rcEventColour)
    {
        $this->rcEventColour = $rcEventColour;

        return $this;
    }

    /**
     * Get rcEventColour
     *
     * @return string
     */
    public function getRcEventColour()
    {
        return $this->rcEventColour;
    }

    /**
     * Set rcEventSysCode
     *
     * @param boolean $rcEventSysCode
     *
     * @return RcEvent
     */
    public function setRcEventSysCode($rcEventSysCode)
    {
        $this->rcEventSysCode = $rcEventSysCode;

        return $this;
    }

    /**
     * Get rcEventSysCode
     *
     * @return boolean
     */
    public function getRcEventSysCode()
    {
        return $this->rcEventSysCode;
    }

    /**
     * Set rcEventInactiveYn
     *
     * @param boolean $rcEventInactiveYn
     *
     * @return RcEvent
     */
    public function setRcEventInactiveYn($rcEventInactiveYn)
    {
        $this->rcEventInactiveYn = $rcEventInactiveYn;

        return $this;
    }

    /**
     * Get rcEventInactiveYn
     *
     * @return boolean
     */
    public function getRcEventInactiveYn()
    {
        return $this->rcEventInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RcEvent
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rcEventTrfYn
     *
     * @param boolean $rcEventTrfYn
     *
     * @return RcEvent
     */
    public function setRcEventTrfYn($rcEventTrfYn)
    {
        $this->rcEventTrfYn = $rcEventTrfYn;

        return $this;
    }

    /**
     * Get rcEventTrfYn
     *
     * @return boolean
     */
    public function getRcEventTrfYn()
    {
        return $this->rcEventTrfYn;
    }
}
