<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RcEventTag
 *
 * @ORM\Table(name="rc_event_tag", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rc_event_tag_trf_yn", columns={"rc_event_tag_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RcEventTag
{
    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_tag_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rcEventTagIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_tag_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rcEventTagDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rc_event_tag_id", type="integer", nullable=false)
     */
    private $rcEventTagId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_event_id", type="string", length=36, nullable=true)
     */
    private $rcEventId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_tag_id", type="string", length=36, nullable=true)
     */
    private $rcTagId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_event_tag_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rcEventTagTrfYn;



    /**
     * Get rcEventTagIx
     *
     * @return string
     */
    public function getRcEventTagIx()
    {
        return $this->rcEventTagIx;
    }

    /**
     * Set rcEventTagDb
     *
     * @param string $rcEventTagDb
     *
     * @return RcEventTag
     */
    public function setRcEventTagDb($rcEventTagDb)
    {
        $this->rcEventTagDb = $rcEventTagDb;

        return $this;
    }

    /**
     * Get rcEventTagDb
     *
     * @return string
     */
    public function getRcEventTagDb()
    {
        return $this->rcEventTagDb;
    }

    /**
     * Set rcEventTagId
     *
     * @param integer $rcEventTagId
     *
     * @return RcEventTag
     */
    public function setRcEventTagId($rcEventTagId)
    {
        $this->rcEventTagId = $rcEventTagId;

        return $this;
    }

    /**
     * Get rcEventTagId
     *
     * @return integer
     */
    public function getRcEventTagId()
    {
        return $this->rcEventTagId;
    }

    /**
     * Set rcEventId
     *
     * @param string $rcEventId
     *
     * @return RcEventTag
     */
    public function setRcEventId($rcEventId)
    {
        $this->rcEventId = $rcEventId;

        return $this;
    }

    /**
     * Get rcEventId
     *
     * @return string
     */
    public function getRcEventId()
    {
        return $this->rcEventId;
    }

    /**
     * Set rcTagId
     *
     * @param string $rcTagId
     *
     * @return RcEventTag
     */
    public function setRcTagId($rcTagId)
    {
        $this->rcTagId = $rcTagId;

        return $this;
    }

    /**
     * Get rcTagId
     *
     * @return string
     */
    public function getRcTagId()
    {
        return $this->rcTagId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RcEventTag
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rcEventTagTrfYn
     *
     * @param boolean $rcEventTagTrfYn
     *
     * @return RcEventTag
     */
    public function setRcEventTagTrfYn($rcEventTagTrfYn)
    {
        $this->rcEventTagTrfYn = $rcEventTagTrfYn;

        return $this;
    }

    /**
     * Get rcEventTagTrfYn
     *
     * @return boolean
     */
    public function getRcEventTagTrfYn()
    {
        return $this->rcEventTagTrfYn;
    }
}
