<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RcObjSales
 *
 * @ORM\Table(name="rc_obj_sales", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rc_obj_sales_trf_yn", columns={"rc_obj_sales_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RcObjSales
{
    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rcObjSalesIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rcObjSalesDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rc_obj_sales_id", type="integer", nullable=false)
     */
    private $rcObjSalesId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_label", type="string", length=30, nullable=true)
     */
    private $rcObjSalesLabel;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_sort_seq", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcObjSalesSortSeq;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_type_ind", type="boolean", nullable=true)
     */
    private $rcObjSalesTypeInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_mandatory_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcObjSalesMandatoryYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_sys_code", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcObjSalesSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcObjSalesInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rcObjSalesTrfYn;



    /**
     * Get rcObjSalesIx
     *
     * @return string
     */
    public function getRcObjSalesIx()
    {
        return $this->rcObjSalesIx;
    }

    /**
     * Set rcObjSalesDb
     *
     * @param string $rcObjSalesDb
     *
     * @return RcObjSales
     */
    public function setRcObjSalesDb($rcObjSalesDb)
    {
        $this->rcObjSalesDb = $rcObjSalesDb;

        return $this;
    }

    /**
     * Get rcObjSalesDb
     *
     * @return string
     */
    public function getRcObjSalesDb()
    {
        return $this->rcObjSalesDb;
    }

    /**
     * Set rcObjSalesId
     *
     * @param integer $rcObjSalesId
     *
     * @return RcObjSales
     */
    public function setRcObjSalesId($rcObjSalesId)
    {
        $this->rcObjSalesId = $rcObjSalesId;

        return $this;
    }

    /**
     * Get rcObjSalesId
     *
     * @return integer
     */
    public function getRcObjSalesId()
    {
        return $this->rcObjSalesId;
    }

    /**
     * Set rcObjSalesLabel
     *
     * @param string $rcObjSalesLabel
     *
     * @return RcObjSales
     */
    public function setRcObjSalesLabel($rcObjSalesLabel)
    {
        $this->rcObjSalesLabel = $rcObjSalesLabel;

        return $this;
    }

    /**
     * Get rcObjSalesLabel
     *
     * @return string
     */
    public function getRcObjSalesLabel()
    {
        return $this->rcObjSalesLabel;
    }

    /**
     * Set rcObjSalesSortSeq
     *
     * @param boolean $rcObjSalesSortSeq
     *
     * @return RcObjSales
     */
    public function setRcObjSalesSortSeq($rcObjSalesSortSeq)
    {
        $this->rcObjSalesSortSeq = $rcObjSalesSortSeq;

        return $this;
    }

    /**
     * Get rcObjSalesSortSeq
     *
     * @return boolean
     */
    public function getRcObjSalesSortSeq()
    {
        return $this->rcObjSalesSortSeq;
    }

    /**
     * Set rcObjSalesTypeInd
     *
     * @param boolean $rcObjSalesTypeInd
     *
     * @return RcObjSales
     */
    public function setRcObjSalesTypeInd($rcObjSalesTypeInd)
    {
        $this->rcObjSalesTypeInd = $rcObjSalesTypeInd;

        return $this;
    }

    /**
     * Get rcObjSalesTypeInd
     *
     * @return boolean
     */
    public function getRcObjSalesTypeInd()
    {
        return $this->rcObjSalesTypeInd;
    }

    /**
     * Set rcObjSalesMandatoryYn
     *
     * @param boolean $rcObjSalesMandatoryYn
     *
     * @return RcObjSales
     */
    public function setRcObjSalesMandatoryYn($rcObjSalesMandatoryYn)
    {
        $this->rcObjSalesMandatoryYn = $rcObjSalesMandatoryYn;

        return $this;
    }

    /**
     * Get rcObjSalesMandatoryYn
     *
     * @return boolean
     */
    public function getRcObjSalesMandatoryYn()
    {
        return $this->rcObjSalesMandatoryYn;
    }

    /**
     * Set rcObjSalesSysCode
     *
     * @param boolean $rcObjSalesSysCode
     *
     * @return RcObjSales
     */
    public function setRcObjSalesSysCode($rcObjSalesSysCode)
    {
        $this->rcObjSalesSysCode = $rcObjSalesSysCode;

        return $this;
    }

    /**
     * Get rcObjSalesSysCode
     *
     * @return boolean
     */
    public function getRcObjSalesSysCode()
    {
        return $this->rcObjSalesSysCode;
    }

    /**
     * Set rcObjSalesInactiveYn
     *
     * @param boolean $rcObjSalesInactiveYn
     *
     * @return RcObjSales
     */
    public function setRcObjSalesInactiveYn($rcObjSalesInactiveYn)
    {
        $this->rcObjSalesInactiveYn = $rcObjSalesInactiveYn;

        return $this;
    }

    /**
     * Get rcObjSalesInactiveYn
     *
     * @return boolean
     */
    public function getRcObjSalesInactiveYn()
    {
        return $this->rcObjSalesInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RcObjSales
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rcObjSalesTrfYn
     *
     * @param boolean $rcObjSalesTrfYn
     *
     * @return RcObjSales
     */
    public function setRcObjSalesTrfYn($rcObjSalesTrfYn)
    {
        $this->rcObjSalesTrfYn = $rcObjSalesTrfYn;

        return $this;
    }

    /**
     * Get rcObjSalesTrfYn
     *
     * @return boolean
     */
    public function getRcObjSalesTrfYn()
    {
        return $this->rcObjSalesTrfYn;
    }
}
