<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RcObjSalesData
 *
 * @ORM\Table(name="rc_obj_sales_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rc_obj_sales_data_trf_yn", columns={"rc_obj_sales_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RcObjSalesData
{
    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rcObjSalesDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rcObjSalesDataDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rc_obj_sales_data_id", type="integer", nullable=false)
     */
    private $rcObjSalesDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_data_content", type="string", length=30, nullable=true)
     */
    private $rcObjSalesDataContent;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_data_sort_seq", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcObjSalesDataSortSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_obj_sales_id", type="string", length=36, nullable=true)
     */
    private $rcObjSalesId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_data_default_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcObjSalesDataDefaultYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_data_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcObjSalesDataInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_obj_sales_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rcObjSalesDataTrfYn;



    /**
     * Get rcObjSalesDataIx
     *
     * @return string
     */
    public function getRcObjSalesDataIx()
    {
        return $this->rcObjSalesDataIx;
    }

    /**
     * Set rcObjSalesDataDb
     *
     * @param string $rcObjSalesDataDb
     *
     * @return RcObjSalesData
     */
    public function setRcObjSalesDataDb($rcObjSalesDataDb)
    {
        $this->rcObjSalesDataDb = $rcObjSalesDataDb;

        return $this;
    }

    /**
     * Get rcObjSalesDataDb
     *
     * @return string
     */
    public function getRcObjSalesDataDb()
    {
        return $this->rcObjSalesDataDb;
    }

    /**
     * Set rcObjSalesDataId
     *
     * @param integer $rcObjSalesDataId
     *
     * @return RcObjSalesData
     */
    public function setRcObjSalesDataId($rcObjSalesDataId)
    {
        $this->rcObjSalesDataId = $rcObjSalesDataId;

        return $this;
    }

    /**
     * Get rcObjSalesDataId
     *
     * @return integer
     */
    public function getRcObjSalesDataId()
    {
        return $this->rcObjSalesDataId;
    }

    /**
     * Set rcObjSalesDataContent
     *
     * @param string $rcObjSalesDataContent
     *
     * @return RcObjSalesData
     */
    public function setRcObjSalesDataContent($rcObjSalesDataContent)
    {
        $this->rcObjSalesDataContent = $rcObjSalesDataContent;

        return $this;
    }

    /**
     * Get rcObjSalesDataContent
     *
     * @return string
     */
    public function getRcObjSalesDataContent()
    {
        return $this->rcObjSalesDataContent;
    }

    /**
     * Set rcObjSalesDataSortSeq
     *
     * @param boolean $rcObjSalesDataSortSeq
     *
     * @return RcObjSalesData
     */
    public function setRcObjSalesDataSortSeq($rcObjSalesDataSortSeq)
    {
        $this->rcObjSalesDataSortSeq = $rcObjSalesDataSortSeq;

        return $this;
    }

    /**
     * Get rcObjSalesDataSortSeq
     *
     * @return boolean
     */
    public function getRcObjSalesDataSortSeq()
    {
        return $this->rcObjSalesDataSortSeq;
    }

    /**
     * Set rcObjSalesId
     *
     * @param string $rcObjSalesId
     *
     * @return RcObjSalesData
     */
    public function setRcObjSalesId($rcObjSalesId)
    {
        $this->rcObjSalesId = $rcObjSalesId;

        return $this;
    }

    /**
     * Get rcObjSalesId
     *
     * @return string
     */
    public function getRcObjSalesId()
    {
        return $this->rcObjSalesId;
    }

    /**
     * Set rcObjSalesDataDefaultYn
     *
     * @param boolean $rcObjSalesDataDefaultYn
     *
     * @return RcObjSalesData
     */
    public function setRcObjSalesDataDefaultYn($rcObjSalesDataDefaultYn)
    {
        $this->rcObjSalesDataDefaultYn = $rcObjSalesDataDefaultYn;

        return $this;
    }

    /**
     * Get rcObjSalesDataDefaultYn
     *
     * @return boolean
     */
    public function getRcObjSalesDataDefaultYn()
    {
        return $this->rcObjSalesDataDefaultYn;
    }

    /**
     * Set rcObjSalesDataInactiveYn
     *
     * @param boolean $rcObjSalesDataInactiveYn
     *
     * @return RcObjSalesData
     */
    public function setRcObjSalesDataInactiveYn($rcObjSalesDataInactiveYn)
    {
        $this->rcObjSalesDataInactiveYn = $rcObjSalesDataInactiveYn;

        return $this;
    }

    /**
     * Get rcObjSalesDataInactiveYn
     *
     * @return boolean
     */
    public function getRcObjSalesDataInactiveYn()
    {
        return $this->rcObjSalesDataInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RcObjSalesData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rcObjSalesDataTrfYn
     *
     * @param boolean $rcObjSalesDataTrfYn
     *
     * @return RcObjSalesData
     */
    public function setRcObjSalesDataTrfYn($rcObjSalesDataTrfYn)
    {
        $this->rcObjSalesDataTrfYn = $rcObjSalesDataTrfYn;

        return $this;
    }

    /**
     * Get rcObjSalesDataTrfYn
     *
     * @return boolean
     */
    public function getRcObjSalesDataTrfYn()
    {
        return $this->rcObjSalesDataTrfYn;
    }
}
