<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RcTag
 *
 * @ORM\Table(name="rc_tag", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rc_tag_trf_yn", columns={"rc_tag_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RcTag
{
    /**
     * @var string
     *
     * @ORM\Column(name="rc_tag_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rcTagIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_tag_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rcTagDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rc_tag_id", type="integer", nullable=false)
     */
    private $rcTagId;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_tag_colour", type="string", length=6, nullable=true)
     */
    private $rcTagColour;

    /**
     * @var string
     *
     * @ORM\Column(name="rc_tag_desc", type="string", length=30, nullable=true)
     */
    private $rcTagDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_tag_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rcTagInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rc_tag_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rcTagTrfYn;



    /**
     * Get rcTagIx
     *
     * @return string
     */
    public function getRcTagIx()
    {
        return $this->rcTagIx;
    }

    /**
     * Set rcTagDb
     *
     * @param string $rcTagDb
     *
     * @return RcTag
     */
    public function setRcTagDb($rcTagDb)
    {
        $this->rcTagDb = $rcTagDb;

        return $this;
    }

    /**
     * Get rcTagDb
     *
     * @return string
     */
    public function getRcTagDb()
    {
        return $this->rcTagDb;
    }

    /**
     * Set rcTagId
     *
     * @param integer $rcTagId
     *
     * @return RcTag
     */
    public function setRcTagId($rcTagId)
    {
        $this->rcTagId = $rcTagId;

        return $this;
    }

    /**
     * Get rcTagId
     *
     * @return integer
     */
    public function getRcTagId()
    {
        return $this->rcTagId;
    }

    /**
     * Set rcTagColour
     *
     * @param string $rcTagColour
     *
     * @return RcTag
     */
    public function setRcTagColour($rcTagColour)
    {
        $this->rcTagColour = $rcTagColour;

        return $this;
    }

    /**
     * Get rcTagColour
     *
     * @return string
     */
    public function getRcTagColour()
    {
        return $this->rcTagColour;
    }

    /**
     * Set rcTagDesc
     *
     * @param string $rcTagDesc
     *
     * @return RcTag
     */
    public function setRcTagDesc($rcTagDesc)
    {
        $this->rcTagDesc = $rcTagDesc;

        return $this;
    }

    /**
     * Get rcTagDesc
     *
     * @return string
     */
    public function getRcTagDesc()
    {
        return $this->rcTagDesc;
    }

    /**
     * Set rcTagInactiveYn
     *
     * @param boolean $rcTagInactiveYn
     *
     * @return RcTag
     */
    public function setRcTagInactiveYn($rcTagInactiveYn)
    {
        $this->rcTagInactiveYn = $rcTagInactiveYn;

        return $this;
    }

    /**
     * Get rcTagInactiveYn
     *
     * @return boolean
     */
    public function getRcTagInactiveYn()
    {
        return $this->rcTagInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RcTag
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rcTagTrfYn
     *
     * @param boolean $rcTagTrfYn
     *
     * @return RcTag
     */
    public function setRcTagTrfYn($rcTagTrfYn)
    {
        $this->rcTagTrfYn = $rcTagTrfYn;

        return $this;
    }

    /**
     * Get rcTagTrfYn
     *
     * @return boolean
     */
    public function getRcTagTrfYn()
    {
        return $this->rcTagTrfYn;
    }
}
