<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ReReminder
 *
 * @ORM\Table(name="re_reminder")
 * @ORM\Entity
 */
class ReReminder
{

    const RE_REMINDER_LINK_TO_RV_RESERVATION = 1;
    const RE_REMINDER_LINK_TO_PR_PERSONA = 2;
    const RE_REMINDER_LINK_TO_REMINDERS = 3; // Consolidated
    const RE_REMINDER_REPEAT_NO =  0;
    const RE_REMINDER_REPEAT_YES = 1;
    const RE_REMINDER_STATUS_ACTIVE =  10;
    const RE_REMINDER_STATUS_SUSPENDED = 20;
    const RE_REMINDER_STATUS_FAILED = 30;
    const RE_REMINDER_STATUS_SENT = 40;
    const HASH_STRING = "50220678cd5af";
    const RE_REMINDER_INTERVAL = 2;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $reReminderIx;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_db", type="string", length=2, nullable=false)
     */
    private $reReminderDb = 'WB';

    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_id", type="integer", nullable=false)
     */
    private $reReminderId;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_note", type="text", length=65535, nullable=true)
     */
    private $reReminderNote;

    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_status_id", type="integer", nullable=false)
     */
    private $reReminderStatusId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="re_reminder_send_date", type="datetime", nullable=false)
     */
    private $reReminderSendDate = '0000-00-00 00:00:00';

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_send_date_tz", type="string", length=40, nullable=true)
     */
    private $reReminderSendDateTz;

    /**
     * @var boolean
     *
     * @ORM\Column(name="re_reminder_repeat_yn", type="boolean", nullable=false)
     */
    private $reReminderRepeatYn = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_link_to_ind_id", type="integer", nullable=false)
     */
    private $reReminderLinkToIndId;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_link_to_id", type="string", length=36, nullable=true)
     */
    private $reReminderLinkToId;

    /**
     * @var string
     *
     * @ORM\Column(name="aw_workflow_id", type="string", length=36, nullable=true)
     */
    private $awWorkflowId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false)
     */
    private $adCreateDate = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=true)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_modify_date", type="datetime", nullable=true)
     */
    private $adModifyDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_date_tz", type="string", length=40, nullable=true)
     */
    private $adModifyDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_modify_user_id", type="string", length=36, nullable=true)
     */
    private $adModifyUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var int
     *
     * @ORM\Column(name="re_reminder_trf_yn", type="boolean", nullable=false)
     */
    private $reReminderTrfYn;

    public function __construct() {

        $this->adModifyDate = new \DateTime();
        $this->adCreateDate = new \DateTime();
        $this->reReminderId = 0;
        $this->reReminderTrfYn = 0;
        $this->reReminderLinkToIndId = 0;
        $this->reReminderRepeatYn = 0;
        $this->reReminderStatusId = ReReminder::RE_REMINDER_STATUS_ACTIVE;
    }


    /**
     * Get reReminderIx
     *
     * @return string
     */
    public function getReReminderIx()
    {
        return $this->reReminderIx;
    }

    /**
     * Set reReminderDb
     *
     * @param string $reReminderDb
     *
     * @return ReReminder
     */
    public function setReReminderDb($reReminderDb)
    {
        $this->reReminderDb = $reReminderDb;

        return $this;
    }

    /**
     * Get reReminderDb
     *
     * @return string
     */
    public function getReReminderDb()
    {
        return $this->reReminderDb;
    }

    /**
     * Set reReminderId
     *
     * @param integer $reReminderId
     *
     * @return ReReminder
     */
    public function setReReminderId($reReminderId)
    {
        $this->reReminderId = $reReminderId;

        return $this;
    }

    /**
     * Get reReminderId
     *
     * @return integer
     */
    public function getReReminderId()
    {
        return $this->reReminderId;
    }

    /**
     * Set reReminderNote
     *
     * @param string $reReminderNote
     *
     * @return ReReminder
     */
    public function setReReminderNote($reReminderNote)
    {
        $this->reReminderNote = $reReminderNote;

        return $this;
    }

    /**
     * Get reReminderNote
     *
     * @return string
     */
    public function getReReminderNote()
    {
        return $this->reReminderNote;
    }

    /**
     * Set reReminderStatusId
     *
     * @param integer $reReminderStatusId
     *
     * @return ReReminder
     */
    public function setReReminderStatusId($reReminderStatusId)
    {
        $this->reReminderStatusId = $reReminderStatusId;

        return $this;
    }

    /**
     * Get reReminderStatusId
     *
     * @return integer
     */
    public function getReReminderStatusId()
    {
        return $this->reReminderStatusId;
    }

    /**
     * Set reReminderSendDate
     *
     * @param string $reReminderSendDate
     * @throws
     *
     * @return ReReminder
     */
    public function setReReminderSendDate($reReminderSendDate)
    {
        $this->reReminderSendDate = new \DateTime($reReminderSendDate);

        return $this;
    }

    /**
     * Get reReminderSendDate
     *
     * @return \DateTime
     */
    public function getReReminderSendDate()
    {
        return $this->reReminderSendDate;
    }

    /**
     * Set reReminderSendDateTz
     *
     * @param string $reReminderSendDateTz
     *
     * @return ReReminder
     */
    public function setReReminderSendDateTz($reReminderSendDateTz)
    {
        $this->reReminderSendDateTz = $reReminderSendDateTz;

        return $this;
    }

    /**
     * Get reReminderSendDateTz
     *
     * @return string
     */
    public function getReReminderSendDateTz()
    {
        return $this->reReminderSendDateTz;
    }

    /**
     * Set reReminderRepeatYn
     *
     * @param boolean $reReminderRepeatYn
     *
     * @return ReReminder
     */
    public function setReReminderRepeatYn($reReminderRepeatYn)
    {
        $this->reReminderRepeatYn = $reReminderRepeatYn;

        return $this;
    }

    /**
     * Get reReminderRepeatYn
     *
     * @return boolean
     */
    public function getReReminderRepeatYn()
    {
        return $this->reReminderRepeatYn;
    }

    /**
     * Set reReminderLinkToIndId
     *
     * @param integer $reReminderLinkToIndId
     *
     * @return ReReminder
     */
    public function setReReminderLinkToIndId($reReminderLinkToIndId)
    {
        $this->reReminderLinkToIndId = $reReminderLinkToIndId;

        return $this;
    }

    /**
     * Get reReminderLinkToIndId
     *
     * @return integer
     */
    public function getReReminderLinkToIndId()
    {
        return $this->reReminderLinkToIndId;
    }

    /**
     * Set reReminderLinkToId
     *
     * @param string $reReminderLinkToId
     *
     * @return ReReminder
     */
    public function setReReminderLinkToId($reReminderLinkToId)
    {
        $this->reReminderLinkToId = $reReminderLinkToId;

        return $this;
    }

    /**
     * Get reReminderLinkToId
     *
     * @return string
     */
    public function getReReminderLinkToId()
    {
        return $this->reReminderLinkToId;
    }

    /**
     * Set awWorkflowId
     *
     * @param string $awWorkflowId
     *
     * @return ReReminder
     */
    public function setAwWorkflowId($awWorkflowId)
    {
        $this->awWorkflowId = $awWorkflowId;

        return $this;
    }

    /**
     * Get awWorkflowId
     *
     * @return string
     */
    public function getAwWorkflowId()
    {
        return $this->awWorkflowId;
    }

    /**
     * Set adCreateDate
     *
     * @param string $adCreateDate
     * @throws
     *
     * @return ReReminder
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = ($adCreateDate === "") ? new \DateTime("now") : new \DateTime($adCreateDate);

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return ReReminder
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return ReReminder
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set adModifyDate
     *
     * @param string $adModifyDate
     * @throws
     *
     * @return ReReminder
     */
    public function setAdModifyDate($adModifyDate)
    {
        $this->adModifyDate = ($adModifyDate === "") ? new \DateTime('now') : new \DateTime($adModifyDate);

        return $this;
    }

    /**
     * Get adModifyDate
     *
     * @return \DateTime
     */
    public function getAdModifyDate()
    {
        return $this->adModifyDate;
    }

    /**
     * Set adModifyDateTz
     *
     * @param string $adModifyDateTz
     *
     * @return ReReminder
     */
    public function setAdModifyDateTz($adModifyDateTz)
    {
        $this->adModifyDateTz = $adModifyDateTz;

        return $this;
    }

    /**
     * Get adModifyDateTz
     *
     * @return string
     */
    public function getAdModifyDateTz()
    {
        return $this->adModifyDateTz;
    }

    /**
     * Set adModifyUserId
     *
     * @param string $adModifyUserId
     *
     * @return ReReminder
     */
    public function setAdModifyUserId($adModifyUserId)
    {
        $this->adModifyUserId = $adModifyUserId;

        return $this;
    }

    /**
     * Get adModifyUserId
     *
     * @return string
     */
    public function getAdModifyUserId()
    {
        return $this->adModifyUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ReReminder
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set reReminderTrfYn
     *
     * @param integer $reReminderTrfYn
     *
     * @return ReReminder
     */
    public function setReReminderTrfYn($reReminderTrfYn)
    {
        $this->reReminderTrfYn = $reReminderTrfYn;

        return $this;
    }

    /**
     * Get reReminderTrfYn
     *
     * @return boolean
     */
    public function getReReminderTrfYn()
    {
        return $this->reReminderTrfYn;
    }
}
