<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ReReminderLog
 *
 * @ORM\Table(name="re_reminder_log")
 * @ORM\Entity
 */
class ReReminderLog
{
    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_log_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $reReminderLogIx;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_log_db", type="string", length=2, nullable=false)
     */
    private $reReminderLogDb = 'WB';

    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_log_id", type="integer", nullable=false)
     */
    private $reReminderLogId;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_id", type="string", length=36, nullable=false)
     */
    private $reReminderId;

    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_log_status", type="integer", nullable=true)
     */
    private $reReminderLogStatus;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="re_reminder_log_date", type="datetime", nullable=false)
     */
    private $reReminderLogDate = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_log_date_tz", type="string", length=40, nullable=true)
     */
    private $reReminderLogDateTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false)
     */
    private $adCreateDate = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=true)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_id", type="string", length=36, nullable=true)
     */
    private $adCreateUserId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_log_trf_yn", type="integer", nullable=false)
     */
    private $reReminderLogTrfYn;


    public function __construct() {

        $this->adCreateDate = new \DateTime();
        $this->reReminderLogDate = new \DateTime();
        $this->reReminderLogTrfYn = 0;
        $this->reReminderLogStatus = 0;
        $this->reReminderLogId = 0;

    }

    /**
     * Get reReminderLogIx
     *
     * @return string
     */
    public function getReReminderLogIx()
    {
        return $this->reReminderLogIx;
    }

    /**
     * Set reReminderLogDb
     *
     * @param string $reReminderLogDb
     *
     * @return ReReminderLog
     */
    public function setReReminderLogDb($reReminderLogDb)
    {
        $this->reReminderLogDb = $reReminderLogDb;

        return $this;
    }

    /**
     * Get reReminderLogDb
     *
     * @return string
     */
    public function getReReminderLogDb()
    {
        return $this->reReminderLogDb;
    }

    /**
     * Set reReminderLogId
     *
     * @param integer $reReminderLogId
     *
     * @return ReReminderLog
     */
    public function setReReminderLogId($reReminderLogId)
    {
        $this->reReminderLogId = $reReminderLogId;

        return $this;
    }

    /**
     * Get reReminderLogId
     *
     * @return integer
     */
    public function getReReminderLogId()
    {
        return $this->reReminderLogId;
    }

    /**
     * Set reReminderId
     *
     * @param string $reReminderId
     *
     * @return ReReminderLog
     */
    public function setReReminderId($reReminderId)
    {
        $this->reReminderId = $reReminderId;

        return $this;
    }

    /**
     * Get reReminderId
     *
     * @return string
     */
    public function getReReminderId()
    {
        return $this->reReminderId;
    }

    /**
     * Set reReminderLogStatus
     *
     * @param integer $reReminderLogStatus
     *
     * @return ReReminderLog
     */
    public function setReReminderLogStatus($reReminderLogStatus)
    {
        $this->reReminderLogStatus = $reReminderLogStatus;

        return $this;
    }

    /**
     * Get reReminderLogStatus
     *
     * @return integer
     */
    public function getReReminderLogStatus()
    {
        return $this->reReminderLogStatus;
    }

    /**
     * Set reReminderLogDate
     *
     * @param \DateTime $reReminderLogDate
     *
     * @return ReReminderLog
     */
    public function setReReminderLogDate($reReminderLogDate)
    {
        $this->reReminderLogDate = $reReminderLogDate;

        return $this;
    }

    /**
     * Get reReminderLogDate
     *
     * @return \DateTime
     */
    public function getReReminderLogDate()
    {
        return $this->reReminderLogDate;
    }

    /**
     * Set reReminderLogDateTz
     *
     * @param string $reReminderLogDateTz
     *
     * @return ReReminderLog
     */
    public function setReReminderLogDateTz($reReminderLogDateTz)
    {
        $this->reReminderLogDateTz = $reReminderLogDateTz;

        return $this;
    }

    /**
     * Get reReminderLogDateTz
     *
     * @return string
     */
    public function getReReminderLogDateTz()
    {
        return $this->reReminderLogDateTz;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return ReReminderLog
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return ReReminderLog
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserId
     *
     * @param string $adCreateUserId
     *
     * @return ReReminderLog
     */
    public function setAdCreateUserId($adCreateUserId)
    {
        $this->adCreateUserId = $adCreateUserId;

        return $this;
    }

    /**
     * Get adCreateUserId
     *
     * @return string
     */
    public function getAdCreateUserId()
    {
        return $this->adCreateUserId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ReReminderLog
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set reReminderLogTrfYn
     *
     * @param integer $reReminderLogTrfYn
     *
     * @return ReReminderLog
     */
    public function setReReminderLogTrfYn($reReminderLogTrfYn)
    {
        $this->reReminderLogTrfYn = $reReminderLogTrfYn;

        return $this;
    }

    /**
     * Get reReminderLogTrfYn
     *
     * @return integer
     */
    public function getReReminderLogTrfYn()
    {
        return $this->reReminderLogTrfYn;
    }
}
